/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.InternalReader;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.ValueArray;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantTestUtil;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.FieldSource;
import org.junit.jupiter.params.provider.MethodSource;

public class TestVariantReaders {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"var", (Type)Types.VariantType.get())});
    private static final LogicalTypeAnnotation STRING = LogicalTypeAnnotation.stringType();
    private static final ByteBuffer TEST_METADATA_BUFFER = VariantTestUtil.createMetadata((Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), (boolean)true);
    private static final ByteBuffer TEST_OBJECT_BUFFER = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, (Map)ImmutableMap.of((Object)"a", (Object)Variants.ofNull(), (Object)"d", (Object)Variants.of((String)"iceberg")));
    private static final VariantMetadata EMPTY_METADATA = Variants.metadata((ByteBuffer)VariantTestUtil.emptyMetadata());
    private static final VariantMetadata TEST_METADATA = Variants.metadata((ByteBuffer)TEST_METADATA_BUFFER);
    private static final VariantObject TEST_OBJECT = (VariantObject)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)TEST_OBJECT_BUFFER);
    private static final VariantPrimitive<?>[] PRIMITIVES = new VariantPrimitive[]{Variants.ofNull(), Variants.of((boolean)true), Variants.of((boolean)false), Variants.of((byte)34), Variants.of((byte)-34), Variants.of((short)1234), Variants.of((short)-1234), Variants.of((int)12345), Variants.of((int)-12345), Variants.of((long)9876543210L), Variants.of((long)-9876543210L), Variants.of((float)10.11f), Variants.of((float)-10.11f), Variants.of((double)14.3), Variants.of((double)-14.3), Variants.ofIsoDate((String)"2024-11-07"), Variants.ofIsoDate((String)"1957-11-07"), Variants.ofIsoTimestamptz((String)"2024-11-07T12:33:54.123456+00:00"), Variants.ofIsoTimestamptz((String)"1957-11-07T12:33:54.123456+00:00"), Variants.ofIsoTimestampntz((String)"2024-11-07T12:33:54.123456"), Variants.ofIsoTimestampntz((String)"1957-11-07T12:33:54.123456"), Variants.of((BigDecimal)new BigDecimal("12345.6789")), Variants.of((BigDecimal)new BigDecimal("-12345.6789")), Variants.of((BigDecimal)new BigDecimal("123456789.987654321")), Variants.of((BigDecimal)new BigDecimal("-123456789.987654321")), Variants.of((BigDecimal)new BigDecimal("9876543210.123456789")), Variants.of((BigDecimal)new BigDecimal("-9876543210.123456789")), Variants.of((ByteBuffer)ByteBuffer.wrap(new byte[]{10, 11, 12, 13})), Variants.of((String)"iceberg"), Variants.ofIsoTime((String)"12:33:54.123456"), Variants.ofIsoTimestamptzNanos((String)"2024-11-07T12:33:54.123456789+00:00"), Variants.ofIsoTimestamptzNanos((String)"1957-11-07T12:33:54.123456789+00:00"), Variants.ofIsoTimestampntzNanos((String)"2024-11-07T12:33:54.123456789"), Variants.ofIsoTimestampntzNanos((String)"1957-11-07T12:33:54.123456789"), Variants.ofUUID((String)"f24f9b64-81fa-49d1-b74e-8c09a6e31c56")};
    private static final ParquetConfiguration CONF = new PlainParquetConfiguration(Map.of("parquet.avro.write-old-list-structure", "false", "parquet.avro.add-list-element-records", "false"));

    private static Stream<Arguments> metadataAndValues() {
        Stream<Arguments> primitives = Stream.of(PRIMITIVES).map(variant -> Arguments.of((Object[])new Object[]{EMPTY_METADATA, variant}));
        Stream<Arguments> object = Stream.of(Arguments.of((Object[])new Object[]{TEST_METADATA, TEST_OBJECT}));
        return Streams.concat((Stream[])new Stream[]{primitives, object});
    }

    @ParameterizedTest
    @MethodSource(value={"metadataAndValues"})
    public void testUnshreddedVariants(VariantMetadata metadata, VariantValue expected) throws IOException {
        GroupType variantType = TestVariantReaders.variant("var", 2);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TestVariantReaders.serialize(metadata), "value", TestVariantReaders.serialize(expected)));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)metadata, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @ParameterizedTest
    @MethodSource(value={"metadataAndValues"})
    public void testUnshreddedVariantsWithShreddedSchema(VariantMetadata metadata, VariantValue expected) throws IOException {
        GroupType variantType = TestVariantReaders.variant("var", 2, TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TestVariantReaders.serialize(metadata), "value", TestVariantReaders.serialize(expected)));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)metadata, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @ParameterizedTest
    @FieldSource(value={"PRIMITIVES"})
    public void testShreddedVariantPrimitives(VariantPrimitive<?> primitive) throws IOException {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)primitive.type()).as("Null is not a shredded type", new Object[0])).isNotEqualTo((Object)PhysicalType.NULL);
        GroupType variantType = TestVariantReaders.variant("var", 2, TestVariantReaders.shreddedType(primitive));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", TestVariantReaders.toAvroValue(primitive)));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual(primitive, (VariantValue)actualVariant.value());
    }

    @Test
    public void testNullValueAndNullTypedValue() throws IOException {
        GroupType variantType = TestVariantReaders.variant("var", 2, TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata()));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)Variants.ofNull(), (VariantValue)actualVariant.value());
    }

    @Test
    public void testMissingValueColumn() throws IOException {
        GroupType variantType = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).id(2)).required(PrimitiveType.PrimitiveTypeName.BINARY).named("metadata")).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32))).named("var");
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", 34));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)Variants.of((int)34), (VariantValue)actualVariant.value());
    }

    @Test
    public void testValueAndTypedValueConflict() {
        GroupType variantType = TestVariantReaders.variant("var", 2, TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "value", TestVariantReaders.serialize((VariantValue)Variants.of((String)"str")), "typed_value", 34));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVariantReaders.writeAndRead(parquetSchema, record)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid variant, conflicting value and typed_value");
    }

    @Test
    public void testUnsignedInteger() {
        GroupType variantType = TestVariantReaders.variant("var", 2, TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)false)));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata()));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVariantReaders.writeAndRead(parquetSchema, record)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Unsupported shredded value type: INTEGER(32,false)");
    }

    @Test
    public void testFixedLengthByteArray() {
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).named("typed_value"));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata()));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVariantReaders.writeAndRead(parquetSchema, record)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Unsupported shredded value type: optional fixed_len_byte_array(4) typed_value");
    }

    @Test
    public void testShreddedObject() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.ofNull())));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", ""));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.ofNull());
        expected.put("b", (VariantValue)Variants.of((String)""));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testShreddedObjectMissingValueColumn() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).id(2)).required(PrimitiveType.PrimitiveTypeName.BINARY).named("metadata")).addField((org.apache.parquet.schema.Type)objectFields)).named("var");
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((short)1234))));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.of((short)1234));
        expected.put("b", (VariantValue)Variants.of((String)"iceberg"));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testShreddedObjectMissingField() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((boolean)false))));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of());
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.of((boolean)false));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testEmptyShreddedObject() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of());
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of());
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testShreddedObjectMissingFieldValueColumn() throws IOException {
        GroupType fieldA = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32))).named("a");
        GroupType fieldB = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING))).named("b");
        GroupType objectFields = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addFields(new org.apache.parquet.schema.Type[]{fieldA, fieldB})).named("typed_value");
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of());
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("b", (VariantValue)Variants.of((String)"iceberg"));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testShreddedObjectMissingTypedValue() throws IOException {
        GroupType fieldA = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).named("a");
        GroupType fieldB = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).named("b");
        GroupType objectFields = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addFields(new org.apache.parquet.schema.Type[]{fieldA, fieldB})).named("typed_value");
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of());
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((String)"iceberg"))));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("b", (VariantValue)Variants.of((String)"iceberg"));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testShreddedObjectWithinShreddedObject() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType innerFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType fieldC = TestVariantReaders.field("c", (org.apache.parquet.schema.Type)innerFields);
        GroupType fieldD = TestVariantReaders.field("d", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.DOUBLE));
        GroupType outerFields = TestVariantReaders.objectFields(fieldC, fieldD);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)outerFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("typed_value", 34));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord inner = TestVariantReaders.record(innerFields, Map.of("a", recordA, "b", recordB));
        GenericRecord recordC = TestVariantReaders.record(fieldC, Map.of("typed_value", inner));
        GenericRecord recordD = TestVariantReaders.record(fieldD, Map.of("typed_value", -0.0));
        GenericRecord outer = TestVariantReaders.record(outerFields, Map.of("c", recordC, "d", recordD));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", outer));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expectedInner = Variants.object((VariantMetadata)TEST_METADATA);
        expectedInner.put("a", (VariantValue)Variants.of((int)34));
        expectedInner.put("b", (VariantValue)Variants.of((String)"iceberg"));
        ShreddedObject expectedOuter = Variants.object((VariantMetadata)TEST_METADATA);
        expectedOuter.put("c", (VariantValue)expectedInner);
        expectedOuter.put("d", (VariantValue)Variants.of((double)-0.0));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedOuter, (VariantValue)actualVariant.value());
    }

    @Test
    public void testShreddedObjectWithOptionalFieldStructs() throws IOException {
        GroupType fieldA = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32))).named("a");
        GroupType fieldB = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING))).named("b");
        GroupType fieldC = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.DOUBLE))).named("c");
        GroupType fieldD = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).addField(TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BOOLEAN))).named("d");
        GroupType objectFields = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addFields(new org.apache.parquet.schema.Type[]{fieldA, fieldB, fieldC, fieldD})).named("typed_value");
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((int)34))));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord recordC = TestVariantReaders.record(fieldC, Map.of());
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB, "c", recordC));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.of((int)34));
        expected.put("b", (VariantValue)Variants.of((String)"iceberg"));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testPartiallyShreddedObject() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        ShreddedObject baseObject = Variants.object((VariantMetadata)TEST_METADATA);
        baseObject.put("d", (VariantValue)Variants.ofIsoDate((String)"2024-01-30"));
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.ofNull())));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", TestVariantReaders.serialize((VariantValue)baseObject), "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.ofNull());
        expected.put("b", (VariantValue)Variants.of((String)"iceberg"));
        expected.put("d", (VariantValue)Variants.ofIsoDate((String)"2024-01-30"));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testPartiallyShreddedObjectFieldConflict() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        ByteBuffer baseObjectBuffer = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, Map.of("b", Variants.ofIsoDate((String)"2024-01-30")));
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.ofNull())));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", baseObjectBuffer, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.ofNull());
        expected.put("b", (VariantValue)Variants.of((String)"iceberg"));
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testPartiallyShreddedObjectMissingFieldConflict() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        ByteBuffer baseObjectBuffer = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, Map.of("b", Variants.ofIsoDate((String)"2024-01-30")));
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.ofNull())));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of());
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", baseObjectBuffer, "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        ShreddedObject expected = Variants.object((VariantMetadata)TEST_METADATA);
        expected.put("a", (VariantValue)Variants.ofNull());
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected, (VariantValue)actualVariant.value());
    }

    @Test
    public void testNonObjectWithNullShreddedFields() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", TestVariantReaders.serialize((VariantValue)Variants.of((int)34))));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)Variants.of((int)34), (VariantValue)actualVariant.value());
    }

    @Test
    public void testNonObjectWithNonNullShreddedFields() {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.ofNull())));
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((long)9876543210L))));
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", TestVariantReaders.serialize((VariantValue)Variants.of((int)34)), "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVariantReaders.writeAndRead(parquetSchema, record)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid variant, non-object value with shredded fields");
    }

    @Test
    public void testEmptyPartiallyShreddedObjectConflict() {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType objectFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)objectFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord recordA = TestVariantReaders.record(fieldA, Map.of());
        GenericRecord recordB = TestVariantReaders.record(fieldB, Map.of());
        GenericRecord fields = TestVariantReaders.record(objectFields, Map.of("a", recordA, "b", recordB));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", TestVariantReaders.serialize((VariantValue)Variants.ofNull()), "typed_value", fields));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVariantReaders.writeAndRead(parquetSchema, record)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid variant, non-object value with shredded fields");
    }

    @Test
    public void testMixedRecords() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType innerFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType fieldC = TestVariantReaders.field("c", (org.apache.parquet.schema.Type)innerFields);
        GroupType fieldD = TestVariantReaders.field("d", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.DOUBLE));
        GroupType outerFields = TestVariantReaders.objectFields(fieldC, fieldD);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)outerFields);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord zero = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 0));
        GenericRecord a1 = TestVariantReaders.record(fieldA, Map.of());
        GenericRecord b1 = TestVariantReaders.record(fieldB, Map.of("typed_value", "iceberg"));
        GenericRecord inner1 = TestVariantReaders.record(innerFields, Map.of("a", a1, "b", b1));
        GenericRecord c1 = TestVariantReaders.record(fieldC, Map.of("typed_value", inner1));
        GenericRecord d1 = TestVariantReaders.record(fieldD, Map.of());
        GenericRecord outer1 = TestVariantReaders.record(outerFields, Map.of("c", c1, "d", d1));
        GenericRecord variant1 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", outer1));
        GenericRecord one = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant1));
        ShreddedObject expectedC1 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedC1.put("b", (VariantValue)Variants.of((String)"iceberg"));
        ShreddedObject expectedOne = Variants.object((VariantMetadata)TEST_METADATA);
        expectedOne.put("c", (VariantValue)expectedC1);
        GenericRecord c2 = TestVariantReaders.record(fieldC, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((byte)8))));
        GenericRecord d2 = TestVariantReaders.record(fieldD, Map.of("typed_value", -0.0));
        GenericRecord outer2 = TestVariantReaders.record(outerFields, Map.of("c", c2, "d", d2));
        GenericRecord variant2 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", outer2));
        GenericRecord two = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 2, "var", variant2));
        ShreddedObject expectedTwo = Variants.object((VariantMetadata)TEST_METADATA);
        expectedTwo.put("c", (VariantValue)Variants.of((byte)8));
        expectedTwo.put("d", (VariantValue)Variants.of((double)-0.0));
        GenericRecord a3 = TestVariantReaders.record(fieldA, Map.of("typed_value", 34));
        GenericRecord b3 = TestVariantReaders.record(fieldB, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((String)""))));
        GenericRecord inner3 = TestVariantReaders.record(innerFields, Map.of("a", a3, "b", b3));
        GenericRecord c3 = TestVariantReaders.record(fieldC, Map.of("typed_value", inner3));
        GenericRecord d3 = TestVariantReaders.record(fieldD, Map.of("typed_value", 0.0));
        GenericRecord outer3 = TestVariantReaders.record(outerFields, Map.of("c", c3, "d", d3));
        GenericRecord variant3 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", outer3));
        GenericRecord three = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 3, "var", variant3));
        ShreddedObject expectedC3 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedC3.put("a", (VariantValue)Variants.of((int)34));
        expectedC3.put("b", (VariantValue)Variants.of((String)""));
        ShreddedObject expectedThree = Variants.object((VariantMetadata)TEST_METADATA);
        expectedThree.put("c", (VariantValue)expectedC3);
        expectedThree.put("d", (VariantValue)Variants.of((double)0.0));
        List<Record> records = TestVariantReaders.writeAndRead(parquetSchema, List.of(zero, one, two, three));
        Record actualZero = records.get(0);
        Assertions.assertThat((Object)actualZero.getField("id")).isEqualTo((Object)0);
        Assertions.assertThat((Object)actualZero.getField("var")).isNull();
        Record actualOne = records.get(1);
        Assertions.assertThat((Object)actualOne.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actualOne.getField("var")).isInstanceOf(Variant.class);
        Variant actualOneVariant = (Variant)actualOne.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualOneVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedOne, (VariantValue)actualOneVariant.value());
        Record actualTwo = records.get(2);
        Assertions.assertThat((Object)actualTwo.getField("id")).isEqualTo((Object)2);
        Assertions.assertThat((Object)actualTwo.getField("var")).isInstanceOf(Variant.class);
        Variant actualTwoVariant = (Variant)actualTwo.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualTwoVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedTwo, (VariantValue)actualTwoVariant.value());
        Record actualThree = records.get(3);
        Assertions.assertThat((Object)actualThree.getField("id")).isEqualTo((Object)3);
        Assertions.assertThat((Object)actualThree.getField("var")).isInstanceOf(Variant.class);
        Variant actualThreeVariant = (Variant)actualThree.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualThreeVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedThree, (VariantValue)actualThreeVariant.value());
    }

    @Test
    public void testSimpleArray() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List<GenericRecord> arr = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "comedy")), TestVariantReaders.record(elementType, Map.of("typed_value", "drama")));
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", arr));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        ValueArray expectedArray = Variants.array();
        expectedArray.add((VariantValue)Variants.of((String)"comedy"));
        expectedArray.add((VariantValue)Variants.of((String)"drama"));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray, (VariantValue)actualVariant.value());
    }

    @Test
    public void testNullArray() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(TestVariantReaders.element(shreddedType)));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "value", TestVariantReaders.serialize((VariantValue)Variants.ofNull())));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)Variants.ofNull(), (VariantValue)actualVariant.value());
    }

    @Test
    public void testEmptyArray() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(TestVariantReaders.element(shreddedType)));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List arr = List.of();
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", arr));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        Assertions.assertThat((Comparable)actualVariant.value().type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)actualVariant.value().asArray().numElements()).isEqualTo(0);
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
    }

    @Test
    public void testArrayWithNull() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List<GenericRecord> arr = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "comedy")), TestVariantReaders.record(elementType, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.ofNull()))), TestVariantReaders.record(elementType, Map.of("typed_value", "drama")));
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", arr));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        ValueArray expectedArray = Variants.array();
        expectedArray.add((VariantValue)Variants.of((String)"comedy"));
        expectedArray.add((VariantValue)Variants.ofNull());
        expectedArray.add((VariantValue)Variants.of((String)"drama"));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        Assertions.assertThat((Comparable)actualVariant.value().type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)actualVariant.value().asArray().numElements()).isEqualTo(3);
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray, (VariantValue)actualVariant.value());
    }

    @Test
    public void testNestedArray() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType outerElementType = TestVariantReaders.element((org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(outerElementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List<GenericRecord> inner1 = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "comedy")), TestVariantReaders.record(elementType, Map.of("typed_value", "drama")));
        List<GenericRecord> outer1 = List.of(TestVariantReaders.record(outerElementType, Map.of("typed_value", inner1)), TestVariantReaders.record(outerElementType, Map.of("typed_value", List.of())));
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", outer1));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        ValueArray expectedArray = Variants.array();
        ValueArray expectedInner1 = Variants.array();
        expectedInner1.add((VariantValue)Variants.of((String)"comedy"));
        expectedInner1.add((VariantValue)Variants.of((String)"drama"));
        ValueArray expectedInner2 = Variants.array();
        expectedArray.add((VariantValue)expectedInner1);
        expectedArray.add((VariantValue)expectedInner2);
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray, (VariantValue)actualVariant.value());
    }

    @Test
    public void testArrayWithNestedObject() throws IOException {
        GroupType fieldA = TestVariantReaders.field("a", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32));
        GroupType fieldB = TestVariantReaders.field("b", TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING));
        GroupType shreddedFields = TestVariantReaders.objectFields(fieldA, fieldB);
        GroupType elementType = TestVariantReaders.element((org.apache.parquet.schema.Type)shreddedFields);
        GroupType listType = TestVariantReaders.list(elementType);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)listType);
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord shredded1 = TestVariantReaders.record(shreddedFields, Map.of("a", TestVariantReaders.record(fieldA, Map.of("typed_value", 1)), "b", TestVariantReaders.record(fieldB, Map.of("typed_value", "comedy"))));
        GenericRecord shredded2 = TestVariantReaders.record(shreddedFields, Map.of("a", TestVariantReaders.record(fieldA, Map.of("typed_value", 2)), "b", TestVariantReaders.record(fieldB, Map.of("typed_value", "drama"))));
        List<GenericRecord> arr1 = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", shredded1)), TestVariantReaders.record(elementType, Map.of("typed_value", shredded2)));
        GenericRecord var1 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", arr1));
        GenericRecord row1 = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var1));
        ValueArray expected1 = Variants.array();
        ShreddedObject expectedElement1 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedElement1.put("a", (VariantValue)Variants.of((int)1));
        expectedElement1.put("b", (VariantValue)Variants.of((String)"comedy"));
        expected1.add((VariantValue)expectedElement1);
        ShreddedObject expectedElement2 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedElement2.put("a", (VariantValue)Variants.of((int)2));
        expectedElement2.put("b", (VariantValue)Variants.of((String)"drama"));
        expected1.add((VariantValue)expectedElement2);
        GenericRecord shredded3 = TestVariantReaders.record(shreddedFields, Map.of("a", TestVariantReaders.record(fieldA, Map.of("typed_value", 3)), "b", TestVariantReaders.record(fieldB, Map.of("typed_value", "action"))));
        ShreddedObject baseObject3 = Variants.object((VariantMetadata)TEST_METADATA);
        baseObject3.put("c", (VariantValue)Variants.of((String)"str"));
        GenericRecord shredded4 = TestVariantReaders.record(shreddedFields, Map.of("a", TestVariantReaders.record(fieldA, Map.of("typed_value", 4)), "b", TestVariantReaders.record(fieldB, Map.of("typed_value", "horror"))));
        ShreddedObject baseObject4 = Variants.object((VariantMetadata)TEST_METADATA);
        baseObject4.put("d", (VariantValue)Variants.ofIsoDate((String)"2024-01-30"));
        List<GenericRecord> arr2 = List.of(TestVariantReaders.record(elementType, Map.of("value", TestVariantReaders.serialize((VariantValue)baseObject3), "typed_value", shredded3)), TestVariantReaders.record(elementType, Map.of("value", TestVariantReaders.serialize((VariantValue)baseObject4), "typed_value", shredded4)));
        GenericRecord var2 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", arr2));
        GenericRecord row2 = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 2, "var", var2));
        ValueArray expected2 = Variants.array();
        ShreddedObject expectedElement3 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedElement3.put("a", (VariantValue)Variants.of((int)3));
        expectedElement3.put("b", (VariantValue)Variants.of((String)"action"));
        expectedElement3.put("c", (VariantValue)Variants.of((String)"str"));
        expected2.add((VariantValue)expectedElement3);
        ShreddedObject expectedElement4 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedElement4.put("a", (VariantValue)Variants.of((int)4));
        expectedElement4.put("b", (VariantValue)Variants.of((String)"horror"));
        expectedElement4.put("d", (VariantValue)Variants.ofIsoDate((String)"2024-01-30"));
        expected2.add((VariantValue)expectedElement4);
        List<Record> actual = TestVariantReaders.writeAndRead(parquetSchema, List.of(row1, row2));
        Record actual1 = actual.get(0);
        Assertions.assertThat((Object)actual1.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual1.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant1 = (Variant)actual1.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant1.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected1, (VariantValue)actualVariant1.value());
        Record actual2 = actual.get(1);
        Assertions.assertThat((Object)actual2.getField("id")).isEqualTo((Object)2);
        Assertions.assertThat((Object)actual2.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant2 = (Variant)actual2.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant2.metadata());
        VariantTestUtil.assertEqual((VariantValue)expected2, (VariantValue)actualVariant2.value());
    }

    @Test
    public void testArrayWithNonArray() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List<GenericRecord> arr1 = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "comedy")), TestVariantReaders.record(elementType, Map.of("typed_value", "drama")));
        GenericRecord var1 = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", arr1));
        GenericRecord row1 = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var1));
        ValueArray expectedArray1 = Variants.array();
        expectedArray1.add((VariantValue)Variants.of((String)"comedy"));
        expectedArray1.add((VariantValue)Variants.of((String)"drama"));
        GenericRecord var2 = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "value", TestVariantReaders.serialize((VariantValue)Variants.of((int)34))));
        GenericRecord row2 = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 2, "var", var2));
        VariantPrimitive expectedValue2 = Variants.of((PhysicalType)PhysicalType.INT32, (Object)34);
        GenericRecord var3 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "value", TEST_OBJECT_BUFFER));
        GenericRecord row3 = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 3, "var", var3));
        ShreddedObject expectedObject3 = Variants.object((VariantMetadata)TEST_METADATA);
        expectedObject3.put("a", (VariantValue)Variants.ofNull());
        expectedObject3.put("d", (VariantValue)Variants.of((String)"iceberg"));
        List<GenericRecord> arr4 = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "action")), TestVariantReaders.record(elementType, Map.of("typed_value", "horror")));
        GenericRecord var4 = TestVariantReaders.record(variantType, Map.of("metadata", TEST_METADATA_BUFFER, "typed_value", arr4));
        GenericRecord row4 = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 4, "var", var4));
        ValueArray expectedArray4 = Variants.array();
        expectedArray4.add((VariantValue)Variants.of((String)"action"));
        expectedArray4.add((VariantValue)Variants.of((String)"horror"));
        List<Record> actual = TestVariantReaders.writeAndRead(parquetSchema, List.of(row1, row2, row3, row4));
        Record actual1 = actual.get(0);
        Assertions.assertThat((Object)actual1.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual1.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant1 = (Variant)actual1.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant1.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray1, (VariantValue)actualVariant1.value());
        Record actual2 = actual.get(1);
        Assertions.assertThat((Object)actual2.getField("id")).isEqualTo((Object)2);
        Assertions.assertThat((Object)actual2.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant2 = (Variant)actual2.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant2.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedValue2, (VariantValue)actualVariant2.value());
        Record actual3 = actual.get(2);
        Assertions.assertThat((Object)actual3.getField("id")).isEqualTo((Object)3);
        Assertions.assertThat((Object)actual3.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant3 = (Variant)actual3.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant3.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedObject3, (VariantValue)actualVariant3.value());
        Record actual4 = actual.get(3);
        Assertions.assertThat((Object)actual4.getField("id")).isEqualTo((Object)4);
        Assertions.assertThat((Object)actual4.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant4 = (Variant)actual4.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)TEST_METADATA, (VariantMetadata)actualVariant4.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray4, (VariantValue)actualVariant4.value());
    }

    @Test
    public void testArrayMissingValueColumn() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType variantType = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).id(2)).required(PrimitiveType.PrimitiveTypeName.BINARY).named("metadata")).addField((org.apache.parquet.schema.Type)TestVariantReaders.list(elementType))).named("var");
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List<GenericRecord> arr = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "comedy")), TestVariantReaders.record(elementType, Map.of("typed_value", "drama")));
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", arr));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        ValueArray expectedArray = Variants.array();
        expectedArray.add((VariantValue)Variants.of((String)"comedy"));
        expectedArray.add((VariantValue)Variants.of((String)"drama"));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray, (VariantValue)actualVariant.value());
    }

    @Test
    public void testArrayMissingElementValueColumn() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).addField(shreddedType)).named("element");
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        List<GenericRecord> arr = List.of(TestVariantReaders.record(elementType, Map.of("typed_value", "comedy")), TestVariantReaders.record(elementType, Map.of("typed_value", "drama")));
        GenericRecord var = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", arr));
        GenericRecord row = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", var));
        ValueArray expectedArray = Variants.array();
        expectedArray.add((VariantValue)Variants.of((String)"comedy"));
        expectedArray.add((VariantValue)Variants.of((String)"drama"));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, row);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantTestUtil.assertEqual((VariantValue)expectedArray, (VariantValue)actualVariant.value());
    }

    @Test
    public void testArrayWithElementNullValueAndNullTypedValue() throws IOException {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord element = TestVariantReaders.record(elementType, Map.of());
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", List.of(element)));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        Record actual = TestVariantReaders.writeAndRead(parquetSchema, record);
        Assertions.assertThat((Object)actual.getField("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)actual.getField("var")).isInstanceOf(Variant.class);
        Variant actualVariant = (Variant)actual.getField("var");
        VariantTestUtil.assertEqual((VariantMetadata)EMPTY_METADATA, (VariantMetadata)actualVariant.metadata());
        VariantValue actualValue = actualVariant.value();
        Assertions.assertThat((Comparable)actualValue.type()).isEqualTo((Object)PhysicalType.ARRAY);
        Assertions.assertThat((int)actualValue.asArray().numElements()).isEqualTo(1);
        VariantTestUtil.assertEqual((VariantValue)Variants.ofNull(), (VariantValue)actualValue.asArray().get(0));
    }

    @Test
    public void testArrayWithElementValueTypedValueConflict() {
        org.apache.parquet.schema.Type shreddedType = TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
        GroupType elementType = TestVariantReaders.element(shreddedType);
        GroupType variantType = TestVariantReaders.variant("var", 2, (org.apache.parquet.schema.Type)TestVariantReaders.list(elementType));
        MessageType parquetSchema = TestVariantReaders.parquetSchema((org.apache.parquet.schema.Type)variantType);
        GenericRecord element = TestVariantReaders.record(elementType, Map.of("value", TestVariantReaders.serialize((VariantValue)Variants.of((int)3)), "typed_value", "comedy"));
        GenericRecord variant = TestVariantReaders.record(variantType, Map.of("metadata", VariantTestUtil.emptyMetadata(), "typed_value", List.of(element)));
        GenericRecord record = TestVariantReaders.record((GroupType)parquetSchema, Map.of("id", 1, "var", variant));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestVariantReaders.writeAndRead(parquetSchema, record)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid variant, conflicting value and typed_value");
    }

    private static ByteBuffer serialize(VariantValue value) {
        ByteBuffer buffer = ByteBuffer.allocate(value.sizeInBytes()).order(ByteOrder.LITTLE_ENDIAN);
        value.writeTo(buffer, 0);
        return buffer;
    }

    private static ByteBuffer serialize(VariantMetadata metadata) {
        ByteBuffer buffer = ByteBuffer.allocate(metadata.sizeInBytes()).order(ByteOrder.LITTLE_ENDIAN);
        metadata.writeTo(buffer, 0);
        return buffer;
    }

    private static GenericRecord record(GroupType type, Map<String, Object> fields) {
        GenericData.Record record = new GenericData.Record(TestVariantReaders.avroSchema(type));
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            record.put(entry.getKey(), entry.getValue());
        }
        return record;
    }

    static Record writeAndRead(MessageType parquetSchema, GenericRecord record) throws IOException {
        return (Record)Iterables.getOnlyElement(TestVariantReaders.writeAndRead(parquetSchema, List.of(record)));
    }

    static List<Record> writeAndRead(MessageType parquetSchema, List<GenericRecord> records) throws IOException {
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        try (ParquetWriter writer = ((TestWriterBuilder)new TestWriterBuilder((OutputFile)outputFile).withFileType(parquetSchema).withConf(CONF)).build();){
            for (GenericRecord record : records) {
                writer.write((Object)record);
            }
        }
        try (CloseableIterable reader = Parquet.read((InputFile)outputFile.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> InternalReader.create((Schema)SCHEMA, (MessageType)fileSchema)).build();){
            ArrayList arrayList = Lists.newArrayList((Iterable)reader);
            return arrayList;
        }
    }

    private static MessageType parquetSchema(org.apache.parquet.schema.Type variantType) {
        return (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).id(1)).named("id")).addField(variantType)).named("table");
    }

    private static GroupType variant(String name, int fieldId) {
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).id(fieldId)).required(PrimitiveType.PrimitiveTypeName.BINARY).named("metadata")).required(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).named(name);
    }

    private static void checkShreddedType(org.apache.parquet.schema.Type shreddedType) {
        Preconditions.checkArgument((boolean)shreddedType.getName().equals("typed_value"), (String)"Invalid shredded type name: %s should be typed_value", (Object)shreddedType.getName());
        Preconditions.checkArgument((boolean)shreddedType.isRepetition(Type.Repetition.OPTIONAL), (String)"Invalid shredded type repetition: %s should be OPTIONAL", (Object)shreddedType.getRepetition());
    }

    private static org.apache.parquet.schema.Type shreddedPrimitive(PrimitiveType.PrimitiveTypeName primitive) {
        return (org.apache.parquet.schema.Type)Types.optional((PrimitiveType.PrimitiveTypeName)primitive).named("typed_value");
    }

    private static org.apache.parquet.schema.Type shreddedPrimitive(PrimitiveType.PrimitiveTypeName primitive, LogicalTypeAnnotation annotation) {
        return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)primitive).as(annotation)).named("typed_value");
    }

    private static org.apache.parquet.schema.Type shreddedType(VariantValue value) {
        switch (value.type()) {
            case BOOLEAN_TRUE: 
            case BOOLEAN_FALSE: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BOOLEAN);
            }
            case INT8: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8));
            }
            case INT16: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16));
            }
            case INT32: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32);
            }
            case INT64: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64);
            }
            case FLOAT: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.FLOAT);
            }
            case DOUBLE: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.DOUBLE);
            }
            case DECIMAL4: {
                BigDecimal decimal4 = (BigDecimal)value.asPrimitive().get();
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimal4.scale(), (int)9));
            }
            case DECIMAL8: {
                BigDecimal decimal8 = (BigDecimal)value.asPrimitive().get();
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimal8.scale(), (int)18));
            }
            case DECIMAL16: {
                BigDecimal decimal16 = (BigDecimal)value.asPrimitive().get();
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimal16.scale(), (int)38));
            }
            case DATE: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
            }
            case TIMESTAMPTZ: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
            }
            case TIMESTAMPNTZ: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
            }
            case BINARY: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }
            case STRING: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, STRING);
            }
            case TIME: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
            }
            case TIMESTAMPTZ_NANOS: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
            }
            case TIMESTAMPNTZ_NANOS: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
            }
            case UUID: {
                return TestVariantReaders.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType());
            }
        }
        throw new UnsupportedOperationException("Unsupported shredding type: " + String.valueOf(value.type()));
    }

    private static Object toAvroValue(VariantPrimitive<?> variant) {
        switch (variant.type()) {
            case DECIMAL4: {
                return ((BigDecimal)variant.get()).unscaledValue().intValueExact();
            }
            case DECIMAL8: {
                return ((BigDecimal)variant.get()).unscaledValue().longValueExact();
            }
            case DECIMAL16: {
                return ((BigDecimal)variant.get()).unscaledValue().toByteArray();
            }
        }
        return variant.get();
    }

    private static GroupType variant(String name, int fieldId, org.apache.parquet.schema.Type shreddedType) {
        TestVariantReaders.checkShreddedType(shreddedType);
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).id(fieldId)).required(PrimitiveType.PrimitiveTypeName.BINARY).named("metadata")).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).addField(shreddedType)).named(name);
    }

    private static void checkField(GroupType fieldType) {
        Preconditions.checkArgument((boolean)fieldType.isRepetition(Type.Repetition.REQUIRED), (String)"Invalid field type repetition: %s should be REQUIRED", (Object)fieldType.getRepetition());
    }

    private static GroupType objectFields(GroupType ... fields) {
        for (GroupType fieldType : fields) {
            TestVariantReaders.checkField(fieldType);
        }
        return (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addFields((org.apache.parquet.schema.Type[])fields)).named("typed_value");
    }

    private static GroupType field(String name, org.apache.parquet.schema.Type shreddedType) {
        TestVariantReaders.checkShreddedType(shreddedType);
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value")).addField(shreddedType)).named(name);
    }

    private static GroupType element(org.apache.parquet.schema.Type shreddedType) {
        return TestVariantReaders.field("element", shreddedType);
    }

    private static GroupType list(GroupType elementType) {
        return (GroupType)Types.optionalList().element((org.apache.parquet.schema.Type)elementType).named("typed_value");
    }

    private static void checkListType(GroupType listType) {
        Preconditions.checkArgument((listType.getFieldCount() == 1 && ((org.apache.parquet.schema.Type)listType.getFields().get(0)).isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid list type: does not contain single repeated field: %s", (Object)listType);
        GroupType repeated = ((org.apache.parquet.schema.Type)listType.getFields().get(0)).asGroupType();
        Preconditions.checkArgument((repeated.getFieldCount() == 1 && ((org.apache.parquet.schema.Type)repeated.getFields().get(0)).isRepetition(Type.Repetition.REQUIRED) ? 1 : 0) != 0, (String)"Invalid list type: does not contain single required subfield: %s", (Object)listType);
    }

    private static org.apache.avro.Schema avroSchema(GroupType schema) {
        if (schema instanceof MessageType) {
            return new AvroSchemaConverter(CONF).convert((MessageType)schema);
        }
        MessageType wrapped = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)schema)).named("table");
        org.apache.avro.Schema avro = ((Schema.Field)new AvroSchemaConverter(CONF).convert(wrapped).getFields().get(0)).schema();
        switch (avro.getType()) {
            case RECORD: {
                return avro;
            }
            case UNION: {
                return (org.apache.avro.Schema)avro.getTypes().get(1);
            }
        }
        throw new IllegalArgumentException("Invalid converted type: " + String.valueOf(avro));
    }

    private static class TestWriterBuilder
    extends ParquetWriter.Builder<GenericRecord, TestWriterBuilder> {
        private MessageType parquetSchema = null;

        protected TestWriterBuilder(OutputFile outputFile) {
            super(ParquetIO.file((OutputFile)outputFile));
        }

        TestWriterBuilder withFileType(MessageType schema) {
            this.parquetSchema = schema;
            return this.self();
        }

        protected TestWriterBuilder self() {
            return this;
        }

        protected WriteSupport<GenericRecord> getWriteSupport(Configuration conf) {
            return new AvroWriteSupport(this.parquetSchema, TestVariantReaders.avroSchema((GroupType)this.parquetSchema), GenericData.get());
        }
    }
}

