/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.parquet.InternalWriter;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetVariantUtil;
import org.apache.iceberg.parquet.VariantShreddingFunction;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantTestUtil;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.FieldSource;

public class TestVariantMetrics {
    private static final VariantMetadata METADATA = VariantMetadata.from((ByteBuffer)VariantTestUtil.createMetadata(Set.of("a", "b", "c", "d", "e"), (boolean)true));
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"var", (Type)Types.VariantType.get())});
    private static final VariantMetadata EMPTY = Variants.emptyMetadata();
    private static final String ROOT_FIELD = "$";
    private static final VariantValue[] PRIMITIVES = new VariantValue[]{Variants.of((boolean)true), Variants.of((boolean)false), Variants.of((byte)34), Variants.of((byte)-34), Variants.of((short)1234), Variants.of((short)-1234), Variants.of((int)12345), Variants.of((int)-12345), Variants.of((long)9876543210L), Variants.of((long)-9876543210L), Variants.of((float)10.11f), Variants.of((float)-10.11f), Variants.of((double)14.3), Variants.of((double)-14.3), Variants.ofIsoDate((String)"2024-11-07"), Variants.ofIsoDate((String)"1957-11-07"), Variants.ofIsoTimestamptz((String)"2024-11-07T12:33:54.123456+00:00"), Variants.ofIsoTimestamptz((String)"1957-11-07T12:33:54.123456+00:00"), Variants.ofIsoTimestampntz((String)"2024-11-07T12:33:54.123456"), Variants.ofIsoTimestampntz((String)"1957-11-07T12:33:54.123456"), Variants.of((BigDecimal)new BigDecimal("123456.789")), Variants.of((BigDecimal)new BigDecimal("-123456.789")), Variants.of((BigDecimal)new BigDecimal("123456789.987654321")), Variants.of((BigDecimal)new BigDecimal("-123456789.987654321")), Variants.of((BigDecimal)new BigDecimal("9876543210.123456789")), Variants.of((BigDecimal)new BigDecimal("-9876543210.123456789")), Variants.of((ByteBuffer)ByteBuffer.wrap(new byte[]{10, 11, 12, 13})), Variants.of((String)"iceberg"), Variants.ofIsoTime((String)"12:33:54.123456"), Variants.ofIsoTimestamptzNanos((String)"2024-11-07T12:33:54.123456789+00:00"), Variants.ofIsoTimestamptzNanos((String)"1957-11-07T12:33:54.123456789+00:00"), Variants.ofIsoTimestampntzNanos((String)"2024-11-07T12:33:54.123456789"), Variants.ofIsoTimestampntzNanos((String)"1957-11-07T12:33:54.123456789"), Variants.ofUUID((String)"f24f9b64-81fa-49d1-b74e-8c09a6e31c56")};

    @ParameterizedTest
    @FieldSource(value={"PRIMITIVES"})
    public void testShreddedPrimitiveTypes(VariantValue value) throws IOException {
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)value), Variant.of((VariantMetadata)EMPTY, (VariantValue)value), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.ofNull()), null);
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 3L, 2, 3L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 1L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)0L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(2))).extracting(bytes -> {
            VariantObject bounds = Variant.from((ByteBuffer)bytes).value().asObject();
            return bounds.get(ROOT_FIELD);
        }).isEqualTo((Object)value);
        Assertions.assertThat((Map)metrics.upperBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)2L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(2))).extracting(bytes -> {
            VariantObject bounds = Variant.from((ByteBuffer)bytes).value().asObject();
            return bounds.get(ROOT_FIELD);
        }).isEqualTo((Object)value);
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get(), 2, Types.VariantType.get()));
    }

    @ParameterizedTest
    @FieldSource(value={"PRIMITIVES"})
    public void testShreddedPrimitiveRange(VariantValue value) throws IOException {
        VariantValue largerValue = TestVariantMetrics.increment(value);
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)value), Variant.of((VariantMetadata)EMPTY, (VariantValue)largerValue), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.ofNull()), null, Variant.of((VariantMetadata)EMPTY, (VariantValue)value));
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 4L, 2, 4L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 1L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)0L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(2))).extracting(bytes -> {
            VariantObject bounds = Variant.from((ByteBuffer)bytes).value().asObject();
            return bounds.get(ROOT_FIELD);
        }).isEqualTo((Object)value);
        Assertions.assertThat((Map)metrics.upperBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)3L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(2))).extracting(bytes -> {
            VariantObject bounds = Variant.from((ByteBuffer)bytes).value().asObject();
            return bounds.get(ROOT_FIELD);
        }).isEqualTo((Object)largerValue);
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get(), 2, Types.VariantType.get()));
    }

    @ParameterizedTest
    @FieldSource(value={"PRIMITIVES"})
    public void testShreddedPrimitiveTypeMismatch(VariantValue value) throws IOException {
        VariantPrimitive otherValue = value.type() == PhysicalType.STRING ? Variants.of((int)34) : Variants.of((String)"iceberg");
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)value), Variant.of((VariantMetadata)EMPTY, (VariantValue)value), Variant.of((VariantMetadata)EMPTY, (VariantValue)otherValue));
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 2L, 2, 2L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 0L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)0L)));
        Assertions.assertThat((Map)metrics.upperBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)1L)));
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get()));
    }

    @Test
    public void testVariantFloatNaN() throws IOException {
        VariantPrimitive floatValue = Variants.of((float)1.0f);
        Metrics metrics = this.writeParquet((arg_0, arg_1) -> TestVariantMetrics.lambda$testVariantFloatNaN$11((VariantValue)floatValue, arg_0, arg_1), Variant.of((VariantMetadata)EMPTY, (VariantValue)floatValue), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.of((float)Float.NaN)));
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 2L, 2, 2L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 0L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)0L)));
        Assertions.assertThat((Map)metrics.upperBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)1L)));
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get()));
    }

    @Test
    public void testVariantDoubleNaN() throws IOException {
        VariantPrimitive doubleValue = Variants.of((double)1.0);
        Metrics metrics = this.writeParquet((arg_0, arg_1) -> TestVariantMetrics.lambda$testVariantDoubleNaN$12((VariantValue)doubleValue, arg_0, arg_1), Variant.of((VariantMetadata)EMPTY, (VariantValue)doubleValue), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.of((double)Double.NaN)));
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 2L, 2, 2L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 0L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)0L)));
        Assertions.assertThat((Map)metrics.upperBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)1L)));
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get()));
    }

    @Test
    public void testAllNull() throws IOException {
        ShreddedObject object = Variants.object((VariantMetadata)METADATA);
        object.put("a", (VariantValue)Variants.ofIsoDate((String)"2025-03-17"));
        object.put("b", (VariantValue)Variants.of((int)34));
        object.put("c", (VariantValue)Variants.of((String)"iceberg"));
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)object), null, null);
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 2L, 2, 2L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 2L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)0L)));
        Assertions.assertThat((Map)metrics.upperBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)1L)));
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get()));
    }

    @Test
    public void testUnshredded() throws IOException {
        ShreddedObject object = Variants.object((VariantMetadata)METADATA);
        object.put("a", (VariantValue)Variants.ofIsoDate((String)"2025-03-17"));
        object.put("b", (VariantValue)Variants.of((int)34));
        object.put("c", (VariantValue)Variants.of((String)"iceberg"));
        Metrics metrics = this.writeParquet((id, name) -> null, Variant.of((VariantMetadata)METADATA, (VariantValue)object), null);
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 2L, 2, 2L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 1L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        Assertions.assertThat((Map)metrics.lowerBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)0L)));
        Assertions.assertThat((Map)metrics.upperBounds()).isEqualTo(Map.of(1, Conversions.toByteBuffer((Type.TypeID)Type.TypeID.LONG, (Object)1L)));
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get()));
    }

    @Test
    public void testShreddedObject() throws IOException {
        VariantPrimitive date = Variants.ofIsoDate((String)"2025-03-17");
        VariantPrimitive num = Variants.of((int)34);
        VariantPrimitive str = Variants.of((String)"iceberg");
        VariantPrimitive dec = Variants.of((BigDecimal)new BigDecimal("123456.789"));
        ShreddedObject inner = Variants.object((VariantMetadata)METADATA);
        inner.put("e", (VariantValue)dec);
        ShreddedObject object = Variants.object((VariantMetadata)METADATA);
        object.put("a", (VariantValue)date);
        object.put("b", (VariantValue)num);
        object.put("c", (VariantValue)str);
        object.put("d", (VariantValue)inner);
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)object), Variant.of((VariantMetadata)EMPTY, (VariantValue)num), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.object((VariantMetadata)EMPTY)), Variant.of((VariantMetadata)METADATA, (VariantValue)object), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.ofNull()), null);
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 5L, 2, 5L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 1L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        VariantMetadata boundMetadata = Variants.metadata((String[])new String[]{"$['a']", "$['b']", "$['c']", "$['d']['e']"});
        ShreddedObject expectedBounds = Variants.object((VariantMetadata)boundMetadata);
        expectedBounds.put("$['a']", (VariantValue)date);
        expectedBounds.put("$['b']", (VariantValue)num);
        expectedBounds.put("$['c']", (VariantValue)str);
        expectedBounds.put("$['d']['e']", (VariantValue)dec);
        Assertions.assertThat((Map)metrics.lowerBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)0L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(2))).extracting(bytes -> Variant.from((ByteBuffer)bytes).value()).isEqualTo((Object)expectedBounds);
        Assertions.assertThat((Map)metrics.upperBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)4L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(2))).extracting(bytes -> Variant.from((ByteBuffer)bytes).value()).isEqualTo((Object)expectedBounds);
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get(), 2, Types.VariantType.get()));
    }

    @Test
    public void testPartiallyShreddedObject() throws IOException {
        VariantPrimitive date = Variants.ofIsoDate((String)"2025-03-17");
        VariantPrimitive num = Variants.of((int)34);
        VariantPrimitive str = Variants.of((String)"iceberg");
        VariantPrimitive dec = Variants.of((BigDecimal)new BigDecimal("123456.789"));
        ShreddedObject inner = Variants.object((VariantMetadata)METADATA);
        inner.put("e", (VariantValue)dec);
        ShreddedObject object = Variants.object((VariantMetadata)METADATA);
        object.put("a", (VariantValue)date);
        object.put("b", (VariantValue)num);
        object.put("c", (VariantValue)str);
        object.put("d", (VariantValue)inner);
        ShreddedObject example = Variants.object((VariantMetadata)METADATA);
        example.put("a", (VariantValue)date);
        example.put("b", (VariantValue)num);
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)example), Variant.of((VariantMetadata)EMPTY, (VariantValue)num), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.object((VariantMetadata)EMPTY)), Variant.of((VariantMetadata)METADATA, (VariantValue)object), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.ofNull()), null);
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 5L, 2, 5L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 1L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        VariantMetadata boundMetadata = Variants.metadata((String[])new String[]{"$['a']", "$['b']"});
        ShreddedObject expectedBounds = Variants.object((VariantMetadata)boundMetadata);
        expectedBounds.put("$['a']", (VariantValue)date);
        expectedBounds.put("$['b']", (VariantValue)num);
        Assertions.assertThat((Map)metrics.lowerBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)0L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(2))).extracting(bytes -> Variant.from((ByteBuffer)bytes).value()).isEqualTo((Object)expectedBounds);
        Assertions.assertThat((Map)metrics.upperBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)4L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(2))).extracting(bytes -> Variant.from((ByteBuffer)bytes).value()).isEqualTo((Object)expectedBounds);
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get(), 2, Types.VariantType.get()));
    }

    @Test
    public void testShreddedObjectFieldTypeMismatch() throws IOException {
        VariantPrimitive date = Variants.ofIsoDate((String)"2025-03-17");
        VariantPrimitive num = Variants.of((int)34);
        VariantPrimitive str = Variants.of((String)"iceberg");
        VariantPrimitive dec = Variants.of((BigDecimal)new BigDecimal("123456.789"));
        ShreddedObject inner = Variants.object((VariantMetadata)METADATA);
        inner.put("e", (VariantValue)dec);
        ShreddedObject object = Variants.object((VariantMetadata)METADATA);
        object.put("a", (VariantValue)date);
        object.put("b", (VariantValue)num);
        object.put("c", (VariantValue)str);
        object.put("d", (VariantValue)inner);
        ShreddedObject mismatched = Variants.object((VariantMetadata)METADATA);
        mismatched.put("a", (VariantValue)Variants.ofNull());
        mismatched.put("b", (VariantValue)Variants.of((byte)-1));
        mismatched.put("c", (VariantValue)num);
        Metrics metrics = this.writeParquet((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)object), Variant.of((VariantMetadata)EMPTY, (VariantValue)num), Variant.of((VariantMetadata)EMPTY, (VariantValue)mismatched), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.object((VariantMetadata)EMPTY)), Variant.of((VariantMetadata)METADATA, (VariantValue)object), Variant.of((VariantMetadata)EMPTY, (VariantValue)Variants.ofNull()), null);
        Assertions.assertThat((Map)metrics.valueCounts()).isEqualTo(Map.of(1, 6L, 2, 6L));
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEqualTo(Map.of(1, 0L, 2, 1L));
        Assertions.assertThat((Map)metrics.nanValueCounts()).isEqualTo(Map.of());
        VariantMetadata boundMetadata = Variants.metadata((String[])new String[]{"$['a']", "$['d']['e']"});
        ShreddedObject expectedBounds = Variants.object((VariantMetadata)boundMetadata);
        expectedBounds.put("$['a']", (VariantValue)date);
        expectedBounds.put("$['d']['e']", (VariantValue)dec);
        Assertions.assertThat((Map)metrics.lowerBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)0L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.lowerBounds().get(2))).extracting(bytes -> Variant.from((ByteBuffer)bytes).value()).isEqualTo((Object)expectedBounds);
        Assertions.assertThat((Map)metrics.upperBounds()).hasSize(2);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(1))).extracting(bytes -> Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)bytes)).isEqualTo((Object)5L);
        Assertions.assertThat((Comparable)((ByteBuffer)metrics.upperBounds().get(2))).extracting(bytes -> Variant.from((ByteBuffer)bytes).value()).isEqualTo((Object)expectedBounds);
        Assertions.assertThat((Object)metrics).extracting("originalTypes").isEqualTo(Map.of(1, Types.LongType.get(), 2, Types.VariantType.get()));
    }

    private Metrics writeParquet(VariantShreddingFunction shredding, Variant ... variants) throws IOException {
        FileAppender writer;
        InMemoryOutputFile out = new InMemoryOutputFile();
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        try (FileAppender fileAppender = writer = Parquet.write((OutputFile)out).schema(SCHEMA).variantShreddingFunc(shredding).createWriterFunc(fileSchema -> InternalWriter.create((Types.StructType)SCHEMA.asStruct(), (MessageType)fileSchema)).build();){
            for (int id = 0; id < variants.length; ++id) {
                record.setField("id", (Object)id);
                record.setField("var", (Object)variants[id]);
                writer.add((Object)record);
            }
        }
        return writer.metrics();
    }

    private static VariantValue increment(VariantValue value) {
        VariantPrimitive primitive = value.asPrimitive();
        switch (value.type()) {
            case BOOLEAN_TRUE: 
            case BOOLEAN_FALSE: {
                return Variants.of((boolean)true);
            }
            case INT8: {
                return Variants.of((PhysicalType)value.type(), (Object)((byte)((Byte)primitive.get() + 1)));
            }
            case INT16: {
                return Variants.of((PhysicalType)value.type(), (Object)((short)((Short)primitive.get() + 1)));
            }
            case INT32: 
            case DATE: {
                return Variants.of((PhysicalType)value.type(), (Object)((Integer)primitive.get() + 1));
            }
            case INT64: 
            case TIMESTAMPTZ: 
            case TIMESTAMPNTZ: 
            case TIME: 
            case TIMESTAMPTZ_NANOS: 
            case TIMESTAMPNTZ_NANOS: {
                return Variants.of((PhysicalType)value.type(), (Object)((Long)primitive.get() + 1L));
            }
            case FLOAT: {
                return Variants.of((PhysicalType)value.type(), (Object)Float.valueOf(((Float)primitive.get()).floatValue() + 1.0f));
            }
            case DOUBLE: {
                return Variants.of((PhysicalType)value.type(), (Object)((Double)primitive.get() + 1.0));
            }
            case DECIMAL4: 
            case DECIMAL8: 
            case DECIMAL16: {
                return Variants.of((PhysicalType)value.type(), (Object)((BigDecimal)primitive.get()).add(BigDecimal.ONE));
            }
            case BINARY: {
                return Variants.of((PhysicalType)value.type(), (Object)BinaryUtil.truncateBinaryMax((ByteBuffer)((ByteBuffer)primitive.get()), (int)2));
            }
            case STRING: {
                return Variants.of((PhysicalType)value.type(), (Object)UnicodeUtil.truncateStringMax((String)((String)primitive.get()), (int)5));
            }
            case UUID: {
                UUID uuid = (UUID)primitive.get();
                return Variants.of((PhysicalType)value.type(), (Object)new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits() + 1L));
            }
        }
        throw new UnsupportedOperationException("Cannot increment value: " + String.valueOf(value));
    }

    private static /* synthetic */ org.apache.parquet.schema.Type lambda$testVariantDoubleNaN$12(VariantValue doubleValue, Integer id, String name) {
        return ParquetVariantUtil.toParquetSchema((VariantValue)doubleValue);
    }

    private static /* synthetic */ org.apache.parquet.schema.Type lambda$testVariantFloatNaN$11(VariantValue floatValue, Integer id, String name) {
        return ParquetVariantUtil.toParquetSchema((VariantValue)floatValue);
    }
}

