/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestPruneColumns {
    @Test
    public void testMapKeyValueName() {
        MessageType fileSchema = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(2)).named("key"))).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(4)).named("x"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(5)).named("y"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(6)).named("z"))).id(3)).named("value"))).named("custom_key_value_name"))).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).id(1)).named("m"))).named("table");
        Schema projection = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"m", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.DoubleType.get())})))});
        MessageType expected = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(2)).named("key"))).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(4)).named("x"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(5)).named("y"))).id(3)).named("value"))).named("custom_key_value_name"))).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).id(1)).named("m"))).named("table");
        MessageType actual = ParquetSchemaUtil.pruneColumns((MessageType)fileSchema, (Schema)projection);
        ((ObjectAssert)Assertions.assertThat((Object)actual).as("Pruned schema should not rename repeated struct", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testListElementName() {
        MessageType fileSchema = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(4)).named("x"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(5)).named("y"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(6)).named("z"))).id(3)).named("custom_element_name"))).named("custom_repeated_name"))).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).id(1)).named("m"))).named("table");
        Schema projection = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"m", (Type)Types.ListType.ofOptional((int)3, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.DoubleType.get())})))});
        MessageType expected = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(4)).named("x"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(5)).named("y"))).id(3)).named("custom_element_name"))).named("custom_repeated_name"))).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).id(1)).named("m"))).named("table");
        MessageType actual = ParquetSchemaUtil.pruneColumns((MessageType)fileSchema, (Schema)projection);
        ((ObjectAssert)Assertions.assertThat((Object)actual).as("Pruned schema should not rename repeated struct", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testStructElementName() {
        MessageType fileSchema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(1)).named("id"))).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(3)).named("x"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(4)).named("y"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(5)).named("z"))).id(2)).named("struct_name_1"))).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(7)).named("x"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(8)).named("y"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(9)).named("z"))).id(6)).named("struct_name_2"))).named("table");
        Schema projection = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"struct_name_1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"y", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"z", (Type)Types.DoubleType.get())})), Types.NestedField.optional((int)6, (String)"struct_name_2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))});
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(4)).named("y"))).addField((org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(5)).named("z"))).id(2)).named("struct_name_1"))).addField((org.apache.parquet.schema.Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).id(6)).named("struct_name_2"))).named("table");
        MessageType actual = ParquetSchemaUtil.pruneColumns((MessageType)fileSchema, (Schema)projection);
        ((ObjectAssert)Assertions.assertThat((Object)actual).as("Pruned schema should be matched", new Object[0])).isEqualTo((Object)expected);
    }
}

