/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.Schema;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.RemoveIds;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestParquetSchemaUtil {
    private static final Types.StructType SUPPORTED_PRIMITIVES = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)112, (String)"fixed", (Type)Types.FixedType.ofLength((int)7)), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10))});

    @Test
    public void testAssignIdsByNameMapping() {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"list_of_maps", (Type)Types.ListType.ofOptional((int)2, (Type)Types.MapType.ofOptional((int)3, (int)4, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.optional((int)5, (String)"map_of_lists", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.ListType.ofOptional((int)8, (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)9, (String)"list_of_lists", (Type)Types.ListType.ofOptional((int)10, (Type)Types.ListType.ofOptional((int)11, (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)12, (String)"map_of_maps", (Type)Types.MapType.ofOptional((int)13, (int)14, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)15, (int)16, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)17, (String)"list_of_struct_of_nested_types", (Type)Types.ListType.ofOptional((int)19, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"m1", (Type)Types.MapType.ofOptional((int)21, (int)22, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.optional((int)23, (String)"l1", (Type)Types.ListType.ofRequired((int)24, (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.required((int)25, (String)"l2", (Type)Types.ListType.ofRequired((int)26, (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.optional((int)27, (String)"m2", (Type)Types.MapType.ofOptional((int)28, (int)29, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))})))});
        Schema schema = new Schema(TypeUtil.assignFreshIds((Type)structType, new AtomicInteger(0)::incrementAndGet).asStructType().fields());
        NameMapping nameMapping = MappingUtil.create((Schema)schema);
        MessageType messageTypeWithIds = ParquetSchemaUtil.convert((Schema)schema, (String)"parquet_type");
        MessageType messageTypeWithIdsFromNameMapping = ParquetSchemaUtil.applyNameMapping((MessageType)RemoveIds.removeIds((MessageType)messageTypeWithIds), (NameMapping)nameMapping);
        Assertions.assertThat((Object)messageTypeWithIdsFromNameMapping).isEqualTo((Object)messageTypeWithIds);
    }

    @Test
    public void testSchemaConversionWithoutAssigningIds() {
        MessageType messageType = new MessageType("test", new org.apache.parquet.schema.Type[]{this.primitive(1, "int_col", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(2, "double_col", PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.OPTIONAL), this.primitive(null, "long_col", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL), this.struct(3, "struct_col_1", Type.Repetition.REQUIRED, this.primitive(4, "n1", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(null, "n2", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL), this.primitive(5, "n3", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL)), this.struct(6, "struct_col_2", Type.Repetition.OPTIONAL, this.primitive(null, "n1", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(null, "n2", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL), this.primitive(null, "n3", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL)), this.list(null, "list_col_1", Type.Repetition.REQUIRED, this.primitive(7, "i", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.OPTIONAL)), this.list(8, "list_col_2", Type.Repetition.REQUIRED, this.primitive(null, "i", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.OPTIONAL)), this.list(9, "list_col_3", Type.Repetition.OPTIONAL, this.struct(null, "s", Type.Repetition.REQUIRED, this.primitive(10, "n1", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(11, "n2", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL))), this.list(12, "list_col_4", Type.Repetition.REQUIRED, this.struct(13, "s", Type.Repetition.REQUIRED, this.primitive(null, "n1", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(null, "n2", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL))), this.list(14, "list_col_5", Type.Repetition.OPTIONAL, this.struct(15, "s", Type.Repetition.REQUIRED, this.primitive(16, "n1", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(17, "n2", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL))), this.map(null, "map_col_1", Type.Repetition.REQUIRED, this.primitive(18, "k", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(19, "v", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED)), this.map(20, "map_col_2", Type.Repetition.OPTIONAL, this.primitive(null, "k", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(21, "v", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED)), this.map(22, "map_col_3", Type.Repetition.REQUIRED, this.primitive(null, "k", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(null, "v", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED)), this.map(23, "map_col_4", Type.Repetition.OPTIONAL, this.primitive(24, "k", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.struct(25, "s", Type.Repetition.REQUIRED, this.primitive(null, "n1", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(26, "n2", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL), this.primitive(null, "n3", PrimitiveType.PrimitiveTypeName.INT64, Type.Repetition.OPTIONAL))), this.map(27, "map_col_5", Type.Repetition.REQUIRED, this.primitive(28, "k", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED), this.primitive(29, "v", PrimitiveType.PrimitiveTypeName.INT32, Type.Repetition.REQUIRED))});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"int_col", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"double_col", (Type)Types.DoubleType.get()), Types.NestedField.required((int)3, (String)"struct_col_1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"n1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"n3", (Type)Types.LongType.get())})), Types.NestedField.optional((int)14, (String)"list_col_5", (Type)Types.ListType.ofRequired((int)15, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"n1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)17, (String)"n2", (Type)Types.LongType.get())}))), Types.NestedField.optional((int)23, (String)"map_col_4", (Type)Types.MapType.ofRequired((int)24, (int)25, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)26, (String)"n2", (Type)Types.LongType.get())}))), Types.NestedField.required((int)27, (String)"map_col_5", (Type)Types.MapType.ofRequired((int)28, (int)29, (Type)Types.IntegerType.get(), (Type)Types.IntegerType.get()))});
        Schema actualSchema = ParquetSchemaUtil.convertAndPrune((MessageType)messageType);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testSchemaConversionForHiveStyleLists() {
        String parquetSchemaString = "message spark_schema {\n  optional group col1 (LIST) {\n    repeated group bag {\n      optional group array {\n        required int32 col2;\n      }\n    }\n  }\n}\n";
        MessageType messageType = MessageTypeParser.parseMessageType((String)parquetSchemaString);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.ListType.ofOptional((int)2, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"col2", (Type)Types.IntegerType.get())})))});
        NameMapping nameMapping = MappingUtil.create((Schema)expectedSchema);
        MessageType messageTypeWithIds = ParquetSchemaUtil.applyNameMapping((MessageType)messageType, (NameMapping)nameMapping);
        Schema actualSchema = ParquetSchemaUtil.convertAndPrune((MessageType)messageTypeWithIds);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testLegacyTwoLevelListTypeWithPrimitiveElement() {
        String parquetSchemaString = "message spark_schema {\n  optional group arraybytes (LIST) {\n    repeated binary array;\n  }\n}\n";
        MessageType messageType = MessageTypeParser.parseMessageType((String)parquetSchemaString);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"arraybytes", (Type)Types.ListType.ofRequired((int)1000, (Type)Types.BinaryType.get()))});
        Schema actualSchema = ParquetSchemaUtil.convert((MessageType)messageType);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testLegacyTwoLevelListTypeWithGroupTypeElementWithTwoFields() {
        String messageType = "message root {  required group f0 {    required group f00 (LIST) {      repeated group element {        required int32 f000;        optional int64 f001;      }    }  }}";
        MessageType parquetScehma = MessageTypeParser.parseMessageType((String)messageType);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"f0", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1003, (String)"f00", (Type)Types.ListType.ofRequired((int)1002, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1000, (String)"f000", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1001, (String)"f001", (Type)Types.LongType.get())})))}))});
        Schema actualSchema = ParquetSchemaUtil.convert((MessageType)parquetScehma);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testLegacyTwoLevelListGenByParquetAvro() {
        String messageType = "message root {  optional group my_list (LIST) {    repeated group array {      required binary str (UTF8);    }  }}";
        MessageType parquetScehma = MessageTypeParser.parseMessageType((String)messageType);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"my_list", (Type)Types.ListType.ofRequired((int)1001, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1000, (String)"str", (Type)Types.StringType.get())})))});
        Schema actualSchema = ParquetSchemaUtil.convert((MessageType)parquetScehma);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testLegacyTwoLevelListGenByParquetThrift() {
        String messageType = "message root {  optional group my_list (LIST) {    repeated group my_list_tuple {      required binary str (UTF8);    }  }}";
        MessageType parquetScehma = MessageTypeParser.parseMessageType((String)messageType);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"my_list", (Type)Types.ListType.ofRequired((int)1001, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1000, (String)"str", (Type)Types.StringType.get())})))});
        Schema actualSchema = ParquetSchemaUtil.convert((MessageType)parquetScehma);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testLegacyTwoLevelListGenByParquetThrift1() {
        String messageType = "message root {  optional group my_list (LIST) {    repeated group my_list_tuple (LIST) {      repeated int32 my_list_tuple_tuple;    }  }}";
        MessageType parquetScehma = MessageTypeParser.parseMessageType((String)messageType);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"my_list", (Type)Types.ListType.ofRequired((int)1001, (Type)Types.ListType.ofRequired((int)1000, (Type)Types.IntegerType.get())))});
        Schema actualSchema = ParquetSchemaUtil.convert((MessageType)parquetScehma);
        ((ObjectAssert)Assertions.assertThat((Object)actualSchema.asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    private org.apache.parquet.schema.Type primitive(Integer id, String name, PrimitiveType.PrimitiveTypeName typeName, Type.Repetition repetition) {
        Types.PrimitiveBuilder builder = Types.primitive((PrimitiveType.PrimitiveTypeName)typeName, (Type.Repetition)repetition);
        if (id != null) {
            builder.id(id.intValue());
        }
        return (org.apache.parquet.schema.Type)builder.named(name);
    }

    private org.apache.parquet.schema.Type struct(Integer id, String name, Type.Repetition repetition, org.apache.parquet.schema.Type ... types) {
        Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)repetition);
        builder.addFields(types);
        if (id != null) {
            builder.id(id.intValue());
        }
        return (org.apache.parquet.schema.Type)builder.named(name);
    }

    private org.apache.parquet.schema.Type list(Integer id, String name, Type.Repetition repetition, org.apache.parquet.schema.Type elementType) {
        Types.ListBuilder builder = Types.list((Type.Repetition)repetition);
        builder.element(elementType);
        if (id != null) {
            builder.id(id.intValue());
        }
        return (org.apache.parquet.schema.Type)builder.named(name);
    }

    private org.apache.parquet.schema.Type map(Integer id, String name, Type.Repetition repetition, org.apache.parquet.schema.Type keyType, org.apache.parquet.schema.Type valueType) {
        Types.MapBuilder builder = Types.map((Type.Repetition)repetition);
        builder.key(keyType);
        builder.value(valueType);
        if (id != null) {
            builder.id(id.intValue());
        }
        return (org.apache.parquet.schema.Type)builder.named(name);
    }
}

