/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetWritingTestUtils;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestParquetEncryption {
    private static final String COLUMN_NAME = "intCol";
    private static final int RECORD_COUNT = 100;
    private static final ByteBuffer FILE_DEK = ByteBuffer.allocate(16);
    private static final ByteBuffer AAD_PREFIX = ByteBuffer.allocate(16);
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"intCol", (Type)Types.IntegerType.get())});
    private static File file;
    @TempDir
    private Path temp;

    @BeforeEach
    public void writeEncryptedFile() throws IOException {
        FileAppender writer;
        ArrayList records = Lists.newArrayListWithCapacity((int)100);
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)SCHEMA.asStruct());
        for (int i = 1; i <= 100; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put(COLUMN_NAME, (Object)i);
            records.add(record);
        }
        SecureRandom rand = new SecureRandom();
        rand.nextBytes(FILE_DEK.array());
        rand.nextBytes(AAD_PREFIX.array());
        file = ParquetWritingTestUtils.createTempFile(this.temp);
        try (FileAppender toClose = writer = Parquet.write((OutputFile)Files.localOutput((File)file)).schema(SCHEMA).withFileEncryptionKey(FILE_DEK).withAADPrefix(AAD_PREFIX).build();){
            writer.addAll((Iterable)Lists.newArrayList((Object[])records.toArray(new GenericData.Record[0])));
        }
    }

    @Test
    public void testReadEncryptedFileWithoutKeys() throws IOException {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Parquet.read((InputFile)Files.localInput((File)file)).project(SCHEMA).callInit().build().iterator()).as("Decrypted without keys", new Object[0])).isInstanceOf(ParquetCryptoRuntimeException.class)).hasMessage("Trying to read file with encrypted footer. No keys available");
    }

    @Test
    public void testReadEncryptedFileWithoutAADPrefix() throws IOException {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Parquet.read((InputFile)Files.localInput((File)file)).project(SCHEMA).withFileEncryptionKey(FILE_DEK).callInit().build().iterator()).as("Decrypted without AAD prefix", new Object[0])).isInstanceOf(ParquetCryptoRuntimeException.class)).hasMessage("AAD prefix used for file encryption, but not stored in file and not supplied in decryption properties");
    }

    @Test
    public void testReadEncryptedFile() throws IOException {
        try (CloseableIterator readRecords = Parquet.read((InputFile)Files.localInput((File)file)).withFileEncryptionKey(FILE_DEK).withAADPrefix(AAD_PREFIX).project(SCHEMA).callInit().build().iterator();){
            for (int i = 1; i <= 100; ++i) {
                GenericData.Record readRecord = (GenericData.Record)readRecords.next();
                Assertions.assertThat((Object)readRecord.get(COLUMN_NAME)).isEqualTo((Object)i);
            }
        }
    }
}

