/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestParquetDeleteWriters {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private List<Record> records;
    @TempDir
    private File temp;

    @BeforeEach
    public void createDeleteRecords() {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)"a")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"b")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)3L, (Object)"data", (Object)"c")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)4L, (Object)"data", (Object)"d")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)5L, (Object)"data", (Object)"e")));
        this.records = builder.build();
    }

    @Test
    public void testEqualityDeleteWriter() throws IOException {
        ArrayList deletedRecords;
        EqualityDeleteWriter deleteWriter;
        OutputFile out = Files.localOutput((File)this.temp);
        try (EqualityDeleteWriter writer = deleteWriter = Parquet.writeDeletes((OutputFile)out).createWriterFunc(GenericParquetWriter::create).overwrite().rowSchema(SCHEMA).withSpec(PartitionSpec.unpartitioned()).equalityFieldIds(new int[]{1}).buildEqualityWriter();){
            writer.write(this.records);
        }
        DeleteFile metadata = deleteWriter.toDeleteFile();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.format()).as("Format should be Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.content()).as("Should be equality deletes", new Object[0])).isEqualTo((Object)FileContent.EQUALITY_DELETES);
        ((AbstractLongAssert)Assertions.assertThat((long)metadata.recordCount()).as("Record count should be correct", new Object[0])).isEqualTo((long)this.records.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)metadata.partition().size()).as("Partition should be empty", new Object[0])).isEqualTo(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.keyMetadata()).as("Key metadata should be null", new Object[0])).isNull();
        try (CloseableIterable reader = Parquet.read((InputFile)out.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)SCHEMA, (MessageType)fileSchema)).build();){
            deletedRecords = Lists.newArrayList((Iterable)reader);
        }
        ((ListAssert)Assertions.assertThat((List)deletedRecords).as("Deleted records should match expected", new Object[0])).isEqualTo(this.records);
    }

    @Test
    public void testPositionDeleteWriter() throws IOException {
        ArrayList deletedRecords;
        Schema deleteSchema = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS, Types.NestedField.optional((int)2147483544, (String)"row", (Type)SCHEMA.asStruct())});
        String deletePath = "s3://bucket/path/file.parquet";
        GenericRecord posDelete = GenericRecord.create((Schema)deleteSchema);
        ArrayList expectedDeleteRecords = Lists.newArrayList();
        OutputFile out = Files.localOutput((File)this.temp);
        PositionDeleteWriter deleteWriter = Parquet.writeDeletes((OutputFile)out).createWriterFunc(GenericParquetWriter::create).overwrite().rowSchema(SCHEMA).withSpec(PartitionSpec.unpartitioned()).buildPositionWriter();
        PositionDelete positionDelete = PositionDelete.create();
        try (PositionDeleteWriter writer = deleteWriter;){
            for (int i = 0; i < this.records.size(); ++i) {
                int pos = i * 3 + 2;
                writer.write(positionDelete.set((CharSequence)deletePath, (long)pos, (Object)this.records.get(i)));
                expectedDeleteRecords.add(posDelete.copy((Map)ImmutableMap.of((Object)"file_path", (Object)deletePath, (Object)"pos", (Object)pos, (Object)"row", (Object)this.records.get(i))));
            }
        }
        DeleteFile metadata = deleteWriter.toDeleteFile();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.format()).as("Format should be Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.content()).as("Should be position deletes", new Object[0])).isEqualTo((Object)FileContent.POSITION_DELETES);
        ((AbstractLongAssert)Assertions.assertThat((long)metadata.recordCount()).as("Record count should be correct", new Object[0])).isEqualTo((long)this.records.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)metadata.partition().size()).as("Partition should be empty", new Object[0])).isEqualTo(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.keyMetadata()).as("Key metadata should be null", new Object[0])).isNull();
        try (CloseableIterable reader = Parquet.read((InputFile)out.toInputFile()).project(deleteSchema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)deleteSchema, (MessageType)fileSchema)).build();){
            deletedRecords = Lists.newArrayList((Iterable)reader);
        }
        ((ListAssert)Assertions.assertThat((List)deletedRecords).as("Deleted records should match expected", new Object[0])).isEqualTo((Object)expectedDeleteRecords);
    }

    @Test
    public void testPositionDeleteWriterWithEmptyRow() throws IOException {
        ArrayList deletedRecords;
        Schema deleteSchema = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
        String deletePath = "s3://bucket/path/file.parquet";
        GenericRecord posDelete = GenericRecord.create((Schema)deleteSchema);
        ArrayList expectedDeleteRecords = Lists.newArrayList();
        OutputFile out = Files.localOutput((File)this.temp);
        PositionDeleteWriter deleteWriter = Parquet.writeDeletes((OutputFile)out).createWriterFunc(GenericParquetWriter::create).overwrite().withSpec(PartitionSpec.unpartitioned()).transformPaths(path -> {
            throw new RuntimeException("Should not be called for performance reasons");
        }).buildPositionWriter();
        PositionDelete positionDelete = PositionDelete.create();
        try (PositionDeleteWriter writer = deleteWriter;){
            for (int i = 0; i < this.records.size(); ++i) {
                int pos = i * 3 + 2;
                writer.write(positionDelete.set((CharSequence)deletePath, (long)pos, null));
                expectedDeleteRecords.add(posDelete.copy((Map)ImmutableMap.of((Object)"file_path", (Object)deletePath, (Object)"pos", (Object)pos)));
            }
        }
        DeleteFile metadata = deleteWriter.toDeleteFile();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.format()).as("Format should be Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.content()).as("Should be position deletes", new Object[0])).isEqualTo((Object)FileContent.POSITION_DELETES);
        ((AbstractLongAssert)Assertions.assertThat((long)metadata.recordCount()).as("Record count should be correct", new Object[0])).isEqualTo((long)this.records.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)metadata.partition().size()).as("Partition should be empty", new Object[0])).isEqualTo(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.keyMetadata()).as("Key metadata should be null", new Object[0])).isNull();
        try (CloseableIterable reader = Parquet.read((InputFile)out.toInputFile()).project(deleteSchema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)deleteSchema, (MessageType)fileSchema)).build();){
            deletedRecords = Lists.newArrayList((Iterable)reader);
        }
        ((ListAssert)Assertions.assertThat((List)deletedRecords).as("Deleted records should match expected", new Object[0])).isEqualTo((Object)expectedDeleteRecords);
    }
}

