/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetWritingTestUtils;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestParquetDataWriter {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"binary", (Type)Types.BinaryType.get())});
    private List<Record> records;
    @TempDir
    private Path temp;

    @BeforeEach
    public void createRecords() {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)"a")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"b")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)3L, (Object)"data", (Object)"c")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)4L, (Object)"data", (Object)"d")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)5L, (Object)"data", (Object)"e")));
        this.records = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataWriter() throws IOException {
        ArrayList writtenRecords;
        OutputFile file = Files.localOutput((File)ParquetWritingTestUtils.createTempFile(this.temp));
        SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("id")).build();
        try (DataWriter dataWriter = Parquet.writeData((OutputFile)file).schema(SCHEMA).createWriterFunc(GenericParquetWriter::create).overwrite().withSpec(PartitionSpec.unpartitioned()).withSortOrder(sortOrder).build();){
            for (Record record : this.records) {
                dataWriter.write((Object)record);
            }
        }
        DataFile dataFile = dataWriter.toDataFile();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.format()).as("Format should be Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.content()).as("Should be data file", new Object[0])).isEqualTo((Object)FileContent.DATA);
        ((AbstractLongAssert)Assertions.assertThat((long)dataFile.recordCount()).as("Record count should match", new Object[0])).isEqualTo((long)this.records.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)dataFile.partition().size()).as("Partition should be empty", new Object[0])).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)dataFile.sortOrderId()).as("Sort order should match", new Object[0])).isEqualTo(sortOrder.orderId());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.keyMetadata()).as("Key metadata should be null", new Object[0])).isNull();
        try (CloseableIterable reader = Parquet.read((InputFile)file.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)SCHEMA, (MessageType)fileSchema)).build();){
            writtenRecords = Lists.newArrayList((Iterable)reader);
        }
        ((ListAssert)Assertions.assertThat((List)writtenRecords).as("Written records should match", new Object[0])).isEqualTo(this.records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidUpperBoundString() throws Exception {
        ArrayList writtenRecords;
        OutputFile file = Files.localOutput((File)ParquetWritingTestUtils.createTempFile(this.temp));
        TestTables.TestTable testTable = TestTables.create((File)ParquetWritingTestUtils.createTempFile(this.temp), (String)"test_invalid_string_bound", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SortOrder.unsorted(), (int)2);
        testTable.updateProperties().set("write.metadata.metrics.default", "truncate(16)").commit();
        DataWriter dataWriter = Parquet.writeData((OutputFile)file).metricsConfig(MetricsConfig.forTable((Table)testTable)).schema(SCHEMA).createWriterFunc(GenericParquetWriter::create).overwrite().withSpec(PartitionSpec.unpartitioned()).build();
        GenericRecord genericRecord = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        char[] charArray = new char[61];
        for (int i = 0; i < 60; i += 2) {
            charArray[i] = 56319;
            charArray[i + 1] = 57343;
        }
        builder.add((Object)genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)String.valueOf(charArray))));
        ImmutableList overflowRecords = builder.build();
        try {
            for (Record record : overflowRecords) {
                dataWriter.write((Object)record);
            }
        }
        finally {
            dataWriter.close();
        }
        DataFile dataFile = dataWriter.toDataFile();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.format()).as("Format should be Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.content()).as("Should be data file", new Object[0])).isEqualTo((Object)FileContent.DATA);
        ((AbstractLongAssert)Assertions.assertThat((long)dataFile.recordCount()).as("Record count should match", new Object[0])).isEqualTo((long)overflowRecords.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)dataFile.partition().size()).as("Partition should be empty", new Object[0])).isEqualTo(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.keyMetadata()).as("Key metadata should be null", new Object[0])).isNull();
        try (CloseableIterable reader = Parquet.read((InputFile)file.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)SCHEMA, (MessageType)fileSchema)).build();){
            writtenRecords = Lists.newArrayList((Iterable)reader);
        }
        ((ListAssert)Assertions.assertThat((List)writtenRecords).as("Written records should match", new Object[0])).isEqualTo((Object)overflowRecords);
        ((MapAssert)Assertions.assertThat((Map)dataFile.lowerBounds()).as("Should have a valid lower bound", new Object[0])).containsKey((Object)1);
        ((MapAssert)Assertions.assertThat((Map)dataFile.upperBounds()).as("Should have a valid upper bound", new Object[0])).containsKey((Object)1);
        ((MapAssert)Assertions.assertThat((Map)dataFile.lowerBounds()).as("Should have a valid lower bound", new Object[0])).containsKey((Object)2);
        ((MapAssert)Assertions.assertThat((Map)dataFile.upperBounds()).as("Should have a null upper bound", new Object[0])).doesNotContainKey((Object)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidUpperBoundBinary() throws Exception {
        ArrayList writtenRecords;
        OutputFile file = Files.localOutput((File)ParquetWritingTestUtils.createTempFile(this.temp));
        TestTables.TestTable testTable = TestTables.create((File)ParquetWritingTestUtils.createTempFile(this.temp), (String)"test_invalid_binary_bound", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SortOrder.unsorted(), (int)2);
        testTable.updateProperties().set("write.metadata.metrics.default", "truncate(16)").commit();
        DataWriter dataWriter = Parquet.writeData((OutputFile)file).metricsConfig(MetricsConfig.forTable((Table)testTable)).schema(SCHEMA).createWriterFunc(GenericParquetWriter::create).overwrite().withSpec(PartitionSpec.unpartitioned()).build();
        GenericRecord genericRecord = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        ByteBuffer bytes = ByteBuffer.allocate(17);
        for (int i = 0; i < 17; ++i) {
            bytes.put(i, (byte)-1);
        }
        builder.add((Object)genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"binary", (Object)bytes)));
        ImmutableList overflowRecords = builder.build();
        try {
            for (Record record : overflowRecords) {
                dataWriter.write((Object)record);
            }
        }
        finally {
            dataWriter.close();
        }
        DataFile dataFile = dataWriter.toDataFile();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.format()).as("Format should be Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.content()).as("Should be data file", new Object[0])).isEqualTo((Object)FileContent.DATA);
        ((AbstractLongAssert)Assertions.assertThat((long)dataFile.recordCount()).as("Record count should match", new Object[0])).isEqualTo((long)overflowRecords.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)dataFile.partition().size()).as("Partition should be empty", new Object[0])).isEqualTo(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataFile.keyMetadata()).as("Key metadata should be null", new Object[0])).isNull();
        try (CloseableIterable reader = Parquet.read((InputFile)file.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)SCHEMA, (MessageType)fileSchema)).build();){
            writtenRecords = Lists.newArrayList((Iterable)reader);
        }
        ((ListAssert)Assertions.assertThat((List)writtenRecords).as("Written records should match", new Object[0])).isEqualTo((Object)overflowRecords);
        ((MapAssert)Assertions.assertThat((Map)dataFile.lowerBounds()).as("Should have a valid lower bound", new Object[0])).containsKey((Object)1);
        ((MapAssert)Assertions.assertThat((Map)dataFile.upperBounds()).as("Should have a valid upper bound", new Object[0])).containsKey((Object)1);
        ((MapAssert)Assertions.assertThat((Map)dataFile.lowerBounds()).as("Should have a valid lower bound", new Object[0])).containsKey((Object)3);
        ((MapAssert)Assertions.assertThat((Map)dataFile.upperBounds()).as("Should have a null upper bound", new Object[0])).doesNotContainKey((Object)3);
    }
}

