/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetAvroWriter;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetWritingTestUtils;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestParquet {
    @TempDir
    private java.nio.file.Path temp;

    @Test
    public void testRowGroupSizeConfigurable() throws IOException {
        File parquetFile = (File)this.generateFile(null, 101, 16, null, null).first();
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)Files.localInput((File)parquetFile)));){
            Assertions.assertThat((List)reader.getRowGroups()).hasSize(2);
        }
    }

    @Test
    public void testRowGroupSizeConfigurableWithWriter() throws IOException {
        File parquetFile = (File)this.generateFile(ParquetAvroWriter::buildWriter, 5, 16, 1, 2).first();
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)Files.localInput((File)parquetFile)));){
            Assertions.assertThat((List)reader.getRowGroups()).hasSize(2);
        }
    }

    @Test
    public void testMetricsMissingColumnStatisticsInRowGroups() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"stringCol", (Type)Types.StringType.get())});
        File file = ParquetWritingTestUtils.createTempFile(this.temp);
        ArrayList records = Lists.newArrayListWithCapacity((int)1);
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        GenericData.Record smallRecord = new GenericData.Record(avroSchema);
        smallRecord.put("stringCol", (Object)"test");
        records.add(smallRecord);
        GenericData.Record largeRecord = new GenericData.Record(avroSchema);
        largeRecord.put("stringCol", (Object)Strings.repeat((String)"a", (int)2048));
        records.add(largeRecord);
        ParquetWritingTestUtils.write(file, schema, (Map<String, String>)ImmutableMap.builder().put((Object)"write.parquet.row-group-size-bytes", (Object)"1").put((Object)"write.parquet.row-group-check-min-record-count", (Object)"1").put((Object)"write.parquet.row-group-check-max-record-count", (Object)"1").buildOrThrow(), ParquetAvroWriter::buildWriter, records.toArray(new GenericData.Record[0]));
        InputFile inputFile = Files.localInput((File)file);
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)inputFile));){
            Assertions.assertThat((List)reader.getRowGroups()).hasSize(2);
            List blocks = reader.getFooter().getBlocks();
            Assertions.assertThat((List)blocks).hasSize(2);
            Statistics smallStatistics = ((ColumnChunkMetaData)Iterables.getOnlyElement((Iterable)((BlockMetaData)blocks.get(0)).getColumns())).getStatistics();
            Assertions.assertThat((boolean)smallStatistics.hasNonNullValue()).isTrue();
            Assertions.assertThat((byte[])smallStatistics.getMinBytes()).isEqualTo((Object)"test".getBytes(StandardCharsets.UTF_8));
            Assertions.assertThat((byte[])smallStatistics.getMaxBytes()).isEqualTo((Object)"test".getBytes(StandardCharsets.UTF_8));
            Statistics largeStatistics = ((ColumnChunkMetaData)Iterables.getOnlyElement((Iterable)((BlockMetaData)blocks.get(1)).getColumns())).getStatistics();
            Assertions.assertThat((boolean)largeStatistics.hasNonNullValue()).isFalse();
            Assertions.assertThat((byte[])largeStatistics.getMinBytes()).isNull();
            Assertions.assertThat((byte[])largeStatistics.getMaxBytes()).isNull();
        }
        Metrics metrics = ParquetUtil.fileMetrics((InputFile)inputFile, (MetricsConfig)MetricsConfig.getDefault());
        Assertions.assertThat((Map)metrics.nullValueCounts()).isEmpty();
        Assertions.assertThat((Map)metrics.lowerBounds()).isEmpty();
        Assertions.assertThat((Map)metrics.upperBounds()).isEmpty();
    }

    @Test
    public void testNumberOfBytesWritten() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"intCol", (Type)Types.IntegerType.get())});
        int recordCount = 100099;
        File file = ParquetWritingTestUtils.createTempFile(this.temp);
        ArrayList records = Lists.newArrayListWithCapacity((int)recordCount);
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        for (int i = 1; i <= recordCount; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("intCol", (Object)i);
            records.add(record);
        }
        long actualSize = ParquetWritingTestUtils.write(file, schema, Collections.emptyMap(), ParquetAvroWriter::buildWriter, records.toArray(new GenericData.Record[0]));
        long expectedSize = ParquetIO.file((InputFile)Files.localInput((File)file)).getLength();
        Assertions.assertThat((long)actualSize).isEqualTo(expectedSize);
    }

    @Test
    public void testTwoLevelList() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"arraybytes", (Type)Types.ListType.ofRequired((int)3, (Type)Types.BinaryType.get())), Types.NestedField.optional((int)2, (String)"topbytes", (Type)Types.BinaryType.get())});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        File testFile = new File(this.temp.toFile(), "test" + System.nanoTime() + ".parquet");
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)new Path(testFile.toURI())).withDataModel(GenericData.get()).withSchema(avroSchema).config("parquet.avro.add-list-element-records", "true")).config("parquet.avro.write-old-list-structure", "true")).build();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(avroSchema);
        ArrayList expectedByteList = Lists.newArrayList();
        byte[] expectedByte = new byte[]{0, 1};
        ByteBuffer expectedBinary = ByteBuffer.wrap(expectedByte);
        expectedByteList.add(expectedBinary);
        recordBuilder.set("arraybytes", (Object)expectedByteList);
        recordBuilder.set("topbytes", (Object)expectedBinary);
        GenericData.Record expectedRecord = recordBuilder.build();
        writer.write((Object)expectedRecord);
        writer.close();
        GenericData.Record recordRead = (GenericData.Record)Iterables.getOnlyElement((Iterable)Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).callInit().build());
        Assertions.assertThat((Object)recordRead.get("arraybytes")).isEqualTo((Object)expectedByteList);
        Assertions.assertThat((Object)recordRead.get("topbytes")).isEqualTo((Object)expectedBinary);
    }

    @Test
    public void testColumnStatisticsEnabled() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"int_field", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"string_field", (Type)Types.StringType.get())});
        File file = ParquetWritingTestUtils.createTempFile(this.temp);
        ArrayList records = Lists.newArrayListWithCapacity((int)5);
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        for (int i = 1; i <= 5; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("int_field", (Object)i);
            record.put("string_field", (Object)"test");
            records.add(record);
        }
        ParquetWritingTestUtils.write(file, schema, (Map<String, String>)ImmutableMap.builder().put((Object)"write.parquet.stats-enabled.column.int_field", (Object)"true").put((Object)"write.parquet.stats-enabled.column.string_field", (Object)"false").buildOrThrow(), ParquetAvroWriter::buildWriter, records.toArray(new GenericData.Record[0]));
        InputFile inputFile = Files.localInput((File)file);
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)inputFile));){
            for (BlockMetaData block : reader.getFooter().getBlocks()) {
                for (ColumnChunkMetaData column : block.getColumns()) {
                    boolean emptyStats = column.getStatistics().isEmpty();
                    if (column.getPath().toDotString().equals("int_field")) {
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)emptyStats).as("int_field has statistics", new Object[0])).isEqualTo(false);
                        continue;
                    }
                    if (!column.getPath().toDotString().equals("string_field")) continue;
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)emptyStats).as("string_field has statistics", new Object[0])).isEqualTo(true);
                }
            }
        }
    }

    private Pair<File, Long> generateFile(Function<MessageType, ParquetValueWriter<?>> createWriterFunc, int desiredRecordCount, Integer rowGroupSizeBytes, Integer minCheckRecordCount, Integer maxCheckRecordCount) throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"intCol", (Type)Types.IntegerType.get())});
        ImmutableMap.Builder propsBuilder = ImmutableMap.builder();
        if (rowGroupSizeBytes != null) {
            propsBuilder.put((Object)"write.parquet.row-group-size-bytes", (Object)Integer.toString(rowGroupSizeBytes));
        }
        if (minCheckRecordCount != null) {
            propsBuilder.put((Object)"write.parquet.row-group-check-min-record-count", (Object)Integer.toString(minCheckRecordCount));
        }
        if (maxCheckRecordCount != null) {
            propsBuilder.put((Object)"write.parquet.row-group-check-max-record-count", (Object)Integer.toString(maxCheckRecordCount));
        }
        ArrayList records = Lists.newArrayListWithCapacity((int)desiredRecordCount);
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        for (int i = 1; i <= desiredRecordCount; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            record.put("intCol", (Object)i);
            records.add(record);
        }
        File file = ParquetWritingTestUtils.createTempFile(this.temp);
        long size = ParquetWritingTestUtils.write(file, schema, (Map<String, String>)propsBuilder.build(), createWriterFunc, records.toArray(new GenericData.Record[0]));
        return Pair.of((Object)file, (Object)size);
    }
}

