/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.InternalTestHelpers;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RandomInternalData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.DataTestBase;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.InternalReader;
import org.apache.iceberg.data.parquet.InternalWriter;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;

public class TestInternalParquet
extends DataTestBase {
    protected boolean supportsDefaultValues() {
        return true;
    }

    protected boolean supportsUnknown() {
        return true;
    }

    protected boolean supportsTimestampNanos() {
        return true;
    }

    protected boolean supportsVariant() {
        return true;
    }

    protected void writeAndValidate(Schema schema) throws IOException {
        List expected = RandomInternalData.generate((Schema)schema, (int)100, (long)1376L);
        this.writeAndValidate(schema, expected);
    }

    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema) throws IOException {
        List expected = RandomInternalData.generate((Schema)writeSchema, (int)100, (long)1376L);
        this.writeAndValidate(writeSchema, expectedSchema, expected);
    }

    protected void writeAndValidate(Schema schema, List<Record> expected) throws IOException {
        this.writeAndValidate(schema, schema, expected);
    }

    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema, List<Record> expected) throws IOException {
        ArrayList rows;
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        try (DataWriter dataWriter = Parquet.writeData((OutputFile)outputFile).schema(writeSchema).createWriterFunc(InternalWriter::createWriter).overwrite().withSpec(PartitionSpec.unpartitioned()).build();){
            for (Record record : expected) {
                dataWriter.write((Object)record);
            }
        }
        try (CloseableIterable reader = Parquet.read((InputFile)outputFile.toInputFile()).project(expectedSchema).createReaderFunc(fileSchema -> InternalReader.create((Schema)expectedSchema, (MessageType)fileSchema)).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            InternalTestHelpers.assertEquals((Types.StructType)expectedSchema.asStruct(), (Record)expected.get(i), (Record)((Record)rows.get(i)));
        }
        reader = Parquet.read((InputFile)outputFile.toInputFile()).project(expectedSchema).reuseContainers().createReaderFunc(fileSchema -> InternalReader.create((Schema)expectedSchema, (MessageType)fileSchema)).build();
        try {
            int index = 0;
            for (Record actualRecord : reader) {
                InternalTestHelpers.assertEquals((Types.StructType)expectedSchema.asStruct(), (Record)expected.get(index), (Record)actualRecord);
                ++index;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

