/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetDictionaryRowGroupFilter;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestDictionaryRowGroupFilter {
    private static final Types.StructType STRUCT_FIELD_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"int_field", (Type)Types.IntegerType.get())});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"no_stats", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"required", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"all_nulls", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"non_dict", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"struct_not_null", (Type)STRUCT_FIELD_TYPE), Types.NestedField.optional((int)10, (String)"not_in_file", (Type)Types.FloatType.get()), Types.NestedField.optional((int)11, (String)"all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)12, (String)"some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)13, (String)"no_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)14, (String)"decimal_fixed", (Type)Types.DecimalType.of((int)20, (int)10)), Types.NestedField.optional((int)15, (String)"_nans_and_nulls", (Type)Types.DoubleType.get())});
    private static final Types.StructType UNDERSCORE_STRUCT_FIELD_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"_int_field", (Type)Types.IntegerType.get())});
    private static final Schema FILE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"_no_stats", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"_required", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"_all_nulls", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"_some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"_no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"_non_dict", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"_struct_not_null", (Type)UNDERSCORE_STRUCT_FIELD_TYPE), Types.NestedField.optional((int)11, (String)"_all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)12, (String)"_some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)13, (String)"_no_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)14, (String)"_decimal_fixed", (Type)Types.DecimalType.of((int)20, (int)10)), Types.NestedField.optional((int)15, (String)"_nans_and_nulls", (Type)Types.DoubleType.get())});
    private static final String TOO_LONG_FOR_STATS;
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 79;
    private static final BigDecimal DECIMAL_MIN_VALUE;
    private static final BigDecimal DECIMAL_STEP;
    private MessageType parquetSchema = null;
    private BlockMetaData rowGroupMetadata = null;
    private DictionaryPageReadStore dictionaryStore = null;
    @Parameter
    private ParquetProperties.WriterVersion writerVersion;
    @TempDir
    private Path temp;

    @Parameters(name="writerVersion={0}")
    public static Collection<ParquetProperties.WriterVersion> parameters() {
        return Arrays.asList(ParquetProperties.WriterVersion.PARQUET_1_0, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @BeforeEach
    public void createInputFile() throws IOException {
        File parquetFile = new File(this.temp.toFile(), "test" + System.nanoTime() + ".parquet");
        org.apache.avro.Schema structSchema = AvroSchemaUtil.convert((Type)UNDERSCORE_STRUCT_FIELD_TYPE);
        OutputFile outFile = Files.localOutput((File)parquetFile);
        try (FileAppender appender = Parquet.write((OutputFile)outFile).schema(FILE_SCHEMA).withWriterVersion(this.writerVersion).build();){
            GenericRecordBuilder builder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)FILE_SCHEMA, (String)"table"));
            for (int copy = 0; copy < 20; ++copy) {
                for (int i = 0; i < 50; ++i) {
                    builder.set("_id", (Object)(30 + i));
                    builder.set("_no_stats", (Object)TOO_LONG_FOR_STATS);
                    builder.set("_required", (Object)"req");
                    builder.set("_all_nulls", null);
                    builder.set("_some_nulls", (Object)(i % 10 == 0 ? null : "some"));
                    builder.set("_no_nulls", (Object)"");
                    builder.set("_non_dict", (Object)UUID.randomUUID().toString());
                    builder.set("_all_nans", (Object)Double.NaN);
                    builder.set("_some_nans", (Object)Float.valueOf(i % 10 == 0 ? Float.NaN : 2.0f));
                    builder.set("_no_nans", (Object)3.0);
                    builder.set("_decimal_fixed", (Object)DECIMAL_MIN_VALUE.add(DECIMAL_STEP.multiply(new BigDecimal(i))));
                    builder.set("_nans_and_nulls", (Object)(i % 10 == 0 ? null : Double.valueOf(Double.NaN)));
                    GenericData.Record structNotNull = new GenericData.Record(structSchema);
                    structNotNull.put("_int_field", (Object)(30 + i));
                    builder.set("_struct_not_null", (Object)structNotNull);
                    appender.add((Object)builder.build());
                }
            }
        }
        InputFile inFile = Files.localInput((File)parquetFile);
        ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)inFile));
        ((ListAssert)Assertions.assertThat((List)reader.getRowGroups()).as("Should create only one row group", new Object[0])).hasSize(1);
        this.rowGroupMetadata = (BlockMetaData)reader.getRowGroups().get(0);
        this.parquetSchema = reader.getFileMetaData().getSchema();
        this.dictionaryStore = reader.getNextDictionaryReader();
    }

    @TestTemplate
    public void testAssumptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.equal((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notEqual((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.lessThan((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.lessThanOrEqual((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.greaterThan((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.startsWith((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notStartsWith((String)"col", null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Cannot create expression literal from null");
    }

    @TestTemplate
    public void testAllNulls() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"all_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"some_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"no_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"struct_not_null")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testNoNulls() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"all_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"some_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"no_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"struct_not_null")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary filter doesn't help", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testRequiredColumn() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"required")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: required columns are always non-null", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"required")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: required columns are always non-null", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testIsNaNs() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"all_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: all_nans column will contain NaN", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"some_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: some_nans column will contain NaN", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"no_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no_nans column will not contain NaN", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testNotNaNs() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"all_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: all_nans column will not contain non-NaN", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"some_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: some_nans column will contain non-NaN", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"no_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no_nans column will contain non-NaN", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testNotNaNOnNaNsAndNulls() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"_nans_and_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: _nans_and_nulls column will contain null values", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"_nans_and_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: _nans_and_nulls column will contain NaN values which are not null", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"_nans_and_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: _nans_and_nulls column will contain NaN values", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"_nans_and_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: _nans_and_nulls column will contain null values which are not NaN", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStartsWith() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"non_dict", (String)"re")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no dictionary", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"re")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"req")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"some_nulls", (String)"so")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"no_stats", (String)UUID.randomUUID().toString())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no stats but dictionary is present", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"reqs")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no match in dictionary", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"some_nulls", (String)"somex")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no match in dictionary", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"no_nulls", (String)"xxx")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no match in dictionary", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testNotStartsWith() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"non_dict", (String)"re")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no dictionary", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"re")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no match in dictionary", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"req")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no match in dictionary", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"some_nulls", (String)"s!")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"no_stats", (String)UUID.randomUUID().toString())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no stats but dictionary is present", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"required", (String)"reqs")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"some_nulls", (String)"somex")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"some_nulls", (String)"some")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no match in dictionary", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notStartsWith((String)"no_nulls", (String)"xxx")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary contains a matching entry", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testMissingColumn() {
        Assertions.assertThatThrownBy(() -> new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"missing", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore)).hasMessageContaining("Cannot find field 'missing'").isInstanceOf(ValidationException.class);
    }

    @TestTemplate
    public void testColumnNotInFile() {
        Expression[] exprs;
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.lessThanOrEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.equal((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.greaterThan((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.greaterThanOrEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.notNull((String)"not_in_file"), Expressions.isNull((String)"not_in_file"), Expressions.notEqual((String)"not_in_file", (Object)Float.valueOf(1.0f))}) {
            boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, expr).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary cannot be found: " + String.valueOf(expr), new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testColumnFallbackOrNotDictionaryEncoded() {
        Expression[] exprs;
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"non_dict", (Object)"a"), Expressions.lessThanOrEqual((String)"non_dict", (Object)"a"), Expressions.equal((String)"non_dict", (Object)"a"), Expressions.greaterThan((String)"non_dict", (Object)"a"), Expressions.greaterThanOrEqual((String)"non_dict", (Object)"a"), Expressions.notNull((String)"non_dict"), Expressions.isNull((String)"non_dict"), Expressions.notEqual((String)"non_dict", (Object)"a")}) {
            boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, expr).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: dictionary cannot be found: " + String.valueOf(expr), new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testMissingStats() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"no_stats", (Object)"a")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: stats are missing but dictionary is present", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testNot() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.lessThan((String)"id", (Object)5))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: not(false)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.greaterThan((String)"id", (Object)5))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: not(true)", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testAnd() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)0))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, false)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.greaterThan((String)"id", (Object)5), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true)", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testOr() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: or(false, false)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)60))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: or(false, true)", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerLt() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (30 is not < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)31)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerLtEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)29)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (29 < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: many possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerGt() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (79 is not > 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)78)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerGtEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (80 > 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)29)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)80)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testIntegerNotEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)29)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)80)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerNotEqRewritten() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)5))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)29))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)30))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)75))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)79))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)80))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)85))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStringNotEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"some_nulls", (Object)"some")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: contains null != 'some'", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"no_nulls", (Object)"")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: contains only ''", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testStructFieldLt() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (30 is not < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)31)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldLtEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)29)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (29 < 30)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: many possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldGt() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (79 is not > 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)78)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldGtEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)80)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (80 > 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)29)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)80)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testStructFieldNotEq() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)29)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)30)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)75)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)79)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)80)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)85)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testCaseInsensitive() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"no_Nulls", (Object)""), false).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: contains only ''", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testMissingDictionaryPageForColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"some_nulls", (Object)"some")).shouldRead(this.parquetSchema, this.rowGroupMetadata, descriptor -> null)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Failed to read required dictionary page for id: 5");
    }

    @TestTemplate
    public void testIntegerIn() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{5, 6})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound (5 < 30, 6 < 30). The two sets are disjoint.", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{28, 29})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound (28 < 30, 29 < 30). The two sets are disjoint.", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{29, 30})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound (30 == 30)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{75, 76})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in set is a subset of the dictionary", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{79, 80})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound (79 == 79)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{80, 81})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound (80 > 79, 81 > 79)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{85, 86})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound (85 > 79, 86 > 79). The two sets are disjoint.", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Iterable)IntStream.range(20, 89).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: the dictionary is a subset of the in set", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Iterable)IntStream.range(30, 80).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: the dictionary is equal to the in set", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"all_nulls", (Object[])new Integer[]{1, 2})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on all nulls column (isFallback to be true) ", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"aaa", "some"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on some nulls column", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: some_nulls values are not within the set", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: in on no nulls column (empty string is not within the set)", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"aaa", ""})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on no nulls column (empty string is within the set)", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerNotIn() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{5, 6})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound (5 < 30, 6 < 30). The two sets are disjoint.", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{28, 29})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound (28 < 30, 29 < 30). The two sets are disjoint.", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{29, 30})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound (30 == 30)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{75, 76})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: the notIn set is a subset of the dictionary", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{79, 80})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound (79 == 79)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{80, 81})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound (80 > 79, 81 > 79). The two sets are disjoint.", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{85, 86})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound (85 > 79, 86 > 79). The two sets are disjoint.", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Iterable)IntStream.range(20, 89).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: the dictionary is a subset of the notIn set", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Iterable)IntStream.range(30, 80).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: the dictionary is equal to the notIn set", new Object[0])).isFalse();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"all_nulls", (Object[])new Integer[]{1, 2})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on all nulls column", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"some_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on some nulls column (any null matches the notIn)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on no nulls column (empty string is not within the set)", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"aaa", ""})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: notIn on no nulls column (empty string is within the set)", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testTypePromotion() {
        Schema promotedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(promotedSchema, (Expression)Expressions.equal((String)"id", (Object)31), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should succeed with promoted schema", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testFixedLenByteArray() {
        Assumptions.assumeThat((Collection)this.getColumnForName(this.rowGroupMetadata, "_decimal_fixed").getEncodings()).contains((Object[])new Encoding[]{Encoding.RLE_DICTIONARY});
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"decimal_fixed", (Object)BigDecimal.ZERO)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: Half of the decimal_fixed values are greater than 0", new Object[0])).isTrue();
        shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"decimal_fixed", (Object)DECIMAL_MIN_VALUE)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: No decimal_fixed values less than -1234567890.0987654321", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testTransformFilter() {
        boolean shouldRead = new ParquetDictionaryRowGroupFilter(SCHEMA, (Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"required", (int)2), (Object)"some_value")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.dictionaryStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: filter contains non-reference evaluate as True", new Object[0])).isTrue();
    }

    private ColumnChunkMetaData getColumnForName(BlockMetaData rowGroup, String columnName) {
        ColumnPath columnPath = ColumnPath.fromDotString((String)columnName);
        for (ColumnChunkMetaData column : rowGroup.getColumns()) {
            if (!columnPath.equals((Object)column.getPath())) continue;
            return column;
        }
        throw new NoSuchElementException("No column in rowGroup for the name " + columnName);
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            sb.append(UUID.randomUUID());
        }
        TOO_LONG_FOR_STATS = sb.toString();
        DECIMAL_MIN_VALUE = new BigDecimal("-1234567890.0987654321");
        DECIMAL_STEP = new BigDecimal("1234567890.0987654321").subtract(DECIMAL_MIN_VALUE).divide(new BigDecimal(49), RoundingMode.HALF_UP);
    }
}

