/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetBloomRowGroupFilter;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.hadoop.BloomFilterReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestBloomRowGroupFilter {
    private static final Types.StructType STRUCT_FIELD_TYPE;
    private static final Schema SCHEMA;
    private static final Types.StructType UNDERSCORE_STRUCT_FIELD_TYPE;
    private static final Schema FILE_SCHEMA;
    private static final String TOO_LONG_FOR_STATS;
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 79;
    private static final int INT_VALUE_COUNT = 50;
    private static final long LONG_BASE = 100L;
    private static final double DOUBLE_BASE = 1000.0;
    private static final float FLOAT_BASE = 10000.0f;
    private static final String BINARY_PREFIX = "BINARY\u6d4b\u8bd5_";
    private static final Instant INSTANT;
    private static final List<UUID> RANDOM_UUIDS;
    private static final List<byte[]> RANDOM_BYTES;
    private MessageType parquetSchema = null;
    private BlockMetaData rowGroupMetadata = null;
    private BloomFilterReader bloomStore = null;
    @TempDir
    private File temp;

    @BeforeEach
    public void createInputFile() throws IOException {
        org.apache.avro.Schema structSchema = AvroSchemaUtil.convert((Type)UNDERSCORE_STRUCT_FIELD_TYPE);
        String compatibleFieldName = "_incompatible_x2Dname";
        File file = new File(this.temp, "test" + System.nanoTime() + ".parquet");
        OutputFile outFile = Files.localOutput((File)file);
        try (FileAppender appender = Parquet.write((OutputFile)outFile).schema(FILE_SCHEMA).set("parquet.enable.dictionary", "false").set("write.parquet.bloom-filter-enabled.column._id", "true").set("write.parquet.bloom-filter-enabled.column._long", "true").set("write.parquet.bloom-filter-enabled.column._double", "true").set("write.parquet.bloom-filter-enabled.column._float", "true").set("write.parquet.bloom-filter-enabled.column._string", "true").set("write.parquet.bloom-filter-enabled.column._uuid", "true").set("write.parquet.bloom-filter-enabled.column._required", "true").set("write.parquet.bloom-filter-enabled.column._all_nulls", "true").set("write.parquet.bloom-filter-enabled.column._some_nulls", "true").set("write.parquet.bloom-filter-enabled.column._no_nulls", "true").set("write.parquet.bloom-filter-enabled.column._all_nans", "true").set("write.parquet.bloom-filter-enabled.column._some_nans", "true").set("write.parquet.bloom-filter-enabled.column._no_nans", "true").set("write.parquet.bloom-filter-enabled.column._struct_not_null._int_field", "true").set("write.parquet.bloom-filter-enabled.column._not_in_file", "true").set("write.parquet.bloom-filter-enabled.column._no_stats", "true").set("write.parquet.bloom-filter-enabled.column._boolean", "true").set("write.parquet.bloom-filter-enabled.column._time", "true").set("write.parquet.bloom-filter-enabled.column._date", "true").set("write.parquet.bloom-filter-enabled.column._timestamp", "true").set("write.parquet.bloom-filter-enabled.column._timestamptz", "true").set("write.parquet.bloom-filter-enabled.column._binary", "true").set("write.parquet.bloom-filter-enabled.column._int_decimal", "true").set("write.parquet.bloom-filter-enabled.column._long_decimal", "true").set("write.parquet.bloom-filter-enabled.column._fixed_decimal", "true").set("write.parquet.bloom-filter-enabled.column._incompatible-name", "true").build();){
            GenericRecordBuilder builder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)FILE_SCHEMA, (String)"table"));
            for (int i = 0; i < 50; ++i) {
                builder.set("_id", (Object)(30 + i));
                builder.set("_long", (Object)(130L + (long)i));
                builder.set("_double", (Object)(1030.0 + (double)i));
                builder.set("_float", (Object)Float.valueOf(10030.0f + (float)i));
                builder.set("_string", (Object)(BINARY_PREFIX + (30 + i)));
                builder.set("_uuid", (Object)RANDOM_UUIDS.get(i));
                builder.set("_required", (Object)"req");
                builder.set("_non_bloom", (Object)RANDOM_UUIDS.get(i));
                builder.set("_all_nulls", null);
                builder.set("_some_nulls", (Object)(i % 10 == 0 ? null : "some"));
                builder.set("_no_nulls", (Object)"");
                builder.set("_all_nans", (Object)Double.NaN);
                builder.set("_some_nans", (Object)Float.valueOf(i % 10 == 0 ? Float.NaN : 2.0f));
                builder.set("_no_nans", (Object)3.0);
                GenericData.Record structNotNull = new GenericData.Record(structSchema);
                structNotNull.put("_int_field", (Object)(30 + i));
                builder.set("_struct_not_null", (Object)structNotNull);
                builder.set("_no_stats", (Object)TOO_LONG_FOR_STATS);
                builder.set("_boolean", (Object)(i % 2 == 0 ? 1 : 0));
                builder.set("_time", (Object)INSTANT.plusSeconds(i * 86400).toEpochMilli());
                builder.set("_date", (Object)INSTANT.plusSeconds(i * 86400).getEpochSecond());
                builder.set("_timestamp", (Object)INSTANT.plusSeconds(i * 86400).toEpochMilli());
                builder.set("_timestamptz", (Object)INSTANT.plusSeconds(i * 86400).toEpochMilli());
                builder.set("_binary", (Object)RANDOM_BYTES.get(i));
                builder.set("_int_decimal", (Object)new BigDecimal(String.valueOf(77.77 + (double)i)));
                builder.set("_long_decimal", (Object)new BigDecimal(String.valueOf(88.88 + (double)i)));
                builder.set("_fixed_decimal", (Object)new BigDecimal(String.valueOf(99.99 + (double)i)));
                builder.set(compatibleFieldName, (Object)new BigDecimal(String.valueOf(77.77 + (double)i)));
                appender.add((Object)builder.build());
            }
        }
        InputFile inFile = Files.localInput((File)file);
        ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)inFile));
        ((ListAssert)Assertions.assertThat((List)reader.getRowGroups()).as("Should create only one row group", new Object[0])).hasSize(1);
        this.rowGroupMetadata = (BlockMetaData)reader.getRowGroups().get(0);
        this.parquetSchema = reader.getFileMetaData().getSchema();
        this.bloomStore = reader.getBloomFilterDataReader(this.rowGroupMetadata);
    }

    @Test
    public void testNotNull() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"all_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"some_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"no_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"struct_not_null.int_field")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: this field is required and are always not-null", new Object[0])).isTrue();
    }

    @Test
    public void testIsNull() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"all_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"some_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"no_nulls")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"struct_not_null.int_field")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: this field is required and are always not-null", new Object[0])).isFalse();
    }

    @Test
    public void testRequiredColumn() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNull((String)"required")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: required columns are always non-null", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNull((String)"required")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: required columns are always non-null", new Object[0])).isFalse();
    }

    @Test
    public void testIsNaNs() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"all_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"some_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.isNaN((String)"no_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
    }

    @Test
    public void testNotNaNs() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"all_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"some_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notNaN((String)"no_nans")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
    }

    @Test
    public void testStartsWith() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"non_bloom", (String)"re")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no bloom", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"re")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"req")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"some_nulls", (String)"so")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"required", (String)"reqs")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"some_nulls", (String)"somex")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.startsWith((String)"no_nulls", (String)"xxx")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
    }

    @Test
    public void testMissingColumn() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"missing", (Object)5)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore)).as("Should complain about missing column in expression", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing'");
    }

    @Test
    public void testColumnNotInFile() {
        Expression[] exprs;
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.lessThanOrEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.equal((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.greaterThan((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.greaterThanOrEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.notNull((String)"not_in_file"), Expressions.isNull((String)"not_in_file"), Expressions.notEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.in((String)"not_in_file", (Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)})}) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, expr).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter cannot be found: " + String.valueOf(expr), new Object[0])).isTrue();
        }
    }

    @Test
    public void testColumnNotBloomFilterEnabled() {
        Expression[] exprs;
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"non_bloom", (Object)"a"), Expressions.lessThanOrEqual((String)"non_bloom", (Object)"a"), Expressions.equal((String)"non_bloom", (Object)"a"), Expressions.greaterThan((String)"non_bloom", (Object)"a"), Expressions.greaterThanOrEqual((String)"non_bloom", (Object)"a"), Expressions.notNull((String)"non_bloom"), Expressions.isNull((String)"non_bloom"), Expressions.notEqual((String)"non_bloom", (Object)"a"), Expressions.in((String)"non_bloom", (Object[])new String[]{"a", "test1", "test2"})}) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, expr).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter cannot be found: " + String.valueOf(expr), new Object[0])).isTrue();
        }
    }

    @Test
    public void testMissingStats() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"no_stats", (Object)"a")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: stats are missing but bloom filter is present", new Object[0])).isFalse();
    }

    @Test
    public void testNot() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testAnd() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"id", (Object)60))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true)", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"id", (Object)80))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, false)", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)55), (Expression)Expressions.equal((String)"id", (Object)30))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true)", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)55), (Expression)Expressions.equal((String)"long", (Object)130L), (Expression[])new Expression[]{Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(30))})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true, true)", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"long", (Object)130L), (Expression[])new Expression[]{Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(30))})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true, true)", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)55), (Expression)Expressions.equal((String)"long", (Object)130L), (Expression[])new Expression[]{Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(30)), Expressions.equal((String)"non_bloom", (Object)"a")})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true, true, true)", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"long", (Object)130L), (Expression[])new Expression[]{Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(30)), Expressions.equal((String)"non_bloom", (Object)"a")})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true, true, true)", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)55), (Expression)Expressions.equal((String)"long", (Object)130L), (Expression[])new Expression[]{Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(30)), Expressions.equal((String)"not_in_file", (Object)Float.valueOf(1.0f))})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true, true, true)", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.and((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"long", (Object)130L), (Expression[])new Expression[]{Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(30)), Expressions.equal((String)"not_in_file", (Object)Float.valueOf(1.0f))})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true, true, true)", new Object[0])).isFalse();
    }

    @Test
    public void testOr() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.or((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"id", (Object)80))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: or(false, false)", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.or((Expression)Expressions.equal((String)"id", (Object)5), (Expression)Expressions.equal((String)"id", (Object)60))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: or(false, true)", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerLt() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testIntegerLtEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testIntegerGt() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testIntegerGtEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testIntegerEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 30 && i <= 79) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: integer within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: integer outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testLongEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"long", (Object)(100L + (long)i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 30 && i <= 79) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: long within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: long outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testBytesEq() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"binary", (Object)RANDOM_BYTES.get(i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: binary within range", new Object[0])).isTrue();
        }
        Random rd = new Random(54321L);
        for (int i = 1; i <= 10; ++i) {
            byte[] byteArray = new byte[i];
            rd.nextBytes(byteArray);
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"binary", (Object)byteArray)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: cannot match a new generated binary", new Object[0])).isFalse();
        }
    }

    @Test
    public void testIntDecimalEq() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"int_decimal", (Object)new BigDecimal(String.valueOf(77.77 + (double)i)))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: decimal within range", new Object[0])).isTrue();
        }
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"int_decimal", (Object)new BigDecimal("1234.56"))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: decimal outside range", new Object[0])).isFalse();
    }

    @Test
    public void testLongDecimalEq() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"long_decimal", (Object)new BigDecimal(String.valueOf(88.88 + (double)i)))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: decimal within range", new Object[0])).isTrue();
        }
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"long_decimal", (Object)new BigDecimal("1234.56"))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: decimal outside range", new Object[0])).isFalse();
    }

    @Test
    public void testFixedDecimalEq() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"fixed_decimal", (Object)new BigDecimal(String.valueOf(99.99 + (double)i)))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: decimal within range", new Object[0])).isTrue();
        }
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"fixed_decimal", (Object)new BigDecimal("1234.56"))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: decimal outside range", new Object[0])).isFalse();
    }

    @Test
    public void testDoubleEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"double", (Object)(1000.0 + (double)i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 30 && i <= 79) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: double within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: double outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testFloatEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"float", (Object)Float.valueOf(10000.0f + (float)i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 30 && i <= 79) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: float within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: float outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testStringEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"string", (Object)(BINARY_PREFIX + i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 30 && i <= 79) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: string within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: string outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testRandomBinaryEq() {
        boolean shouldRead;
        for (int i = 0; i < 50; ++i) {
            shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"uuid", (Object)RANDOM_UUIDS.get(i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: uuid within range", new Object[0])).isTrue();
        }
        Random rd = new Random(1357L);
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"uuid", (Object)new UUID(rd.nextLong(), rd.nextLong()).toString())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: cannot match a new generated random uuid", new Object[0])).isFalse();
    }

    @Test
    public void testBooleanEq() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"boolean", (Object)true)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter is not supported for Boolean", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"boolean", (Object)false)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter is not supported for Boolean", new Object[0])).isTrue();
    }

    @Test
    public void testTimeEq() {
        for (int i = -20; i < 70; ++i) {
            Instant ins = INSTANT.plusSeconds(i * 86400);
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"time", (Object)ins.toEpochMilli())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 0 && i < 50) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: time within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: time outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testDateEq() {
        for (int i = -20; i < 70; ++i) {
            Instant ins = INSTANT.plusSeconds(i * 86400);
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"date", (Object)ins.getEpochSecond())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 0 && i < 50) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: date within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: date outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testTimestampEq() {
        for (int i = -20; i < 70; ++i) {
            Instant ins = INSTANT.plusSeconds(i * 86400);
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"timestamp", (Object)ins.toEpochMilli())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 0 && i < 50) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: timestamp within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: timestamp outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testTimestamptzEq() {
        for (int i = -20; i < 70; ++i) {
            Instant ins = INSTANT.plusSeconds(i * 86400);
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"timestamptz", (Object)ins.toEpochMilli())).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 0 && i < 50) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: timestamptz within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: timestamptz outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testIntegerNotEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testIntegerNotEqRewritten() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)i))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testStringNotEq() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"some_nulls", (Object)"some")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"no_nulls", (Object)"")).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
    }

    @Test
    public void testStructFieldLt() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testStructFieldLtEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testStructFieldGt() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testStructFieldGtEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testStructFieldEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            if (i >= 30 && i <= 79) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: value within range", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: value outside range", new Object[0])).isFalse();
        }
    }

    @Test
    public void testStructFieldNotEq() {
        for (int i = 10; i < 99; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)i)).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCaseInsensitive() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"Required", (Object)"Req"), false).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: contains only 'req'", new Object[0])).isFalse();
    }

    @Test
    public void testMissingBloomFilterForColumn() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"some_nulls", (Object)"some")).shouldRead(this.parquetSchema, this.rowGroupMetadata, (BloomFilterReader)new DummyBloomFilterReader(null, this.rowGroupMetadata))).as("Should complain about missing bloom filter", new Object[0])).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Failed to read required bloom filter for id: 10");
    }

    @Test
    public void testIntegerIn() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{30 - 3 * i, 30 + i, 79 + 3 * i})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: integer within range", new Object[0])).isTrue();
        }
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Iterable)IntStream.range(20, 89).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: the bloom is a subset of the in set", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Iterable)IntStream.range(30, 79).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: the bloom is equal to the in set", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"id", (Iterable)IntStream.range(20, 29).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: value outside range", new Object[0])).isFalse();
    }

    @Test
    public void testOtherTypesIn() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"all_nulls", (Object[])new Integer[]{1, 2})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: in on all nulls column (bloom is empty) ", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"aaa", "some"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on some nulls column", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: some_nulls values are not within the set", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: in on no nulls column (empty string is not within the set)", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"aaa", ""})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on no nulls column (empty string is within the set)", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerNotIn() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{30 - 3 * i, 30 + i, 79 + 3 * i})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        }
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Iterable)IntStream.range(20, 89).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Iterable)IntStream.range(30, 79).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"id", (Iterable)IntStream.range(20, 29).boxed().collect(Collectors.toList()))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
    }

    @Test
    public void testOtherTypesNotIn() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"all_nulls", (Object[])new Integer[]{1, 2})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"some_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"aaa", "bbb"})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"aaa", ""})).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: bloom filter doesn't help", new Object[0])).isTrue();
    }

    @Test
    public void testTypeConversions() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"long", (Object)131L), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: Integer value promoted", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"long", (Object)129L), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: Integer value promoted", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)31L), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: Long value truncated", new Object[0])).isTrue();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)29L), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: Long value truncated", new Object[0])).isFalse();
        shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)0x80000000L), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: Long value outside Integer range", new Object[0])).isFalse();
    }

    @Test
    public void testTransformFilter() {
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((UnboundTerm)Expressions.year((String)"timestamp"), (Object)10), true).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: filter contains non-reference evaluate as True", new Object[0])).isTrue();
    }

    @Test
    public void testIncompatibleColumnNameEq() {
        for (int i = 0; i < 50; ++i) {
            boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"incompatible-name", (Object)new BigDecimal(String.valueOf(77.77 + (double)i)))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: decimal within range", new Object[0])).isTrue();
        }
        boolean shouldRead = new ParquetBloomRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)"incompatible-name", (Object)new BigDecimal("1234.56"))).shouldRead(this.parquetSchema, this.rowGroupMetadata, this.bloomStore);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: decimal outside range", new Object[0])).isFalse();
    }

    static {
        int i;
        STRUCT_FIELD_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"int_field", (Type)Types.IntegerType.get())});
        SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"double", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"float", (Type)Types.FloatType.get()), Types.NestedField.required((int)5, (String)"string", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"uuid", (Type)Types.UUIDType.get()), Types.NestedField.required((int)7, (String)"required", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"non_bloom", (Type)Types.StringType.get()), Types.NestedField.optional((int)9, (String)"all_nulls", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)11, (String)"no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)12, (String)"all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)13, (String)"some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)14, (String)"no_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)15, (String)"struct_not_null", (Type)STRUCT_FIELD_TYPE), Types.NestedField.optional((int)17, (String)"not_in_file", (Type)Types.FloatType.get()), Types.NestedField.optional((int)18, (String)"no_stats", (Type)Types.StringType.get()), Types.NestedField.optional((int)19, (String)"boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)20, (String)"time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)21, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)22, (String)"timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)23, (String)"timestamptz", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)24, (String)"binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)25, (String)"int_decimal", (Type)Types.DecimalType.of((int)8, (int)2)), Types.NestedField.optional((int)26, (String)"long_decimal", (Type)Types.DecimalType.of((int)14, (int)2)), Types.NestedField.optional((int)27, (String)"fixed_decimal", (Type)Types.DecimalType.of((int)31, (int)2)), Types.NestedField.optional((int)28, (String)"incompatible-name", (Type)Types.DecimalType.of((int)8, (int)2))});
        UNDERSCORE_STRUCT_FIELD_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"_int_field", (Type)Types.IntegerType.get())});
        FILE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"_id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"_long", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"_double", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"_float", (Type)Types.FloatType.get()), Types.NestedField.required((int)5, (String)"_string", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"_uuid", (Type)Types.UUIDType.get()), Types.NestedField.required((int)7, (String)"_required", (Type)Types.StringType.get()), Types.NestedField.required((int)8, (String)"_non_bloom", (Type)Types.StringType.get()), Types.NestedField.optional((int)9, (String)"_all_nulls", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"_some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)11, (String)"_no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)12, (String)"_all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)13, (String)"_some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)14, (String)"_no_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)15, (String)"_struct_not_null", (Type)UNDERSCORE_STRUCT_FIELD_TYPE), Types.NestedField.optional((int)18, (String)"_no_stats", (Type)Types.StringType.get()), Types.NestedField.optional((int)19, (String)"_boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)20, (String)"_time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)21, (String)"_date", (Type)Types.DateType.get()), Types.NestedField.optional((int)22, (String)"_timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)23, (String)"_timestamptz", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)24, (String)"_binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)25, (String)"_int_decimal", (Type)Types.DecimalType.of((int)8, (int)2)), Types.NestedField.optional((int)26, (String)"_long_decimal", (Type)Types.DecimalType.of((int)14, (int)2)), Types.NestedField.optional((int)27, (String)"_fixed_decimal", (Type)Types.DecimalType.of((int)31, (int)2)), Types.NestedField.optional((int)28, (String)"_incompatible-name", (Type)Types.DecimalType.of((int)8, (int)2))});
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 200; ++i) {
            sb.append(UUID.randomUUID());
        }
        TOO_LONG_FOR_STATS = sb.toString();
        INSTANT = Instant.parse("2018-10-10T00:00:00.000Z");
        RANDOM_UUIDS = Lists.newArrayList();
        Random rd = new Random(12345L);
        for (i = 0; i < 50; ++i) {
            RANDOM_UUIDS.add(new UUID(rd.nextLong(), rd.nextLong()));
        }
        RANDOM_BYTES = Lists.newArrayList();
        for (i = 1; i <= 50; ++i) {
            byte[] byteArray = new byte[i];
            rd.nextBytes(byteArray);
            RANDOM_BYTES.add(byteArray);
        }
    }

    private static class DummyBloomFilterReader
    extends BloomFilterReader {
        DummyBloomFilterReader(ParquetFileReader fileReader, BlockMetaData block) {
            super(fileReader, block);
        }

        public BloomFilter readBloomFilter(ColumnChunkMetaData meta) {
            return null;
        }
    }
}

