/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.parquet.schema.MessageType;

class ParquetWritingTestUtils {
    private ParquetWritingTestUtils() {
    }

    static File writeRecords(Path temp, Schema schema, GenericData.Record ... records) throws IOException {
        return ParquetWritingTestUtils.writeRecords(temp, schema, Collections.emptyMap(), null, records);
    }

    static File writeRecords(Path temp, Schema schema, Map<String, String> properties, GenericData.Record ... records) throws IOException {
        return ParquetWritingTestUtils.writeRecords(temp, schema, properties, null, records);
    }

    static File writeRecords(Path temp, Schema schema, Map<String, String> properties, Function<MessageType, ParquetValueWriter<?>> createWriterFunc, GenericData.Record ... records) throws IOException {
        File file = ParquetWritingTestUtils.createTempFile(temp);
        ParquetWritingTestUtils.write(file, schema, properties, createWriterFunc, records);
        return file;
    }

    static long write(File file, Schema schema, Map<String, String> properties, Function<MessageType, ParquetValueWriter<?>> createWriterFunc, GenericData.Record ... records) throws IOException {
        long len;
        FileAppender writer;
        try (FileAppender toClose = writer = Parquet.write((OutputFile)Files.localOutput((File)file)).schema(schema).setAll(properties).createWriterFunc(createWriterFunc).build();){
            writer.addAll((Iterable)Lists.newArrayList((Object[])records));
            len = writer.length();
        }
        if (writer instanceof ParquetWriter) {
            len = writer.length();
        }
        return len;
    }

    static File createTempFile(Path temp) throws IOException {
        File tmpFolder = temp.resolve("parquet").toFile();
        String filename = UUID.randomUUID().toString();
        return new File(tmpFolder, FileFormat.PARQUET.addExtension(filename));
    }
}

