/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.TestReadProjection;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestParquetReadProjection
extends TestReadProjection {
    protected GenericData.Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, GenericData.Record record) throws IOException {
        File file = this.temp.resolve(desc + ".parquet").toFile();
        file.delete();
        try (FileAppender appender = Parquet.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).build();){
            appender.add((Object)record);
        }
        CloseableIterable records = Parquet.read((InputFile)Files.localInput((File)file)).project(readSchema).callInit().build();
        return (GenericData.Record)Iterables.getOnlyElement((Iterable)records);
    }

    @Test
    @Disabled(value="Empty struct read is not supported for Parquet")
    public void testEmptyStructProjection() throws Exception {
    }

    @Test
    @Disabled(value="Empty struct read is not supported for Parquet")
    public void testEmptyStructRequiredProjection() throws Exception {
    }

    @Test
    @Disabled(value="Empty struct read is not supported for Parquet")
    public void testRequiredEmptyStructInRequiredStruct() throws Exception {
    }

    @Test
    @Disabled(value="Empty struct read is not supported for Parquet")
    public void testEmptyNestedStructProjection() throws Exception {
    }

    @Test
    @Disabled(value="Empty struct read is not supported for Parquet")
    public void testEmptyNestedStructRequiredProjection() throws Exception {
    }
}

