/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestLoadHiveCatalog {
    private static TestHiveMetastore metastore;

    @BeforeAll
    public static void startMetastore() throws Exception {
        HiveConf hiveConf = new HiveConf(TestLoadHiveCatalog.class);
        metastore = new TestHiveMetastore();
        metastore.start(hiveConf);
    }

    @AfterAll
    public static void stopMetastore() throws Exception {
        if (metastore != null) {
            metastore.stop();
            metastore = null;
        }
    }

    @Test
    public void testCustomCacheKeys() throws Exception {
        HiveCatalog hiveCatalog1 = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", Collections.emptyMap(), (Object)metastore.hiveConf());
        HiveCatalog hiveCatalog2 = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", Collections.emptyMap(), (Object)metastore.hiveConf());
        CachedClientPool clientPool1 = (CachedClientPool)hiveCatalog1.clientPool();
        CachedClientPool clientPool2 = (CachedClientPool)hiveCatalog2.clientPool();
        Assertions.assertThat((Object)clientPool2.clientPool()).isSameAs((Object)clientPool1.clientPool());
        Configuration conf1 = new Configuration((Configuration)metastore.hiveConf());
        Configuration conf2 = new Configuration((Configuration)metastore.hiveConf());
        conf1.set("any.key", "any.value");
        conf2.set("any.key", "any.value");
        hiveCatalog1 = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client-pool-cache-keys", (Object)"conf:any.key"), (Object)conf1);
        hiveCatalog2 = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client-pool-cache-keys", (Object)"conf:any.key"), (Object)conf2);
        clientPool1 = (CachedClientPool)hiveCatalog1.clientPool();
        clientPool2 = (CachedClientPool)hiveCatalog2.clientPool();
        Assertions.assertThat((Object)clientPool2.clientPool()).isSameAs((Object)clientPool1.clientPool());
        conf2.set("any.key", "any.value2");
        hiveCatalog2 = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client-pool-cache-keys", (Object)"conf:any.key"), (Object)conf2);
        clientPool2 = (CachedClientPool)hiveCatalog2.clientPool();
        Assertions.assertThat((Object)clientPool2.clientPool()).isNotSameAs((Object)clientPool1.clientPool());
    }
}

