/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.util.Tasks;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class TestHiveTableConcurrency
extends HiveTableBaseTest {
    @Test
    public synchronized void testConcurrentFastAppends() {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        String fileName = UUID.randomUUID().toString();
        DataFile file = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        int threadsCount = 2;
        Tasks.range((int)threadsCount).stopOnFailure().throwFailureWhenFinished().executeWith(executorService).run(index -> {
            int numCommittedFiles = 0;
            while (numCommittedFiles < 10) {
                int currentFilesCount = numCommittedFiles++;
                Awaitility.await().pollInterval(Duration.ofMillis(10L)).atMost(Duration.ofSeconds(10L)).until(() -> barrier.get() >= currentFilesCount * threadsCount);
                icebergTable.newFastAppend().appendFile(file).commit();
                barrier.incrementAndGet();
            }
        });
        icebergTable.refresh();
        Assertions.assertThat((List)icebergTable.currentSnapshot().allManifests(icebergTable.io())).hasSize(20);
    }

    @Test
    public synchronized void testConcurrentConnections() throws InterruptedException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        icebergTable.updateProperties().set("commit.retry.num-retries", "20").set("commit.retry.min-wait-ms", "25").set("commit.retry.max-wait-ms", "25").commit();
        String fileName = UUID.randomUUID().toString();
        DataFile file = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(7)));
        for (int i = 0; i < 7; ++i) {
            executorService.submit(() -> icebergTable.newAppend().appendFile(file).commit());
        }
        executorService.shutdown();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)executorService.awaitTermination(3L, TimeUnit.MINUTES)).as("Timeout", new Object[0])).isTrue();
        Assertions.assertThat((Iterable)icebergTable.snapshots()).hasSize(7);
    }
}

