/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveMetastoreExtension;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestCachedClientPool {
    private static final long EVICTION_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    private static final String DB_NAME = "hivedb";
    @RegisterExtension
    private static final HiveMetastoreExtension HIVE_METASTORE_EXTENSION = HiveMetastoreExtension.builder().withDatabase("hivedb").build();

    @Test
    public void testClientPoolCleaner() throws InterruptedException {
        CachedClientPool clientPool = new CachedClientPool((Configuration)HIVE_METASTORE_EXTENSION.hiveConf(), (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(EVICTION_INTERVAL)));
        HiveClientPool clientPool1 = clientPool.clientPool();
        Assertions.assertThat((Object)clientPool1).isSameAs(CachedClientPool.clientPoolCache().getIfPresent((Object)CachedClientPool.extractKey(null, (Configuration)HIVE_METASTORE_EXTENSION.hiveConf())));
        TimeUnit.MILLISECONDS.sleep(EVICTION_INTERVAL - TimeUnit.SECONDS.toMillis(2L));
        HiveClientPool clientPool2 = clientPool.clientPool();
        Assertions.assertThat((Object)clientPool2).isSameAs((Object)clientPool1);
        TimeUnit.MILLISECONDS.sleep(EVICTION_INTERVAL + TimeUnit.SECONDS.toMillis(5L));
        Assertions.assertThat((Object)((HiveClientPool)CachedClientPool.clientPoolCache().getIfPresent((Object)CachedClientPool.extractKey(null, (Configuration)HIVE_METASTORE_EXTENSION.hiveConf())))).isNull();
        Assertions.assertThat((boolean)clientPool1.isClosed()).isTrue();
        Assertions.assertThat((boolean)clientPool2.isClosed()).isTrue();
    }

    @Test
    public void testCacheKey() throws Exception {
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        UserGroupInformation foo1 = UserGroupInformation.createProxyUser((String)"foo", (UserGroupInformation)current);
        UserGroupInformation foo2 = UserGroupInformation.createProxyUser((String)"foo", (UserGroupInformation)current);
        UserGroupInformation bar = UserGroupInformation.createProxyUser((String)"bar", (UserGroupInformation)current);
        HiveConf hiveConf = HIVE_METASTORE_EXTENSION.hiveConf();
        CachedClientPool.Key key1 = (CachedClientPool.Key)foo1.doAs(() -> CachedClientPool.extractKey((String)"user_name,conf:key1", (Configuration)hiveConf));
        CachedClientPool.Key key2 = (CachedClientPool.Key)foo2.doAs(() -> CachedClientPool.extractKey((String)"conf:key1,user_name", (Configuration)hiveConf));
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Key elements order shouldn't matter", new Object[0])).isEqualTo((Object)key1);
        key1 = (CachedClientPool.Key)foo1.doAs(() -> CachedClientPool.extractKey((String)"ugi", (Configuration)hiveConf));
        key2 = (CachedClientPool.Key)bar.doAs(() -> CachedClientPool.extractKey((String)"ugi", (Configuration)hiveConf));
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Different users are not supposed to be equivalent", new Object[0])).isNotEqualTo((Object)key1);
        key2 = (CachedClientPool.Key)foo2.doAs(() -> CachedClientPool.extractKey((String)"ugi", (Configuration)hiveConf));
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Different UGI instances are not supposed to be equivalent", new Object[0])).isNotEqualTo((Object)key1);
        key1 = CachedClientPool.extractKey((String)"ugi", (Configuration)hiveConf);
        key2 = CachedClientPool.extractKey((String)"ugi,conf:key1", (Configuration)hiveConf);
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Keys with different number of elements are not supposed to be equivalent", new Object[0])).isNotEqualTo((Object)key1);
        Configuration conf1 = new Configuration((Configuration)hiveConf);
        Configuration conf2 = new Configuration((Configuration)hiveConf);
        conf1.set("key1", "val");
        key1 = CachedClientPool.extractKey((String)"conf:key1", (Configuration)conf1);
        key2 = CachedClientPool.extractKey((String)"conf:key1", (Configuration)conf2);
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Config with different values are not supposed to be equivalent", new Object[0])).isNotEqualTo((Object)key1);
        conf2.set("key1", "val");
        conf2.set("key2", "val");
        key2 = CachedClientPool.extractKey((String)"conf:key2", (Configuration)conf2);
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Config with different keys are not supposed to be equivalent", new Object[0])).isNotEqualTo((Object)key1);
        key1 = CachedClientPool.extractKey((String)"conf:key1,ugi", (Configuration)conf1);
        key2 = CachedClientPool.extractKey((String)"ugi,conf:key1", (Configuration)conf2);
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Config with same key/value should be equivalent", new Object[0])).isEqualTo((Object)key1);
        conf1.set("key2", "val");
        key1 = CachedClientPool.extractKey((String)"conf:key2 ,conf:key1", (Configuration)conf1);
        key2 = CachedClientPool.extractKey((String)"conf:key2,conf:key1", (Configuration)conf2);
        ((ObjectAssert)Assertions.assertThat((Object)key2).as("Config with same key/value should be equivalent", new Object[0])).isEqualTo((Object)key1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CachedClientPool.extractKey((String)"ugi,ugi", (Configuration)hiveConf), (String)"Duplicate key elements should result in an error", (Object[])new Object[0]).isInstanceOf(ValidationException.class)).hasMessageContaining("UGI key element already specified");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CachedClientPool.extractKey((String)"conf:k1,conf:k2,CONF:k1", (Configuration)hiveConf), (String)"Duplicate conf key elements should result in an error", (Object[])new Object[0]).isInstanceOf(ValidationException.class)).hasMessageContaining("Conf key element k1 already specified");
    }

    @Test
    public void testHmsCatalog() {
        ImmutableMap properties = ImmutableMap.of((Object)String.valueOf(EVICTION_INTERVAL), (Object)String.valueOf(Integer.MAX_VALUE), (Object)"type", (Object)"hive");
        Configuration conf1 = new Configuration();
        conf1.set("metastore.catalog.default", "foo");
        Configuration conf2 = new Configuration();
        conf2.set("metastore.catalog.default", "foo");
        Configuration conf3 = new Configuration();
        conf3.set("metastore.catalog.default", "bar");
        HiveCatalog catalog1 = (HiveCatalog)CatalogUtil.buildIcebergCatalog((String)"1", (Map)properties, (Object)conf1);
        HiveCatalog catalog2 = (HiveCatalog)CatalogUtil.buildIcebergCatalog((String)"2", (Map)properties, (Object)conf2);
        HiveCatalog catalog3 = (HiveCatalog)CatalogUtil.buildIcebergCatalog((String)"3", (Map)properties, (Object)conf3);
        HiveCatalog catalog4 = (HiveCatalog)CatalogUtil.buildIcebergCatalog((String)"4", (Map)properties, (Object)new Configuration());
        HiveClientPool pool1 = ((CachedClientPool)catalog1.clientPool()).clientPool();
        HiveClientPool pool2 = ((CachedClientPool)catalog2.clientPool()).clientPool();
        HiveClientPool pool3 = ((CachedClientPool)catalog3.clientPool()).clientPool();
        HiveClientPool pool4 = ((CachedClientPool)catalog4.clientPool()).clientPool();
        Assertions.assertThat((Object)pool2).isSameAs((Object)pool1);
        Assertions.assertThat((Object)pool1).isNotSameAs((Object)pool3);
        Assertions.assertThat((Object)pool2).isNotSameAs((Object)pool3);
        Assertions.assertThat((Object)pool4).isNotSameAs((Object)pool3);
        Assertions.assertThat((Object)pool1).isNotSameAs((Object)pool4);
        Assertions.assertThat((Object)pool2).isNotSameAs((Object)pool4);
        Assertions.assertThat((String)pool1.hiveConf().get("metastore.catalog.default")).isEqualTo("foo");
        Assertions.assertThat((String)pool3.hiveConf().get("metastore.catalog.default")).isEqualTo("bar");
        Assertions.assertThat((String)pool4.hiveConf().get("metastore.catalog.default")).isNull();
        pool1.close();
        pool3.close();
        pool4.close();
    }
}

