/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.TreeIndexTestUtils;
import org.apache.hyracks.storage.am.common.util.HashMultiSet;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestContext;
import org.apache.hyracks.storage.am.rtree.RTreeCheckTuple;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class RTreeTestUtils
extends TreeIndexTestUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private int intPayloadValue = 0;
    private double doublePayloadValue = 0.0;

    public HashMultiSet<RTreeCheckTuple> getRangeSearchExpectedResults(Collection<RTreeCheckTuple> checkTuples, RTreeCheckTuple key) {
        HashMultiSet expectedResult = new HashMultiSet();
        for (RTreeCheckTuple t : checkTuples) {
            if (!t.intersect(key)) continue;
            expectedResult.add((Object)t);
        }
        return expectedResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRangeSearch(IIndexTestContext ictx, ITupleReference key) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Testing Range Search.");
        }
        AbstractRTreeTestContext ctx = (AbstractRTreeTestContext)ictx;
        MultiComparator cmp = RTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])ctx.getComparatorFactories(), (ITupleReference)key);
        IIndexCursor searchCursor = ctx.getIndexAccessor().createSearchCursor(false);
        try {
            SearchPredicate searchPred = new SearchPredicate(key, cmp);
            ctx.getIndexAccessor().search(searchCursor, (ISearchPredicate)searchPred);
            try {
                RTreeCheckTuple keyCheck = (RTreeCheckTuple)this.createCheckTupleFromTuple(key, ctx.getFieldSerdes(), cmp.getKeyFieldCount());
                HashMultiSet<RTreeCheckTuple> expectedResult = null;
                expectedResult = this.getRangeSearchExpectedResults(ctx.getCheckTuples(), keyCheck);
                this.checkExpectedResults(searchCursor, (Collection)expectedResult, ctx.getFieldSerdes(), ctx.getKeyFieldCount(), null);
            }
            finally {
                searchCursor.close();
            }
        }
        finally {
            searchCursor.destroy();
        }
    }

    public void insertDoubleTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws HyracksDataException {
        this.insertDoubleTuples(ctx, numTuples, rnd, false);
    }

    public void insertDoubleTuples(IIndexTestContext ctx, int numTuples, Random rnd, boolean isPoint) throws HyracksDataException {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        double[] fieldValues = new double[ctx.getFieldCount()];
        double maxValue = Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        for (int i = 0; i < numTuples; ++i) {
            this.setDoubleKeyFields(fieldValues, numKeyFields, maxValue, rnd, isPoint);
            this.setDoublePayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createDoubleTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (double[])fieldValues);
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            try {
                ctx.getIndexAccessor().insert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createDoubleCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                continue;
            }
            catch (HyracksDataException e) {
                if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) continue;
                throw e;
            }
        }
    }

    private void setDoubleKeyFields(double[] fieldValues, int numKeyFields, double maxValue, Random rnd, boolean isPoint) {
        int maxFieldPos = numKeyFields / 2;
        for (int j = 0; j < maxFieldPos; ++j) {
            double secondValue;
            int k = maxFieldPos + j;
            double firstValue = rnd.nextDouble() % maxValue;
            if (isPoint) {
                secondValue = firstValue;
            } else {
                while ((secondValue = rnd.nextDouble() % maxValue) < firstValue) {
                }
            }
            fieldValues[j] = firstValue;
            fieldValues[k] = secondValue;
        }
    }

    private void setDoublePayloadFields(double[] fieldValues, int numKeyFields, int numFields) {
        for (int j = numKeyFields; j < numFields; ++j) {
            this.doublePayloadValue += 1.0;
        }
    }

    protected CheckTuple createDoubleCheckTuple(double[] fieldValues, int numKeyFields) {
        RTreeCheckTuple<Double> checkTuple = new RTreeCheckTuple<Double>(fieldValues.length, numKeyFields);
        for (double v : fieldValues) {
            checkTuple.appendField(v);
        }
        return checkTuple;
    }

    public void bulkLoadDoubleTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        this.bulkLoadDoubleTuples(ctx, numTuples, rnd, false);
    }

    public void bulkLoadDoubleTuples(IIndexTestContext ctx, int numTuples, Random rnd, boolean isPoint) throws HyracksDataException {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        double[] fieldValues = new double[ctx.getFieldCount()];
        double maxValue = Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        Collection tmpCheckTuples = this.createCheckTuplesCollection();
        for (int i = 0; i < numTuples; ++i) {
            this.setDoubleKeyFields(fieldValues, numKeyFields, maxValue, rnd, isPoint);
            this.setDoublePayloadFields(fieldValues, numKeyFields, fieldCount);
            ctx.insertCheckTuple(this.createDoubleCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        RTreeTestUtils.bulkLoadCheckTuples(ctx, tmpCheckTuples);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    @Override
    public void checkExpectedResults(IIndexCursor cursor, Collection checkTuples, ISerializerDeserializer[] fieldSerdes, int keyFieldCount, Iterator<CheckTuple> checkIter) throws Exception {
        int actualCount = 0;
        while (cursor.hasNext()) {
            cursor.next();
            ITupleReference tuple = cursor.getTuple();
            RTreeCheckTuple checkTuple = (RTreeCheckTuple)this.createCheckTupleFromTuple(tuple, fieldSerdes, keyFieldCount);
            if (!checkTuples.contains(checkTuple)) {
                Assert.fail((String)("Scan or range search returned unexpected answer: " + checkTuple.toString()));
            }
            ++actualCount;
        }
        if (actualCount < checkTuples.size()) {
            Assert.fail((String)("Scan or range search returned fewer answers than expected.\nExpected: " + checkTuples.size() + "\nActual  : " + actualCount));
        }
        if (actualCount > checkTuples.size()) {
            Assert.fail((String)("Scan or range search returned more answers than expected.\nExpected: " + checkTuples.size() + "\nActual  : " + actualCount));
        }
    }

    @Override
    protected CheckTuple createCheckTuple(int numFields, int numKeyFields) {
        return new RTreeCheckTuple(numFields, numKeyFields);
    }

    @Override
    protected ISearchPredicate createNullSearchPredicate() {
        return new SearchPredicate(null, null);
    }

    @Override
    protected CheckTuple createIntCheckTuple(int[] fieldValues, int numKeyFields) {
        RTreeCheckTuple<Integer> checkTuple = new RTreeCheckTuple<Integer>(fieldValues.length, numKeyFields);
        for (int v : fieldValues) {
            checkTuple.appendField(v);
        }
        return checkTuple;
    }

    public void bulkLoadIntTuples(IIndexTestContext ctx, int numTuples, Random rnd, boolean isPoint) throws HyracksDataException {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        Collection tmpCheckTuples = this.createCheckTuplesCollection();
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd, isPoint);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        RTreeTestUtils.bulkLoadCheckTuples(ctx, tmpCheckTuples, false);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    protected void setIntKeyFields(int[] fieldValues, int numKeyFields, int maxValue, Random rnd, boolean isPoint) {
        int maxFieldPos = numKeyFields / 2;
        for (int j = 0; j < maxFieldPos; ++j) {
            int secondValue;
            int k = maxFieldPos + j;
            int firstValue = rnd.nextInt() % maxValue;
            if (isPoint) {
                secondValue = firstValue;
            } else {
                while ((secondValue = rnd.nextInt() % maxValue) < firstValue) {
                }
            }
            fieldValues[j] = firstValue;
            fieldValues[k] = secondValue;
        }
    }

    @Override
    protected void setIntKeyFields(int[] fieldValues, int numKeyFields, int maxValue, Random rnd) {
        this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd, false);
    }

    @Override
    protected void setIntPayloadFields(int[] fieldValues, int numKeyFields, int numFields) {
        for (int j = numKeyFields; j < numFields; ++j) {
            ++this.intPayloadValue;
        }
    }

    @Override
    protected Collection createCheckTuplesCollection() {
        return new ArrayList();
    }

    @Override
    protected ArrayTupleBuilder createDeleteTupleBuilder(IIndexTestContext ctx) {
        return new ArrayTupleBuilder(ctx.getFieldCount());
    }

    @Override
    protected boolean checkDiskOrderScanResult(ITupleReference tuple, CheckTuple checkTuple, IIndexTestContext ctx) throws HyracksDataException {
        return ctx.getCheckTuples().contains(checkTuple);
    }
}

