/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

public class CheckTuple<T extends Comparable<T>>
implements Comparable<T> {
    protected final int numKeys;
    protected final Comparable[] fields;
    protected int pos;
    protected boolean isHighKey;

    public CheckTuple(int numFields, int numKeys) {
        this.numKeys = numKeys;
        this.fields = new Comparable[numFields];
        this.pos = 0;
        this.isHighKey = false;
    }

    public void appendField(T e) {
        this.fields[this.pos++] = e;
    }

    @Override
    public int compareTo(T o) {
        CheckTuple other = (CheckTuple)o;
        int cmpFieldCount = Math.min(other.getNumKeys(), this.numKeys);
        for (int i = 0; i < cmpFieldCount; ++i) {
            int cmp = this.fields[i].compareTo(other.getField(i));
            if (cmp == 0) continue;
            return cmp;
        }
        if (other.getNumKeys() == this.numKeys) {
            return 0;
        }
        if (other.getNumKeys() < this.numKeys) {
            return other.isHighKey ? -1 : 1;
        }
        if (other.getNumKeys() > this.numKeys) {
            return this.isHighKey ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Comparable)) {
            return false;
        }
        return this.compareTo((T)((Comparable)o)) == 0;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.numKeys; ++i) {
            hash = 37 * hash + this.fields[i].hashCode();
        }
        return hash;
    }

    public void setIsHighKey(boolean isHighKey) {
        this.isHighKey = isHighKey;
    }

    public T getField(int idx) {
        return (T)this.fields[idx];
    }

    public void setField(int idx, T e) {
        this.fields[idx] = e;
    }

    public int size() {
        return this.fields.length;
    }

    public int getNumKeys() {
        return this.numKeys;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < this.fields.length; ++i) {
            strBuilder.append(this.fields[i].toString());
            if (i == this.fields.length - 1) continue;
            strBuilder.append(" ");
        }
        return strBuilder.toString();
    }
}

