/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.NoOpWarningCollector;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.control.nc.io.DefaultDeviceResolver;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.test.support.TestJobletContext;
import org.apache.hyracks.test.support.TestNCServiceContext;
import org.apache.hyracks.test.support.TestTaskContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;

public class TestUtils {
    private static final int DEFAULT_FRAME_SIZE = 32768;
    public static final IWarningCollector NOOP_WARNING_COLLECTOR = NoOpWarningCollector.INSTANCE;

    public static IHyracksTaskContext createHyracksTask() {
        return TestUtils.create(32768);
    }

    public static IHyracksTaskContext create(int frameSize) {
        IOManager ioManager = null;
        try {
            ioManager = TestUtils.createIoManager();
            return TestUtils.create(frameSize, ioManager);
        }
        catch (Exception e) {
            if (ioManager != null) {
                CleanupUtils.close((AutoCloseable)ioManager, (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    public static IHyracksTaskContext create(int frameSize, IOManager ioManager) {
        try {
            TestNCServiceContext serviceCtx = new TestNCServiceContext((IIOManager)ioManager, null);
            TestJobletContext jobletCtx = new TestJobletContext(frameSize, serviceCtx, new JobId(0L));
            TaskAttemptId tid = new TaskAttemptId(new TaskId(new ActivityId(new OperatorDescriptorId(0), 0), 0), 0);
            TestTaskContext taskCtx = new TestTaskContext(jobletCtx, tid, 1);
            return taskCtx;
        }
        catch (HyracksException e) {
            throw new RuntimeException(e);
        }
    }

    private static IOManager createIoManager() throws HyracksException {
        ArrayList<IODeviceHandle> devices = new ArrayList<IODeviceHandle>();
        devices.add(new IODeviceHandle(new File(System.getProperty("java.io.tmpdir")), "."));
        return new IOManager(devices, (IFileDeviceResolver)new DefaultDeviceResolver(), 2, 10);
    }

    public static void compareWithResult(File expectedFile, File actualFile) throws Exception {
        int num = 1;
        try (BufferedReader readerExpected = new BufferedReader(new FileReader(expectedFile));
             BufferedReader readerActual = new BufferedReader(new FileReader(actualFile));){
            String lineActual;
            String lineExpected;
            while ((lineExpected = readerExpected.readLine()) != null) {
                lineActual = readerActual.readLine();
                if (lineActual == null) {
                    throw new Exception("Actual result changed at line " + num + ":\n< " + lineExpected + "\n> ");
                }
                if (!TestUtils.equalStrings(lineExpected, lineActual)) {
                    throw new Exception("Result for changed at line " + num + ":\n< " + lineExpected + "\n> " + lineActual);
                }
                ++num;
            }
            lineActual = readerActual.readLine();
            if (lineActual != null) {
                throw new Exception("Actual result changed at line " + num + ":\n< \n> " + lineActual);
            }
        }
    }

    private static boolean equalStrings(String s1, String s2) {
        String[] rowsTwo;
        String[] rowsOne = s1.split("\n");
        if (rowsOne.length != (rowsTwo = s2.split("\n")).length) {
            return false;
        }
        for (int i = 0; i < rowsOne.length; ++i) {
            String row1 = rowsOne[i];
            String row2 = rowsTwo[i];
            if (row1.equals(row2)) continue;
            String[] fields1 = row1.split(",");
            String[] fields2 = row2.split(",");
            for (int j = 0; j < fields1.length; ++j) {
                float float2;
                if (fields1[j].equals(fields2[j])) continue;
                if (fields1[j].indexOf(46) < 0) {
                    return false;
                }
                fields1[j] = fields1[j].split("=")[1];
                fields2[j] = fields2[j].split("=")[1];
                Double double1 = Double.parseDouble(fields1[j]);
                Double double2 = Double.parseDouble(fields2[j]);
                float float1 = (float)double1.doubleValue();
                if (Math.abs(float1 - (float2 = (float)double2.doubleValue())) == 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public static Map<String, NodeControllerInfo> generateNodeControllerInfo(int numberOfNodes, String ncNamePrefix, String addressPrefix, int netPort, int dataPort, int messagingPort) {
        HashMap<String, NodeControllerInfo> ncNameToNcInfos = new HashMap<String, NodeControllerInfo>();
        for (int i = 1; i <= numberOfNodes; ++i) {
            String ncId = ncNamePrefix + i;
            String ncAddress = addressPrefix + i;
            ncNameToNcInfos.put(ncId, new NodeControllerInfo(ncId, NodeStatus.ACTIVE, new NetworkAddress(ncAddress, netPort), new NetworkAddress(ncAddress, dataPort), new NetworkAddress(ncAddress, messagingPort), 2));
        }
        return ncNameToNcInfos;
    }

    public static void redirectLoggingToConsole() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        Appender appender = config.getAppender("Console");
        if (appender == null) {
            Optional<Appender> result = config.getAppenders().values().stream().filter(a -> a instanceof ConsoleAppender).findFirst();
            if (!result.isPresent()) {
                System.err.println("ERROR: cannot find appender named 'Console'; unable to find alternate ConsoleAppender!");
            } else {
                appender = result.get();
                System.err.println("ERROR: cannot find appender named 'Console'; using alternate ConsoleAppender named " + appender.getName());
            }
        }
        if (appender != null) {
            config.getRootLogger().addAppender(appender, null, null);
            context.updateLoggers();
        }
    }
}

