/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.util.file.FileUtil;
import org.junit.Assert;

public abstract class LicensingTestBase {
    private String installerDir;

    protected void initInstallerDir() {
        if (this.installerDir == null) {
            String pattern = this.getInstallerDirPattern();
            String targetDir = this.getTargetDir();
            Object[] list = new File(targetDir).list((dir, name) -> name.matches(pattern));
            String topLevelPattern = this.getTopLevelDirPattern();
            String[] topLevel = topLevelPattern == null ? new String[]{""} : new File(FileUtil.joinPath((String[])new String[]{targetDir, list[0]})).list((dir, name) -> name.matches(topLevelPattern));
            this.installerDir = FileUtil.joinPath((String[])new String[]{targetDir, list[0], topLevel[0]});
            Assert.assertNotNull((String)"installerDir", (Object)list);
            Assert.assertFalse((String)("Ambiguous install dir (" + pattern + "): " + Arrays.toString(list)), (list.length > 1 ? 1 : 0) != 0);
            Assert.assertEquals((String)("Can't find install dir (" + pattern + ")"), (long)1L, (long)topLevel.length);
        }
    }

    protected abstract String getTargetDir();

    protected abstract String getInstallerDirPattern();

    protected abstract String getTopLevelDirPattern();

    protected abstract String pathToLicensingFiles();

    protected abstract String[] getRequiredArtifactNames();

    protected void verifyMissingLicenses() throws IOException {
        for (String licenseArtifactName : this.getLicenseArtifactNames()) {
            File licenseFile = new File(FileUtil.joinPath((String[])new String[]{this.getInstallerDir(), this.pathToLicensingFiles(), licenseArtifactName}));
            ArrayList<String> badLines = new ArrayList<String>();
            for (String line : FileUtils.readLines((File)licenseFile, (Charset)StandardCharsets.UTF_8)) {
                if (!line.matches("^\\s*MISSING:.*")) continue;
                badLines.add(line.trim());
            }
            Assert.assertEquals((String)("Missing licenses in " + licenseFile + ": " + badLines), (long)0L, (long)badLines.size());
        }
    }

    protected String getInstallerDir() {
        return this.installerDir;
    }

    protected void verifyAllRequiredArtifactsPresent() {
        for (String name : this.getRequiredArtifactNames()) {
            String fileName = FileUtil.joinPath((String[])new String[]{this.getInstallerDir(), this.pathToLicensingFiles(), name});
            Assert.assertTrue((String)(fileName + " missing"), (boolean)new File(fileName).exists());
        }
    }

    protected abstract String[] getLicenseArtifactNames();
}

