/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class FormattedExceptionTestBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Serializable[] FAKE_ARGS = new Serializable[]{"one", Integer.valueOf(2), Float.valueOf(3.0f), Double.valueOf(4.0), Byte.valueOf((byte)5)};
    private static final Serializable[] EMPTY_ARGS = new Serializable[0];
    private static final Class SERIALIZABLE_ARR_CLASS = EMPTY_ARGS.getClass();
    private static final ErrorCode HYR_ERROR_CODE = FormattedExceptionTestBase.random(ErrorCode.values());
    private static final StackTraceElement[] STACK_TRACE = new Throwable().getStackTrace();
    private static final SourceLocation SOURCE_LOCATION = new SourceLocation(99, 9);
    private static final ClassLoader CLASSLOADER = FormattedExceptionTestBase.class.getClassLoader();
    private static final Field THROWABLE_DETAIL_MESSAGE = FormattedExceptionTestBase.getDeclaredAccessibleField(Throwable.class, "detailMessage");
    private static final Field THROWABLE_CAUSE = FormattedExceptionTestBase.getDeclaredAccessibleField(Throwable.class, "cause");
    private static final UnsupportedOperationException FAKE_THROWABLE = new UnsupportedOperationException();
    private static final int PUBLIC_STATIC = 9;
    private static Collection<Class<? extends IFormattedException>> exceptionClasses;
    protected static Set<Class<? extends IFormattedException>> roots;
    private static Set<Executable> publicContractOverrides;
    protected final Executable action;
    protected final Class<? extends IFormattedException> root;
    private static final Map<Pair<Class<? extends IFormattedException>, Object>, Field> rootFields;
    private static final Set<Class> visited;
    protected static Predicate<String> classSelector;

    protected static Iterable<Object[]> defineParameters() throws ClassNotFoundException {
        FormattedExceptionTestBase.initClasses();
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (Class<? extends IFormattedException> clazz : exceptionClasses) {
            Constructor<?>[] declaredConstructors;
            Class root = roots.stream().filter(c -> c.isAssignableFrom(clazz)).findAny().orElseThrow(IllegalStateException::new);
            for (Constructor<?> ctor : declaredConstructors = clazz.getDeclaredConstructors()) {
                tests.add(new Object[]{clazz.getSimpleName() + ".<init>" + Stream.of(ctor.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.toList()), ctor, root});
            }
            int methods = 0;
            for (Method m : clazz.getDeclaredMethods()) {
                if ((m.getModifiers() & 9) != 9) continue;
                ++methods;
                tests.add(new Object[]{clazz.getSimpleName() + "." + m.getName() + Stream.of(m.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.toList()), m, root});
            }
            LOGGER.info("discovered {} ctors, {} methods for class {}", (Object)declaredConstructors.length, (Object)methods, clazz);
        }
        return tests;
    }

    protected static void addPublicContractOverride(Executable override) {
        publicContractOverrides.add(override);
    }

    public FormattedExceptionTestBase(String desc, Executable action, Class<? extends IFormattedException> root) {
        this.action = action;
        this.root = root;
    }

    @Test
    public void test() throws Exception {
        if (Modifier.isPublic(this.action.getModifiers())) {
            try {
                this.checkPublicContract();
            }
            catch (AssertionError e) {
                if (publicContractOverrides.contains(this.action)) {
                    LOGGER.info("ignoring public contract vioilation for override executable: " + this.action);
                }
                throw e;
            }
        }
        if (this.action.getName().equals("create") || this.action instanceof Constructor) {
            this.checkParameterPropagation(this.action);
        }
    }

    protected void checkPublicContract() {
        for (Class<?> type : this.action.getParameterTypes()) {
            Assert.assertNotEquals((String)"generic IError forbidden on public ctor or static method", type, IError.class);
        }
    }

    private void checkParameterPropagation(Executable factory) throws Exception {
        Object[] args = Stream.of(factory.getParameterTypes()).map(this::defaultValue).toArray(Object[]::new);
        factory.setAccessible(true);
        Field paramsField = this.rootParamsField();
        Object instance = factory instanceof Constructor ? ((Constructor)factory).newInstance(args) : ((Method)factory).invoke(null, args);
        Object[] params = (Serializable[])paramsField.get(instance);
        IError error = null;
        for (Class<?> type : factory.getParameterTypes()) {
            if (type.equals(paramsField.getType())) {
                Assert.assertArrayEquals((Object[])FAKE_ARGS, (Object[])params);
                continue;
            }
            if (SourceLocation.class.isAssignableFrom(type)) {
                Object value = this.rootSrcLocField().get(instance);
                Assert.assertEquals((String)("source location is wrong, was: " + value), (Object)SOURCE_LOCATION, (Object)value);
                continue;
            }
            if (IError.class.isAssignableFrom(type)) {
                error = (IError)this.rootErrorField().get(instance);
                Assert.assertNotNull((String)"error object", (Object)error);
                continue;
            }
            if (!type.equals(Throwable.class)) continue;
            Assert.assertEquals((Object)FAKE_THROWABLE, (Object)THROWABLE_CAUSE.get(instance));
        }
        if (error != null) {
            Assert.assertEquals((Object)error.component(), (Object)this.getRootField("component").get(instance));
            Assert.assertEquals((Object)error.intValue(), (Object)this.getRootField("errorCode").get(instance));
            Assert.assertEquals((Object)error.errorMessage(), (Object)THROWABLE_DETAIL_MESSAGE.get(instance));
        }
    }

    protected Field rootParamsField() {
        return this.getRootField(SERIALIZABLE_ARR_CLASS);
    }

    protected Field rootErrorField() {
        return this.getRootField(IError.class);
    }

    protected Field rootSrcLocField() {
        return this.getRootField(SourceLocation.class);
    }

    protected Field getRootField(Class<?> type) {
        return rootFields.computeIfAbsent((Pair<Class<? extends IFormattedException>, Object>)Pair.of(this.root, type), key -> Stream.of(this.root.getDeclaredFields()).filter(f -> f.getType().equals(type)).peek(f -> f.setAccessible(true)).findAny().orElseThrow(IllegalStateException::new));
    }

    protected Field getRootField(String name) {
        return rootFields.computeIfAbsent((Pair<Class<? extends IFormattedException>, Object>)Pair.of(this.root, (Object)name), key -> FormattedExceptionTestBase.getDeclaredAccessibleField(this.root, name));
    }

    protected static Field getDeclaredAccessibleField(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Object defaultValue(Class type) {
        switch (type.getName()) {
            case "int": {
                return 0;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "long": {
                return 0L;
            }
            case "boolean": {
                return false;
            }
            case "short": {
                return (short)0;
            }
            case "byte": {
                return (byte)0;
            }
            case "[Ljava.io.Serializable;": {
                return FAKE_ARGS;
            }
            case "java.lang.Throwable": {
                return FAKE_THROWABLE;
            }
            case "org.apache.hyracks.api.exceptions.IError": 
            case "org.apache.hyracks.api.exceptions.ErrorCode": {
                return HYR_ERROR_CODE;
            }
            case "[Ljava.lang.StackTraceElement;": {
                return STACK_TRACE;
            }
            case "org.apache.hyracks.api.exceptions.SourceLocation": {
                return SOURCE_LOCATION;
            }
            case "org.apache.hyracks.api.exceptions.HyracksDataException": {
                HyracksDataException hde = (HyracksDataException)Mockito.mock(HyracksDataException.class);
                Mockito.when((Object)hde.getError()).thenReturn(Optional.empty());
                return hde;
            }
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        if (type.isEnum()) {
            return FormattedExceptionTestBase.random(type.getEnumConstants());
        }
        if (type.isAnonymousClass() || Modifier.isFinal(type.getModifiers())) {
            if (visited.add(type)) {
                LOGGER.info("defaulting to null for un-mockable class {}", (Object)type.getName());
            }
            return null;
        }
        if (visited.add(type)) {
            LOGGER.info("defaulting to mock for unmapped class {}", (Object)type.getName());
        }
        return Mockito.mock((Class)type);
    }

    protected static <T> T random(T[] values) {
        return values[RandomUtils.nextInt((int)0, (int)values.length)];
    }

    private static void initClasses() throws ClassNotFoundException {
        LOGGER.info("discovering instances of IFormattedException");
        Class<?> clazz = Class.forName(IFormattedException.class.getName(), false, CLASSLOADER);
        exceptionClasses = FormattedExceptionTestBase.getInstanceClasses(clazz).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
        exceptionClasses.remove(clazz);
        LOGGER.info("found {} instances of IFormattedException: {}", (Object)exceptionClasses.size(), exceptionClasses);
        roots = exceptionClasses.stream().map(ex -> {
            while (IFormattedException.class.isAssignableFrom(ex.getSuperclass())) {
                ex = ex.getSuperclass();
            }
            return ex;
        }).collect(Collectors.toSet());
        LOGGER.info("found {} roots: {}", (Object)roots.size(), roots);
        exceptionClasses.removeAll(roots);
    }

    private static <T> Stream<Class<? extends T>> getInstanceClasses(Class<T> clazz) {
        return FormattedExceptionTestBase.getProductClasses().filter(name -> name.matches(".*(Exception|Error|Warning).*")).map(name -> {
            try {
                return Class.forName(name, false, CLASSLOADER);
            }
            catch (Throwable e) {
                LOGGER.warn("unable to open {} due to: {}", name, (Object)String.valueOf(e));
                return null;
            }
        }).filter(Objects::nonNull).filter(clazz::isAssignableFrom);
    }

    private static Stream<String> getProductClasses() {
        String[] cp = System.getProperty("java.class.path").split(File.pathSeparator);
        return Stream.of(cp).map(File::new).filter(File::isDirectory).flatMap(FormattedExceptionTestBase::extractClassFiles).map(name -> name.replace("/", ".")).filter(classSelector).map(name -> name.replaceAll("\\.class$", "")).sorted();
    }

    private static Stream<? extends String> extractClassFiles(File dir) {
        int beginIndex = dir.toString().length() + 1;
        return FileUtils.listFiles((File)dir, (String[])new String[]{"class"}, (boolean)true).stream().map(file -> file.getAbsolutePath().substring(beginIndex));
    }

    static {
        publicContractOverrides = new HashSet<Executable>();
        rootFields = new HashMap<Pair<Class<? extends IFormattedException>, Object>, Field>();
        visited = new HashSet<Class>();
        classSelector = className -> true;
    }
}

