/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncodingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private EncodingUtils() {
    }

    public static boolean canEncodeDecode(String input, Charset charset, boolean quiet) {
        block7: {
            try {
                if (input.equals(new String(input.getBytes(charset), charset))) {
                    if (!input.equals(charset.decode(charset.encode(CharBuffer.wrap(input))).toString())) {
                        if (!quiet) {
                            LOGGER.info("cannot encode / decode {} with {} using CharBuffer.wrap(<String>)", (Object)input, (Object)charset.displayName());
                        }
                    } else {
                        return true;
                    }
                }
                if (!quiet) {
                    LOGGER.info("cannot encode / decode {} with {}", (Object)input, (Object)charset.displayName());
                }
            }
            catch (Exception e) {
                if (quiet) break block7;
                LOGGER.info("cannot encode / decode {} with {}, got exception ({})", (Object)input, (Object)charset.displayName(), (Object)String.valueOf(e));
            }
        }
        return false;
    }

    public static Set<Charset> getLegalCharsetsFor(String input) {
        return Charset.availableCharsets().values().stream().filter(Charset::canEncode).filter(test -> EncodingUtils.canEncodeDecode(input, test, false)).collect(Collectors.toSet());
    }
}

