/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import java.util.Random;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestContext;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public abstract class AbstractRTreeTestDriver {
    protected final boolean testRstarPolicy;
    protected final Logger LOGGER = LogManager.getLogger();
    protected static final int numTuplesToInsert = 100;

    public AbstractRTreeTestDriver(boolean testRstarPolicy) {
        this.testRstarPolicy = testRstarPolicy;
    }

    protected abstract AbstractRTreeTestContext createTestContext(ISerializerDeserializer[] var1, IPrimitiveValueProviderFactory[] var2, int var3, RTreePolicyType var4) throws Exception;

    protected abstract Random getRandom();

    protected abstract void runTest(ISerializerDeserializer[] var1, IPrimitiveValueProviderFactory[] var2, int var3, ITupleReference var4, RTreePolicyType var5) throws Exception;

    protected abstract String getTestOpName();

    @Test
    public void rtreeTwoDimensionsInt() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("RTree " + this.getTestOpName() + " Test With Two Dimensions With Integer Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)IntegerPointable.FACTORY);
        ITupleReference key = TupleUtils.createIntegerTuple((int[])new int[]{-1000, -1000, 1000, 1000});
        this.runTest(fieldSerdes, valueProviderFactories, numKeys, key, RTreePolicyType.RTREE);
    }

    @Test
    public void rtreeTwoDimensionsDouble() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("RTree " + this.getTestOpName() + " Test With Two Dimensions With Double Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        ITupleReference key = TupleUtils.createDoubleTuple((double[])new double[]{-1000.0, -1000.0, 1000.0, 1000.0});
        this.runTest(fieldSerdes, valueProviderFactories, numKeys, key, RTreePolicyType.RTREE);
    }

    @Test
    public void rtreeFourDimensionsDouble() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("RTree " + this.getTestOpName() + " Test With Four Dimensions With Double Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 8;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        ITupleReference key = TupleUtils.createDoubleTuple((double[])new double[]{-1000.0, -1000.0, -1000.0, -1000.0, 1000.0, 1000.0, 1000.0, 1000.0});
        this.runTest(fieldSerdes, valueProviderFactories, numKeys, key, RTreePolicyType.RTREE);
    }

    @Test
    public void rstartreeTwoDimensionsInt() throws Exception {
        if (!this.testRstarPolicy) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info("Ignoring RTree " + this.getTestOpName() + " Test With Two Dimensions With Integer Keys.");
            }
            return;
        }
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("RTree " + this.getTestOpName() + " Test With Two Dimensions With Integer Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)IntegerPointable.FACTORY);
        ITupleReference key = TupleUtils.createIntegerTuple((int[])new int[]{-1000, -1000, 1000, 1000});
        this.runTest(fieldSerdes, valueProviderFactories, numKeys, key, RTreePolicyType.RSTARTREE);
    }

    @Test
    public void rstartreeTwoDimensionsDouble() throws Exception {
        if (!this.testRstarPolicy) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info("Ignoring RTree " + this.getTestOpName() + " Test With Two Dimensions With Double Keys.");
            }
            return;
        }
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("RTree " + this.getTestOpName() + " Test With Two Dimensions With Double Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        ITupleReference key = TupleUtils.createDoubleTuple((double[])new double[]{-1000.0, -1000.0, 1000.0, 1000.0});
        this.runTest(fieldSerdes, valueProviderFactories, numKeys, key, RTreePolicyType.RSTARTREE);
    }

    @Test
    public void rstartreeFourDimensionsDouble() throws Exception {
        if (!this.testRstarPolicy) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info("Ignoring RTree " + this.getTestOpName() + " Test With Four Dimensions With Double Keys.");
            }
            return;
        }
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("RTree " + this.getTestOpName() + " Test With Four Dimensions With Double Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 8;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        ITupleReference key = TupleUtils.createDoubleTuple((double[])new double[]{-1000.0, -1000.0, -1000.0, -1000.0, 1000.0, 1000.0, 1000.0, 1000.0});
        this.runTest(fieldSerdes, valueProviderFactories, numKeys, key, RTreePolicyType.RSTARTREE);
    }
}

