/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.datagen;

import java.util.Random;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.FloatSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.storage.am.common.datagen.DoubleFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.FloatFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.IntegerFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.SortedDoubleFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.SortedFloatFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.SortedIntegerFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.StringFieldValueGenerator;

public class DataGenUtils {
    public static IFieldValueGenerator getFieldGenFromSerde(ISerializerDeserializer serde, Random rnd, boolean sorted) {
        if (serde instanceof IntegerSerializerDeserializer) {
            if (sorted) {
                return new SortedIntegerFieldValueGenerator();
            }
            return new IntegerFieldValueGenerator(rnd);
        }
        if (serde instanceof FloatSerializerDeserializer) {
            if (sorted) {
                return new SortedFloatFieldValueGenerator();
            }
            return new FloatFieldValueGenerator(rnd);
        }
        if (serde instanceof DoubleSerializerDeserializer) {
            if (sorted) {
                return new SortedDoubleFieldValueGenerator();
            }
            return new DoubleFieldValueGenerator(rnd);
        }
        if (serde instanceof UTF8StringSerializerDeserializer) {
            return new StringFieldValueGenerator(20, rnd);
        }
        return null;
    }

    public static IFieldValueGenerator[] getFieldGensFromSerdes(ISerializerDeserializer[] serdes, Random rnd, boolean sorted) {
        IFieldValueGenerator[] fieldValueGens = new IFieldValueGenerator[serdes.length];
        for (int i = 0; i < serdes.length; ++i) {
            fieldValueGens[i] = DataGenUtils.getFieldGenFromSerde(serdes[i], rnd, sorted);
        }
        return fieldValueGens;
    }
}

