/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.MergeOperation;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.NoOpPageWriteCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public abstract class TreeIndexTestUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    protected abstract CheckTuple createCheckTuple(int var1, int var2);

    protected abstract ISearchPredicate createNullSearchPredicate();

    public abstract void checkExpectedResults(IIndexCursor var1, Collection var2, ISerializerDeserializer[] var3, int var4, Iterator<CheckTuple> var5) throws Exception;

    protected abstract CheckTuple createIntCheckTuple(int[] var1, int var2);

    protected abstract void setIntKeyFields(int[] var1, int var2, int var3, Random var4);

    protected abstract void setIntPayloadFields(int[] var1, int var2, int var3);

    protected abstract Collection createCheckTuplesCollection();

    protected abstract ArrayTupleBuilder createDeleteTupleBuilder(IIndexTestContext var1);

    protected abstract boolean checkDiskOrderScanResult(ITupleReference var1, CheckTuple var2, IIndexTestContext var3) throws HyracksDataException;

    public static int compareFilterTuples(ITupleReference lhs, ITupleReference rhs, IBinaryComparator comp) throws HyracksDataException {
        return comp.compare(lhs.getFieldData(0), lhs.getFieldStart(0), lhs.getFieldLength(0), rhs.getFieldData(0), rhs.getFieldStart(0), rhs.getFieldLength(0));
    }

    public static void createTupleFromCheckTuple(CheckTuple checkTuple, ArrayTupleBuilder tupleBuilder, ArrayTupleReference tuple, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        TreeIndexTestUtils.createTupleFromCheckTuple(checkTuple, tupleBuilder, tuple, fieldSerdes, false);
    }

    public static void createTupleFromCheckTuple(CheckTuple checkTuple, ArrayTupleBuilder tupleBuilder, ArrayTupleReference tuple, ISerializerDeserializer[] fieldSerdes, boolean filtered) throws HyracksDataException {
        int fieldCount = tupleBuilder.getFieldEndOffsets().length;
        DataOutput dos = tupleBuilder.getDataOutput();
        tupleBuilder.reset();
        for (int i = 0; i < (filtered ? fieldCount - 1 : fieldCount); ++i) {
            fieldSerdes[i].serialize(checkTuple.getField(i), dos);
            tupleBuilder.addFieldEndOffset();
        }
        if (filtered) {
            fieldSerdes[0].serialize(checkTuple.getField(0), dos);
            tupleBuilder.addFieldEndOffset();
        }
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
    }

    public CheckTuple createCheckTupleFromTuple(ITupleReference tuple, ISerializerDeserializer[] fieldSerdes, int numKeys) throws HyracksDataException {
        CheckTuple checkTuple = this.createCheckTuple(fieldSerdes.length, numKeys);
        int fieldCount = Math.min(fieldSerdes.length, tuple.getFieldCount());
        for (int i = 0; i < fieldCount; ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            DataInputStream dataIn = new DataInputStream(inStream);
            Comparable fieldObj = (Comparable)fieldSerdes[i].deserialize((DataInput)dataIn);
            checkTuple.appendField(fieldObj);
        }
        return checkTuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkScan(IIndexTestContext ctx) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Testing Scan.");
        }
        IIndexCursor scanCursor = ctx.getIndexAccessor().createSearchCursor(false);
        try {
            ISearchPredicate nullPred = this.createNullSearchPredicate();
            ctx.getIndexAccessor().search(scanCursor, nullPred);
            try {
                Iterator<CheckTuple> checkIter = ctx.getCheckTuples().iterator();
                this.checkExpectedResults(scanCursor, ctx.getCheckTuples(), ctx.getFieldSerdes(), ctx.getKeyFieldCount(), checkIter);
            }
            finally {
                scanCursor.close();
            }
        }
        finally {
            scanCursor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDiskOrderScan(IIndexTestContext ctx) throws Exception {
        block17: {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Testing Disk-Order Scan.");
                }
                ITreeIndexAccessor treeIndexAccessor = (ITreeIndexAccessor)ctx.getIndexAccessor();
                try {
                    ITreeIndexCursor diskOrderCursor = treeIndexAccessor.createDiskOrderScanCursor();
                    try {
                        int actualCount = 0;
                        treeIndexAccessor.diskOrderScan(diskOrderCursor);
                        try {
                            actualCount = this.scan(ctx, diskOrderCursor);
                        }
                        finally {
                            diskOrderCursor.close();
                        }
                        if (actualCount < ctx.getCheckTuples().size()) {
                            Assert.fail((String)("Disk-order scan returned fewer answers than expected.\nExpected: " + ctx.getCheckTuples().size() + "\nActual  : " + actualCount));
                        }
                        if (actualCount > ctx.getCheckTuples().size()) {
                            Assert.fail((String)("Disk-order scan returned more answers than expected.\nExpected: " + ctx.getCheckTuples().size() + "\nActual  : " + actualCount));
                        }
                    }
                    finally {
                        diskOrderCursor.destroy();
                    }
                }
                finally {
                    treeIndexAccessor.destroy();
                }
            }
            catch (UnsupportedOperationException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Ignoring disk-order scan since it's not supported.");
                }
            }
            catch (ClassCastException e) {
                if (!LOGGER.isInfoEnabled()) break block17;
                LOGGER.info("Ignoring disk-order scan since it's not supported.");
            }
        }
    }

    private int scan(IIndexTestContext ctx, ITreeIndexCursor diskOrderCursor) throws HyracksDataException {
        int actualCount = 0;
        while (diskOrderCursor.hasNext()) {
            diskOrderCursor.next();
            ITupleReference tuple = diskOrderCursor.getTuple();
            CheckTuple checkTuple = this.createCheckTupleFromTuple(tuple, ctx.getFieldSerdes(), ctx.getKeyFieldCount());
            if (!this.checkDiskOrderScanResult(tuple, checkTuple, ctx)) {
                Assert.fail((String)("Disk-order scan returned unexpected answer: " + checkTuple.toString()));
            }
            ++actualCount;
        }
        return actualCount;
    }

    public Pair<ITupleReference, ITupleReference> insertIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        return this.insertIntTuples(ctx, numTuples, false, rnd);
    }

    public Pair<ITupleReference, ITupleReference> insertIntTuples(IIndexTestContext ctx, int numTuples, boolean filtered, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        MutablePair<ITupleReference, ITupleReference> minMax = null;
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (boolean)filtered, (int[])fieldValues);
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            try {
                ctx.getIndexAccessor().insert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                if (!filtered) continue;
                this.addFilterField(ctx, minMax);
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
        return minMax;
    }

    protected void addFilterField(IIndexTestContext ctx, MutablePair<ITupleReference, ITupleReference> minMax) throws HyracksDataException {
        int filterField = ctx.getFieldCount();
        ArrayTupleReference currTuple = ctx.getTuple();
        ArrayTupleBuilder filterBuilder = new ArrayTupleBuilder(1);
        filterBuilder.addField(currTuple.getFieldData(filterField), currTuple.getFieldStart(filterField), currTuple.getFieldLength(filterField));
        IBinaryComparator comparator = ctx.getComparatorFactories()[0].createBinaryComparator();
        ArrayTupleReference filterOnlyTuple = new ArrayTupleReference();
        filterOnlyTuple.reset(filterBuilder.getFieldEndOffsets(), filterBuilder.getByteArray());
        if (minMax == null) {
            minMax = MutablePair.of((Object)filterOnlyTuple, (Object)filterOnlyTuple);
        } else if (TreeIndexTestUtils.compareFilterTuples((ITupleReference)minMax.getLeft(), (ITupleReference)filterOnlyTuple, comparator) > 0) {
            minMax.setLeft((Object)filterOnlyTuple);
        } else if (TreeIndexTestUtils.compareFilterTuples((ITupleReference)minMax.getRight(), (ITupleReference)filterOnlyTuple, comparator) < 0) {
            minMax.setRight((Object)filterOnlyTuple);
        }
    }

    public void upsertIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (int[])fieldValues);
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            try {
                ctx.getIndexAccessor().upsert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
    }

    public void bulkLoadIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        this.bulkLoadIntTuples(ctx, numTuples, false, rnd);
    }

    public void bulkLoadIntTuples(IIndexTestContext ctx, int numTuples, boolean filter, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        Collection tmpCheckTuples = this.createCheckTuplesCollection();
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        TreeIndexTestUtils.bulkLoadCheckTuples(ctx, tmpCheckTuples, filter);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    public static void bulkLoadCheckTuples(IIndexTestContext ctx, Collection<CheckTuple> checkTuples) throws HyracksDataException {
        TreeIndexTestUtils.bulkLoadCheckTuples(ctx, checkTuples, false);
    }

    public static void bulkLoadCheckTuples(IIndexTestContext ctx, Collection<CheckTuple> checkTuples, boolean filtered) throws HyracksDataException {
        int fieldCount = ctx.getFieldCount();
        int numTuples = checkTuples.size();
        ArrayTupleBuilder tupleBuilder = filtered ? new ArrayTupleBuilder(fieldCount + 1) : new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexBulkLoader bulkLoader = ctx.getIndex().createBulkLoader(0.7f, false, (long)numTuples, false, (IPageWriteCallback)NoOpPageWriteCallback.INSTANCE);
        int c = 1;
        for (CheckTuple checkTuple : checkTuples) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Bulk Loading Tuple " + c + "/" + numTuples);
            }
            TreeIndexTestUtils.createTupleFromCheckTuple(checkTuple, tupleBuilder, tuple, ctx.getFieldSerdes(), filtered);
            bulkLoader.add((ITupleReference)tuple);
            ++c;
        }
        bulkLoader.end();
    }

    public void deleteTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        ArrayTupleBuilder deleteTupleBuilder = this.createDeleteTupleBuilder(ctx);
        ArrayTupleReference deleteTuple = new ArrayTupleReference();
        int numCheckTuples = ctx.getCheckTuples().size();
        CheckTuple[] checkTuples = new CheckTuple[numCheckTuples];
        int idx = 0;
        for (CheckTuple checkTuple : ctx.getCheckTuples()) {
            checkTuples[idx++] = checkTuple;
        }
        for (int i = 0; i < numTuples && numCheckTuples > 0; --numCheckTuples, ++i) {
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Deleting Tuple " + (i + 1) + "/" + numTuples);
            }
            int checkTupleIdx = Math.abs(rnd.nextInt() % numCheckTuples);
            CheckTuple checkTuple = checkTuples[checkTupleIdx];
            TreeIndexTestUtils.createTupleFromCheckTuple(checkTuple, deleteTupleBuilder, deleteTuple, ctx.getFieldSerdes());
            ctx.getIndexAccessor().delete((ITupleReference)deleteTuple);
            ctx.deleteCheckTuple(checkTuple, ctx.getCheckTuples());
            CheckTuple tmp = checkTuples[numCheckTuples - 1];
            checkTuples[numCheckTuples - 1] = checkTuple;
            checkTuples[checkTupleIdx] = tmp;
        }
    }

    public static void checkCursorStats(ILSMIOOperation op) {
        if (op.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.MERGE) {
            MergeOperation mergeOp = (MergeOperation)op;
            IIndexCursorStats stats = mergeOp.getCursorStats();
            Assert.assertTrue((stats.getPageCounter().get() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((stats.getPageCounter().get() >= 0L ? 1 : 0) != 0);
        }
    }
}

