/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestContext;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.TreeIndexTestUtils;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class OrderedIndexTestUtils
extends TreeIndexTestUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void compareActualAndExpected(ITupleReference actual, CheckTuple expected, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        for (int i = 0; i < fieldSerdes.length; ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(actual.getFieldData(i), actual.getFieldStart(i), actual.getFieldLength(i));
            DataInputStream dataIn = new DataInputStream(inStream);
            Object actualObj = fieldSerdes[i].deserialize((DataInput)dataIn);
            if (actualObj.equals(expected.getField(i))) continue;
            Assert.fail((String)("Actual and expected fields do not match on field " + i + ".\nExpected: " + expected.getField(i) + "\nActual  : " + actualObj));
        }
    }

    public static SortedSet<CheckTuple> getPrefixExpectedSubset(TreeSet<CheckTuple> checkTuples, CheckTuple lowKey, CheckTuple highKey) {
        lowKey.setIsHighKey(false);
        highKey.setIsHighKey(true);
        CheckTuple low = checkTuples.ceiling(lowKey);
        CheckTuple high = checkTuples.floor(highKey);
        if (low == null || high == null) {
            return new TreeSet<CheckTuple>();
        }
        if (high.compareTo(low) < 0) {
            return new TreeSet<CheckTuple>();
        }
        return checkTuples.subSet(low, true, high, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRangeSearch(IIndexTestContext ctx, ITupleReference lowKey, ITupleReference highKey, boolean lowKeyInclusive, boolean highKeyInclusive) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Testing Range Search.");
        }
        MultiComparator lowKeyCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])ctx.getComparatorFactories(), (ITupleReference)lowKey);
        MultiComparator highKeyCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])ctx.getComparatorFactories(), (ITupleReference)highKey);
        IIndexCursor searchCursor = ctx.getIndexAccessor().createSearchCursor(false);
        try {
            RangePredicate rangePred = new RangePredicate(lowKey, highKey, lowKeyInclusive, highKeyInclusive, lowKeyCmp, highKeyCmp);
            int actualCount = 0;
            SortedSet<CheckTuple> expectedSubset = null;
            ctx.getIndexAccessor().search(searchCursor, (ISearchPredicate)rangePred);
            try {
                CheckTuple lowKeyCheck = this.createCheckTupleFromTuple(lowKey, ctx.getFieldSerdes(), lowKeyCmp.getKeyFieldCount());
                CheckTuple highKeyCheck = this.createCheckTupleFromTuple(highKey, ctx.getFieldSerdes(), highKeyCmp.getKeyFieldCount());
                expectedSubset = lowKeyCmp.getKeyFieldCount() < ctx.getKeyFieldCount() || highKeyCmp.getKeyFieldCount() < ctx.getKeyFieldCount() ? OrderedIndexTestUtils.getPrefixExpectedSubset((TreeSet)ctx.getCheckTuples(), lowKeyCheck, highKeyCheck) : ((TreeSet)ctx.getCheckTuples()).subSet(lowKeyCheck, lowKeyInclusive, highKeyCheck, highKeyInclusive);
                Iterator checkIter = expectedSubset.iterator();
                while (searchCursor.hasNext()) {
                    if (!checkIter.hasNext()) {
                        Assert.fail((String)("Range search returned more answers than expected.\nExpected: " + expectedSubset.size()));
                    }
                    searchCursor.next();
                    CheckTuple expectedTuple = (CheckTuple)checkIter.next();
                    ITupleReference tuple = searchCursor.getTuple();
                    OrderedIndexTestUtils.compareActualAndExpected(tuple, expectedTuple, ctx.getFieldSerdes());
                    ++actualCount;
                }
            }
            finally {
                searchCursor.close();
            }
            if (actualCount < expectedSubset.size()) {
                Assert.fail((String)("Range search returned fewer answers than expected.\nExpected: " + expectedSubset.size() + "\nActual  : " + actualCount));
            }
        }
        finally {
            searchCursor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPointSearches(IIndexTestContext ictx) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Testing Point Searches On All Expected Keys.");
        }
        OrderedIndexTestContext ctx = (OrderedIndexTestContext)ictx;
        IIndexCursor searchCursor = ctx.getIndexAccessor().createSearchCursor(false);
        try {
            ArrayTupleBuilder lowKeyBuilder = new ArrayTupleBuilder(ctx.getKeyFieldCount());
            ArrayTupleReference lowKey = new ArrayTupleReference();
            ArrayTupleBuilder highKeyBuilder = new ArrayTupleBuilder(ctx.getKeyFieldCount());
            ArrayTupleReference highKey = new ArrayTupleReference();
            RangePredicate rangePred = new RangePredicate((ITupleReference)lowKey, (ITupleReference)highKey, true, true, null, null);
            for (CheckTuple checkTuple : ctx.getCheckTuples()) {
                OrderedIndexTestUtils.createTupleFromCheckTuple(checkTuple, lowKeyBuilder, lowKey, ctx.getFieldSerdes());
                OrderedIndexTestUtils.createTupleFromCheckTuple(checkTuple, highKeyBuilder, highKey, ctx.getFieldSerdes());
                MultiComparator lowKeyCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])ctx.getComparatorFactories(), (ITupleReference)lowKey);
                MultiComparator highKeyCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])ctx.getComparatorFactories(), (ITupleReference)highKey);
                rangePred.setLowKey((ITupleReference)lowKey, true);
                rangePred.setHighKey((ITupleReference)highKey, true);
                rangePred.setLowKeyComparator(lowKeyCmp);
                rangePred.setHighKeyComparator(highKeyCmp);
                ctx.getIndexAccessor().search(searchCursor, (ISearchPredicate)rangePred);
                try {
                    if (searchCursor.hasNext()) {
                        searchCursor.next();
                        ITupleReference tuple = searchCursor.getTuple();
                        OrderedIndexTestUtils.compareActualAndExpected(tuple, checkTuple, ctx.getFieldSerdes());
                    }
                    if (!searchCursor.hasNext()) continue;
                    Assert.fail((String)"Point search returned more than one answer.");
                }
                finally {
                    searchCursor.close();
                }
            }
        }
        finally {
            searchCursor.destroy();
        }
    }

    public void insertSortedIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        Collection tmpCheckTuples = this.createCheckTuplesCollection();
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        OrderedIndexTestUtils.insertCheckTuples(ctx, tmpCheckTuples);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    public void insertSortedStringTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        String[] fieldValues = new String[fieldCount];
        TreeSet<CheckTuple> tmpCheckTuples = new TreeSet<CheckTuple>();
        for (int i = 0; i < numTuples; ++i) {
            int j;
            for (j = 0; j < numKeyFields; ++j) {
                int length = Math.abs(rnd.nextInt()) % 10 + 1;
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(length, rnd);
            }
            for (j = numKeyFields; j < fieldCount; ++j) {
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(5, rnd);
            }
            ctx.insertCheckTuple(this.createStringCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        OrderedIndexTestUtils.insertCheckTuples(ctx, tmpCheckTuples);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    public static void insertCheckTuples(IIndexTestContext ctx, Collection<CheckTuple> checkTuples) throws HyracksDataException {
        OrderedIndexTestUtils.insertCheckTuples(ctx, checkTuples, false);
    }

    public static void insertCheckTuples(IIndexTestContext ctx, Collection<CheckTuple> checkTuples, boolean filtered) throws HyracksDataException {
        int fieldCount = ctx.getFieldCount();
        int numTuples = checkTuples.size();
        ArrayTupleBuilder tupleBuilder = filtered ? new ArrayTupleBuilder(fieldCount + 1) : new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int c = 1;
        for (CheckTuple checkTuple : checkTuples) {
            if (LOGGER.isInfoEnabled() && c % (numTuples / 10) == 0) {
                LOGGER.info("Inserting Tuple " + c + "/" + numTuples);
            }
            OrderedIndexTestUtils.createTupleFromCheckTuple(checkTuple, tupleBuilder, tuple, ctx.getFieldSerdes(), filtered);
            ctx.getIndexAccessor().insert((ITupleReference)tuple);
            ++c;
        }
    }

    public Pair<ITupleReference, ITupleReference> insertStringTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        return this.insertStringTuples(ctx, numTuples, false, rnd);
    }

    public Pair<ITupleReference, ITupleReference> insertStringTuples(IIndexTestContext ctx, int numTuples, boolean filtered, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        String[] fieldValues = new String[fieldCount];
        MutablePair<ITupleReference, ITupleReference> minMax = null;
        for (int i = 0; i < numTuples; ++i) {
            int j;
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            for (j = 0; j < numKeyFields; ++j) {
                int length = Math.abs(rnd.nextInt()) % 10 + 1;
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(length, rnd);
            }
            for (j = numKeyFields; j < fieldCount; ++j) {
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(5, rnd);
            }
            TupleUtils.createTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (ISerializerDeserializer[])ctx.getFieldSerdes(), (boolean)filtered, (Object[])fieldValues);
            try {
                ctx.getIndexAccessor().insert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createStringCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                if (!filtered) continue;
                this.addFilterField(ctx, minMax);
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
        return minMax;
    }

    public void upsertStringTuples(IIndexTestContext ictx, int numTuples, Random rnd) throws Exception {
        OrderedIndexTestContext ctx = (OrderedIndexTestContext)ictx;
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        String[] fieldValues = new String[fieldCount];
        for (int i = 0; i < numTuples; ++i) {
            int j;
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            for (j = 0; j < numKeyFields; ++j) {
                int length = Math.abs(rnd.nextInt()) % 10 + 1;
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(length, rnd);
            }
            for (j = numKeyFields; j < fieldCount; ++j) {
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(5, rnd);
            }
            TupleUtils.createTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (ISerializerDeserializer[])ctx.getFieldSerdes(), (Object[])fieldValues);
            ctx.getIndexAccessor().upsert((ITupleReference)ctx.getTuple());
            ctx.upsertCheckTuple(this.createStringCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
        }
    }

    public void bulkLoadStringTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        this.bulkLoadStringTuples(ctx, numTuples, false, rnd);
    }

    public void bulkLoadStringTuples(IIndexTestContext ctx, int numTuples, boolean filtered, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        String[] fieldValues = new String[fieldCount];
        TreeSet<CheckTuple> tmpCheckTuples = new TreeSet<CheckTuple>();
        for (int i = 0; i < numTuples; ++i) {
            int j;
            for (j = 0; j < numKeyFields; ++j) {
                int length = Math.abs(rnd.nextInt()) % 10 + 1;
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(length, rnd);
            }
            for (j = numKeyFields; j < fieldCount; ++j) {
                fieldValues[j] = OrderedIndexTestUtils.getRandomString(5, rnd);
            }
            ctx.insertCheckTuple(this.createStringCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        OrderedIndexTestUtils.bulkLoadCheckTuples(ctx, tmpCheckTuples, filtered);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    @Override
    public void upsertIntTuples(IIndexTestContext ictx, int numTuples, Random rnd) throws Exception {
        OrderedIndexTestContext ctx = (OrderedIndexTestContext)ictx;
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (int[])fieldValues);
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            ctx.getIndexAccessor().upsert((ITupleReference)ctx.getTuple());
            ctx.upsertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
        }
    }

    public void updateTuples(IIndexTestContext ictx, int numTuples, Random rnd) throws Exception {
        int keyFieldCount;
        OrderedIndexTestContext ctx = (OrderedIndexTestContext)ictx;
        int fieldCount = ctx.getFieldCount();
        if (fieldCount == (keyFieldCount = ctx.getKeyFieldCount())) {
            return;
        }
        ArrayTupleBuilder updateTupleBuilder = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference updateTuple = new ArrayTupleReference();
        int numCheckTuples = ((TreeSet)ctx.getCheckTuples()).size();
        CheckTuple[] checkTuples = new CheckTuple[numCheckTuples];
        int idx = 0;
        for (CheckTuple checkTuple : ctx.getCheckTuples()) {
            checkTuples[idx++] = checkTuple;
        }
        for (int i = 0; i < numTuples && numCheckTuples > 0; --numCheckTuples, ++i) {
            if (LOGGER.isInfoEnabled() && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Updating Tuple " + (i + 1) + "/" + numTuples);
            }
            int checkTupleIdx = Math.abs(rnd.nextInt() % numCheckTuples);
            CheckTuple checkTuple = checkTuples[checkTupleIdx];
            for (int j = keyFieldCount; j < fieldCount; ++j) {
                Comparable newValue = OrderedIndexTestUtils.getRandomUpdateValue(ctx.getFieldSerdes()[j], rnd);
                checkTuple.setField(j, newValue);
            }
            OrderedIndexTestUtils.createTupleFromCheckTuple(checkTuple, updateTupleBuilder, updateTuple, ctx.getFieldSerdes());
            ctx.getIndexAccessor().update((ITupleReference)updateTuple);
            CheckTuple tmp = checkTuples[numCheckTuples - 1];
            checkTuples[numCheckTuples - 1] = checkTuple;
            checkTuples[checkTupleIdx] = tmp;
        }
    }

    public CheckTuple createStringCheckTuple(String[] fieldValues, int numKeyFields) {
        CheckTuple<String> checkTuple = new CheckTuple<String>(fieldValues.length, numKeyFields);
        for (String s : fieldValues) {
            checkTuple.appendField(s);
        }
        return checkTuple;
    }

    private static Comparable getRandomUpdateValue(ISerializerDeserializer serde, Random rnd) {
        if (serde instanceof IntegerSerializerDeserializer) {
            return Integer.valueOf(rnd.nextInt());
        }
        if (serde instanceof UTF8StringSerializerDeserializer) {
            return OrderedIndexTestUtils.getRandomString(10, rnd);
        }
        return null;
    }

    public static String getRandomString(int length, Random rnd) {
        String s = Long.toHexString(Double.doubleToLongBits(rnd.nextDouble()));
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < s.length() && i < length; ++i) {
            strBuilder.append(s.charAt(Math.abs(rnd.nextInt()) % s.length()));
        }
        return strBuilder.toString();
    }

    @Override
    protected CheckTuple createCheckTuple(int numFields, int numKeyFields) {
        return new CheckTuple(numFields, numKeyFields);
    }

    @Override
    protected ISearchPredicate createNullSearchPredicate() {
        return new RangePredicate(null, null, true, true, null, null);
    }

    @Override
    public void checkExpectedResults(IIndexCursor cursor, Collection checkTuples, ISerializerDeserializer[] fieldSerdes, int keyFieldCount, Iterator<CheckTuple> checkIter) throws Exception {
        int actualCount = 0;
        while (cursor.hasNext()) {
            if (!checkIter.hasNext()) {
                Assert.fail((String)("Ordered scan returned more answers than expected.\nExpected: " + checkTuples.size()));
            }
            cursor.next();
            CheckTuple expectedTuple = checkIter.next();
            ITupleReference tuple = cursor.getTuple();
            OrderedIndexTestUtils.compareActualAndExpected(tuple, expectedTuple, fieldSerdes);
            ++actualCount;
        }
        if (actualCount < checkTuples.size()) {
            Assert.fail((String)("Ordered scan returned fewer answers than expected.\nExpected: " + checkTuples.size() + "\nActual  : " + actualCount));
        }
    }

    @Override
    protected CheckTuple createIntCheckTuple(int[] fieldValues, int numKeyFields) {
        CheckTuple<Integer> checkTuple = new CheckTuple<Integer>(fieldValues.length, numKeyFields);
        for (int v : fieldValues) {
            checkTuple.appendField(v);
        }
        return checkTuple;
    }

    @Override
    protected void setIntKeyFields(int[] fieldValues, int numKeyFields, int maxValue, Random rnd) {
        for (int j = 0; j < numKeyFields; ++j) {
            fieldValues[j] = rnd.nextInt() % maxValue;
        }
    }

    @Override
    protected void setIntPayloadFields(int[] fieldValues, int numKeyFields, int numFields) {
        for (int j = numKeyFields; j < numFields; ++j) {
            fieldValues[j] = j;
        }
    }

    @Override
    protected Collection createCheckTuplesCollection() {
        return new TreeSet();
    }

    @Override
    protected ArrayTupleBuilder createDeleteTupleBuilder(IIndexTestContext ctx) {
        return new ArrayTupleBuilder(ctx.getKeyFieldCount());
    }

    @Override
    protected boolean checkDiskOrderScanResult(ITupleReference tuple, CheckTuple checkTuple, IIndexTestContext ctx) throws HyracksDataException {
        TreeSet checkTuples = (TreeSet)ctx.getCheckTuples();
        CheckTuple matchingCheckTuple = checkTuples.floor(checkTuple);
        if (matchingCheckTuple == null) {
            return false;
        }
        OrderedIndexTestUtils.compareActualAndExpected(tuple, matchingCheckTuple, ctx.getFieldSerdes());
        return true;
    }
}

