/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.util.Random;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestContext;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public abstract class OrderedIndexTestDriver {
    protected final Logger LOGGER = LogManager.getLogger();
    protected static final int numTuplesToInsert = 100;
    protected final BTreeLeafFrameType[] leafFrameTypesToTest;

    protected abstract OrderedIndexTestContext createTestContext(ISerializerDeserializer[] var1, int var2, BTreeLeafFrameType var3, boolean var4) throws Exception;

    protected abstract Random getRandom();

    protected abstract void runTest(ISerializerDeserializer[] var1, int var2, BTreeLeafFrameType var3, ITupleReference var4, ITupleReference var5, ITupleReference var6, ITupleReference var7) throws Exception;

    protected abstract String getTestOpName();

    public OrderedIndexTestDriver(BTreeLeafFrameType[] leafFrameTypesToTest) {
        this.leafFrameTypesToTest = leafFrameTypesToTest;
    }

    @Test
    public void oneIntKeyAndValue() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("BTree " + this.getTestOpName() + " Test With One Int Key And Value.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        ITupleReference lowKey = TupleUtils.createIntegerTuple((int[])new int[]{-1000});
        ITupleReference highKey = TupleUtils.createIntegerTuple((int[])new int[]{1000});
        for (BTreeLeafFrameType leafFrameType : this.leafFrameTypesToTest) {
            this.runTest(fieldSerdes, 1, leafFrameType, lowKey, highKey, null, null);
        }
    }

    @Test
    public void twoIntKeys() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("BTree " + this.getTestOpName() + " Test With Two Int Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        ITupleReference lowKey = TupleUtils.createIntegerTuple((int[])new int[]{50, 0});
        ITupleReference highKey = TupleUtils.createIntegerTuple((int[])new int[]{50, 500});
        ITupleReference prefixLowKey = TupleUtils.createIntegerTuple((int[])new int[]{50});
        ITupleReference prefixHighKey = TupleUtils.createIntegerTuple((int[])new int[]{50});
        for (BTreeLeafFrameType leafFrameType : this.leafFrameTypesToTest) {
            this.runTest(fieldSerdes, 2, leafFrameType, lowKey, highKey, prefixLowKey, prefixHighKey);
        }
    }

    @Test
    public void twoIntKeysAndValues() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("BTree " + this.getTestOpName() + " Test With Two Int Keys And Values.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        ITupleReference lowKey = TupleUtils.createIntegerTuple((int[])new int[]{-100, -100});
        ITupleReference highKey = TupleUtils.createIntegerTuple((int[])new int[]{100, 100});
        ITupleReference prefixLowKey = TupleUtils.createIntegerTuple((int[])new int[]{50});
        ITupleReference prefixHighKey = TupleUtils.createIntegerTuple((int[])new int[]{50});
        for (BTreeLeafFrameType leafFrameType : this.leafFrameTypesToTest) {
            this.runTest(fieldSerdes, 2, leafFrameType, lowKey, highKey, prefixLowKey, prefixHighKey);
        }
    }

    @Test
    public void oneStringKeyAndValue() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("BTree " + this.getTestOpName() + " Test With One String Key And Value.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        ITupleReference lowKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf"});
        ITupleReference highKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7"});
        for (BTreeLeafFrameType leafFrameType : this.leafFrameTypesToTest) {
            this.runTest(fieldSerdes, 1, leafFrameType, lowKey, highKey, null, null);
        }
    }

    @Test
    public void twoStringKeys() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("BTree " + this.getTestOpName() + " Test With Two String Keys.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        ITupleReference lowKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf", "ddd"});
        ITupleReference highKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7", "eee"});
        ITupleReference prefixLowKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf"});
        ITupleReference prefixHighKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7"});
        for (BTreeLeafFrameType leafFrameType : this.leafFrameTypesToTest) {
            this.runTest(fieldSerdes, 2, leafFrameType, lowKey, highKey, prefixLowKey, prefixHighKey);
        }
    }

    @Test
    public void twoStringKeysAndValues() throws Exception {
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("BTree " + this.getTestOpName() + " Test With Two String Keys And Values.");
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        ITupleReference lowKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf", "ddd"});
        ITupleReference highKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7", "eee"});
        ITupleReference prefixLowKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf"});
        ITupleReference prefixHighKey = TupleUtils.createTuple((ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7"});
        for (BTreeLeafFrameType leafFrameType : this.leafFrameTypesToTest) {
            this.runTest(fieldSerdes, 2, leafFrameType, lowKey, highKey, prefixLowKey, prefixHighKey);
        }
    }
}

