/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.util.Random;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.IntegerBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.TestOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.NoOpPageWriteCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public abstract class OrderedIndexExamplesTest {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Random rnd = new Random(50L);

    protected abstract ITreeIndex createTreeIndex(ITypeTraits[] var1, IBinaryComparatorFactory[] var2, int[] var3, ITypeTraits[] var4, IBinaryComparatorFactory[] var5, int[] var6, int[] var7) throws HyracksDataException;

    @Test
    public void fixedLengthKeyValueExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Fixed-Length Key,Value Example.");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = IntegerBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        int numInserts = 10000;
        for (int i = 0; i < numInserts; ++i) {
            int f0 = this.rnd.nextInt() % numInserts;
            int f1 = 5;
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{f0, f1});
            if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                LOGGER.info("Inserting " + i + " : " + f0 + " " + f1);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(keyFieldCount);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (int[])new int[]{-1000});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(keyFieldCount);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (int[])new int[]{1000});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void pageSplitTestExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BTree page split test.");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = UTF8StringBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        String key = "111";
        String data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "222";
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "333";
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "444";
        data = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "555";
        data = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "666";
        data = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void twoFixedLengthKeysOneFixedLengthValueExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Composite Key Test");
        }
        int fieldCount = 3;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int keyFieldCount = 2;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = IntegerBinaryComparatorFactory.INSTANCE;
        cmpFactories[1] = IntegerBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        bloomFilterKeyFields[1] = 1;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        int numInserts = 10000;
        for (int i = 0; i < 10000; ++i) {
            int f0 = this.rnd.nextInt() % 2000;
            int f1 = this.rnd.nextInt() % 1000;
            int f2 = 5;
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{f0, f1, f2});
            if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                LOGGER.info("Inserting " + i + " : " + f0 + " " + f1 + " " + f2);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (int[])new int[]{-3});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (int[])new int[]{3});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void varLenKeyValueExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Variable-Length Key,Value Example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = UTF8StringBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        int maxLength = 10;
        int numInserts = 10000;
        for (int i = 0; i < 10000; ++i) {
            String f0 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0, f1});
            if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                LOGGER.info("Inserting[" + i + "] " + f0 + " " + f1);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf"});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7"});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void deleteExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Deletion Example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = UTF8StringBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        int runs = 3;
        for (int run = 0; run < runs; ++run) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Deletion example run: " + (run + 1) + "/" + runs);
                LOGGER.info("Inserting into tree...");
            }
            int maxLength = 10;
            int ins = 10000;
            String[] f0s = new String[ins];
            String[] f1s = new String[ins];
            int insDone = 0;
            int[] insDoneCmp = new int[ins];
            for (int i = 0; i < ins; ++i) {
                block12: {
                    String f0 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
                    String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
                    TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0, f1});
                    f0s[i] = f0;
                    f1s[i] = f1;
                    if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                        LOGGER.info("Inserting " + i);
                    }
                    try {
                        indexAccessor.insert((ITupleReference)tuple);
                    }
                    catch (HyracksDataException e) {
                        if (e.getErrorCode() == 33) break block12;
                        throw e;
                    }
                }
                insDoneCmp[i] = ++insDone;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Deleting from tree...");
            }
            int delDone = 0;
            for (int i = 0; i < ins; ++i) {
                block13: {
                    TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0s[i], f1s[i]});
                    if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                        LOGGER.info("Deleting " + i);
                    }
                    try {
                        indexAccessor.delete((ITupleReference)tuple);
                        ++delDone;
                    }
                    catch (HyracksDataException e) {
                        if (e.getErrorCode() == 37) break block13;
                        throw e;
                    }
                }
                if (insDoneCmp[i] == delDone) continue;
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("INCONSISTENT STATE, ERROR IN DELETION EXAMPLE.");
                LOGGER.info("INSDONECMP: " + insDoneCmp[i] + " " + delDone);
                break;
            }
            if (insDone == delDone) continue;
            if (!LOGGER.isInfoEnabled()) break;
            LOGGER.info("ERROR! INSDONE: " + insDone + " DELDONE: " + delDone);
            break;
        }
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void updateExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Update example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = UTF8StringBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Inserting into tree...");
        }
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int maxLength = 10;
        int ins = 10000;
        String[] keys = new String[10000];
        for (int i = 0; i < ins; ++i) {
            String f0 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0, f1});
            keys[i] = f0;
            if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                LOGGER.info("Inserting " + i);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) continue;
                throw e;
            }
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        int runs = 3;
        for (int run = 0; run < runs; ++run) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Update test run: " + (run + 1) + "/" + runs);
                LOGGER.info("Updating BTree");
            }
            for (int i = 0; i < ins; ++i) {
                String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
                TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{keys[i], f1});
                if (LOGGER.isInfoEnabled() && i % 1000 == 0) {
                    LOGGER.info("Updating " + i);
                }
                indexAccessor.update((ITupleReference)tuple);
            }
            this.orderedScan(indexAccessor, fieldSerdes);
        }
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void bulkLoadExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Bulk load example");
        }
        int fieldCount = 3;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int keyFieldCount = 2;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = IntegerBinaryComparatorFactory.INSTANCE;
        cmpFactories[1] = IntegerBinaryComparatorFactory.INSTANCE;
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        bloomFilterKeyFields[1] = 1;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        int ins = 100000;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Bulk loading " + ins + " tuples");
        }
        long start = System.currentTimeMillis();
        IIndexBulkLoader bulkLoader = treeIndex.createBulkLoader(0.7f, false, (long)ins, true, (IPageWriteCallback)NoOpPageWriteCallback.INSTANCE);
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int i = 0;
        while (i < ins) {
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{i, i++, 5});
            bulkLoader.add((ITupleReference)tuple);
        }
        bulkLoader.end();
        long end = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(ins + " tuples loaded in " + (end - start) + "ms");
        }
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IIndexAccessParameters)actx);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (int[])new int[]{44444});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (int[])new int[]{44500});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void bulkOrderVerificationExample() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Bulk load order verification example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = IntegerBinaryComparatorFactory.INSTANCE;
        Random rnd = new Random();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        int ins = 1000;
        for (int i = 1; i < ins; ++i) {
            ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
            treeIndex.create();
            treeIndex.activate();
            IIndexBulkLoader bulkLoader = treeIndex.createBulkLoader(0.7f, true, (long)ins, true, (IPageWriteCallback)NoOpPageWriteCallback.INSTANCE);
            for (int j = 0; j < ins; ++j) {
                int swapElementCase;
                if (j > i) {
                    Assert.fail((String)("Bulk load failure test unexpectedly succeeded past tuple: " + j));
                }
                int key = j;
                if (j == i && (swapElementCase = Math.abs(rnd.nextInt()) % 2) != 0) {
                    key = (int)((double)key - (Math.abs(Math.random() % (double)(ins - 1)) + 1.0));
                }
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{--key, 5});
                try {
                    bulkLoader.add((ITupleReference)tuple);
                    continue;
                }
                catch (HyracksDataException e) {
                    if (e.getErrorCode() == 46 || e.getErrorCode() == 33 || e.getErrorCode() == 48) {
                        if (j == i) break;
                        Assert.fail((String)("Unexpected exception: " + e.getMessage()));
                        break;
                    }
                    throw e;
                }
            }
            treeIndex.deactivate();
            treeIndex.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void orderedScan(IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Ordered Scan:");
        }
        IIndexCursor scanCursor = indexAccessor.createSearchCursor(false);
        try {
            RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search(scanCursor, (ISearchPredicate)nullPred);
            try {
                while (scanCursor.hasNext()) {
                    scanCursor.next();
                    ITupleReference frameTuple = scanCursor.getTuple();
                    String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info(rec);
                }
            }
            finally {
                scanCursor.close();
            }
        }
        finally {
            scanCursor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void diskOrderScan(IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes) throws Exception {
        block12: {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Disk-Order Scan:");
                }
                ITreeIndexAccessor treeIndexAccessor = (ITreeIndexAccessor)indexAccessor;
                TreeIndexDiskOrderScanCursor diskOrderCursor = (TreeIndexDiskOrderScanCursor)treeIndexAccessor.createDiskOrderScanCursor();
                try {
                    treeIndexAccessor.diskOrderScan((ITreeIndexCursor)diskOrderCursor);
                    try {
                        while (diskOrderCursor.hasNext()) {
                            diskOrderCursor.next();
                            ITupleReference frameTuple = diskOrderCursor.getTuple();
                            String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                            LOGGER.info(rec);
                        }
                    }
                    finally {
                        diskOrderCursor.close();
                    }
                }
                finally {
                    diskOrderCursor.destroy();
                }
            }
            catch (UnsupportedOperationException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Ignoring disk-order scan since it's not supported.");
                }
            }
            catch (ClassCastException e) {
                if (!LOGGER.isInfoEnabled()) break block12;
                LOGGER.info("Ignoring disk-order scan since it's not supported.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rangeSearch(IBinaryComparatorFactory[] cmpFactories, IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes, ITupleReference lowKey, ITupleReference highKey, ITupleReference minFilterTuple, ITupleReference maxFilterTuple) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            String lowKeyString = TupleUtils.printTuple((ITupleReference)lowKey, (ISerializerDeserializer[])fieldSerdes);
            String highKeyString = TupleUtils.printTuple((ITupleReference)highKey, (ISerializerDeserializer[])fieldSerdes);
            LOGGER.info("Range-Search in: [ " + lowKeyString + ", " + highKeyString + "]");
        }
        IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
        try {
            MultiComparator lowKeySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])cmpFactories, (ITupleReference)lowKey);
            MultiComparator highKeySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])cmpFactories, (ITupleReference)highKey);
            RangePredicate rangePred = minFilterTuple != null && maxFilterTuple != null ? new RangePredicate(lowKey, highKey, true, true, lowKeySearchCmp, highKeySearchCmp, minFilterTuple, maxFilterTuple) : new RangePredicate(lowKey, highKey, true, true, lowKeySearchCmp, highKeySearchCmp);
            indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    ITupleReference frameTuple = rangeCursor.getTuple();
                    String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info(rec);
                }
            }
            finally {
                rangeCursor.close();
            }
        }
        finally {
            rangeCursor.destroy();
        }
    }

    public static String randomString(int length, Random random) {
        String s = Long.toHexString(Double.doubleToLongBits(random.nextDouble()));
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < s.length() && i < length; ++i) {
            strBuilder.append(s.charAt(Math.abs(random.nextInt()) % s.length()));
        }
        return strBuilder.toString();
    }
}

