/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.datagen;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.TupleGenerator;

public class TupleBatch {
    private final int size;
    private final TupleGenerator[] tupleGens;
    public final AtomicBoolean inUse = new AtomicBoolean(false);

    public TupleBatch(int size, IFieldValueGenerator[] fieldGens, ISerializerDeserializer[] fieldSerdes, int payloadSize) {
        this.size = size;
        this.tupleGens = new TupleGenerator[size];
        for (int i = 0; i < size; ++i) {
            this.tupleGens[i] = new TupleGenerator(fieldGens, fieldSerdes, payloadSize);
        }
    }

    public void generate() throws IOException {
        for (TupleGenerator tupleGen : this.tupleGens) {
            tupleGen.next();
        }
    }

    public int size() {
        return this.size;
    }

    public ITupleReference get(int ix) {
        return this.tupleGens[ix].get();
    }
}

