/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.datagen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import org.apache.hyracks.storage.am.common.datagen.ProbabilityHelper;
import org.apache.hyracks.util.MathUtil;

public class DocumentStringFieldValueGenerator
implements IFieldValueGenerator<String> {
    private static final String FIRST_NAMES_FILE = "dist.all.first.cleaned";
    private static final String LAST_NAMES_FILE = "dist.all.last.cleaned";
    private final int docMinWords;
    private final int docMaxWords;
    private final int maxDictionarySize;
    private final Random rnd;
    private int[] cumulIntRanges;
    private List<String> tokenDict = new ArrayList<String>();

    public DocumentStringFieldValueGenerator(int docMinWords, int docMaxWords, int maxDictionarySize, Random rnd) throws IOException {
        this.docMinWords = docMinWords;
        this.docMaxWords = docMaxWords;
        this.maxDictionarySize = maxDictionarySize;
        this.rnd = rnd;
        this.initDictionary();
        double[] zipfProbDist = ProbabilityHelper.getZipfProbDist(this.tokenDict.size(), 1);
        this.cumulIntRanges = ProbabilityHelper.getCumulIntRanges(zipfProbDist);
    }

    private void initDictionary() throws IOException {
        String line;
        int count = 0;
        InputStream firstNamesIn = this.getClass().getClassLoader().getResourceAsStream(FIRST_NAMES_FILE);
        try (BufferedReader firstNamesReader = new BufferedReader(new InputStreamReader(firstNamesIn));){
            while (count < this.maxDictionarySize && (line = firstNamesReader.readLine()) != null) {
                if (line.startsWith(";")) continue;
                this.tokenDict.add(line.trim());
                ++count;
            }
        }
        InputStream lastNamesIn = this.getClass().getClassLoader().getResourceAsStream(LAST_NAMES_FILE);
        try (BufferedReader lastNamesReader = new BufferedReader(new InputStreamReader(lastNamesIn));){
            while (count < this.maxDictionarySize && (line = lastNamesReader.readLine()) != null) {
                if (line.startsWith(";")) continue;
                this.tokenDict.add(line.trim());
                ++count;
            }
        }
    }

    @Override
    public String next() {
        StringBuilder strBuilder = new StringBuilder();
        int numWords = MathUtil.stripSignBit((int)this.rnd.nextInt()) % (this.docMaxWords - this.docMinWords + 1) + this.docMinWords;
        for (int i = 0; i < numWords; ++i) {
            int ix = ProbabilityHelper.choose(this.cumulIntRanges, this.rnd.nextInt());
            strBuilder.append(this.tokenDict.get(ix));
            if (i == numWords - 1) continue;
            strBuilder.append(" ");
        }
        return strBuilder.toString();
    }

    public List<String> getTokenDictionary() {
        return this.tokenDict;
    }

    @Override
    public void reset() {
    }
}

