/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import java.util.Collection;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.TestOperationCallback;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public abstract class IndexTestContext<T extends CheckTuple>
implements IIndexTestContext<T> {
    protected final ISerializerDeserializer[] fieldSerdes;
    protected final IIndex index;
    protected final ArrayTupleBuilder tupleBuilder;
    protected final ArrayTupleReference tuple = new ArrayTupleReference();
    protected IIndexAccessor indexAccessor;

    public IndexTestContext(ISerializerDeserializer[] fieldSerdes, IIndex index, boolean filtered) throws HyracksDataException {
        this.fieldSerdes = fieldSerdes;
        this.index = index;
        IndexAccessParameters actx = new IndexAccessParameters((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        this.indexAccessor = index.createAccessor((IIndexAccessParameters)actx);
        this.tupleBuilder = filtered ? new ArrayTupleBuilder(fieldSerdes.length + 1) : new ArrayTupleBuilder(fieldSerdes.length);
    }

    @Override
    public int getFieldCount() {
        return this.fieldSerdes.length;
    }

    @Override
    public IIndexAccessor getIndexAccessor() {
        return this.indexAccessor;
    }

    @Override
    public ArrayTupleReference getTuple() {
        return this.tuple;
    }

    @Override
    public ArrayTupleBuilder getTupleBuilder() {
        return this.tupleBuilder;
    }

    @Override
    public ISerializerDeserializer[] getFieldSerdes() {
        return this.fieldSerdes;
    }

    @Override
    public IIndex getIndex() {
        return this.index;
    }

    @Override
    public void insertCheckTuple(T checkTuple, Collection<T> checkTuples) {
        checkTuples.add(checkTuple);
    }

    @Override
    public void deleteCheckTuple(T checkTuple, Collection<T> checkTuples) {
        checkTuples.remove(checkTuple);
    }
}

