/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.AbstractIndexTestWorker;
import org.apache.hyracks.storage.am.common.IIndexTestWorkerFactory;
import org.apache.hyracks.storage.am.common.TestOperationSelector;
import org.apache.hyracks.storage.am.common.datagen.DataGenThread;
import org.apache.hyracks.storage.common.IIndex;

public class IndexMultiThreadTestDriver {
    protected static final int RANDOM_SEED = 50;
    protected static final int PAYLOAD_SIZE = 0;
    protected final TestOperationSelector opSelector;
    protected final ISerializerDeserializer[] fieldSerdes;
    protected final IIndex index;
    protected final IIndexTestWorkerFactory workerFactory;

    public IndexMultiThreadTestDriver(IIndex index, IIndexTestWorkerFactory workerFactory, ISerializerDeserializer[] fieldSerdes, TestOperationSelector.TestOperation[] ops, double[] opProbs) {
        this.index = index;
        this.workerFactory = workerFactory;
        this.fieldSerdes = fieldSerdes;
        this.opSelector = new TestOperationSelector(ops, opProbs);
    }

    public void init() throws HyracksDataException {
        this.index.create();
        this.index.activate();
    }

    public long[] run(int numThreads, int numRepeats, int numOps, int batchSize) throws InterruptedException, HyracksDataException {
        int numBatches;
        int n = numBatches = batchSize < 1 ? numOps : numOps / batchSize;
        if (numBatches < numThreads) {
            numThreads = numBatches;
        }
        int threadNumBatches = numBatches / numThreads;
        long[] times = new long[numRepeats];
        for (int i = 0; i < numRepeats; ++i) {
            int j;
            DataGenThread dataGen = this.createDatagenThread(numThreads, numBatches, batchSize);
            dataGen.start();
            while (dataGen.tupleBatchQueue.remainingCapacity() != 0 && dataGen.tupleBatchQueue.size() != numBatches) {
                Thread.sleep(10L);
            }
            AbstractIndexTestWorker[] workers = new AbstractIndexTestWorker[numThreads];
            long start = System.currentTimeMillis();
            for (j = 0; j < numThreads; ++j) {
                workers[j] = this.workerFactory.create(dataGen, this.opSelector, this.index, threadNumBatches);
                workers[j].start();
            }
            for (j = 0; j < numThreads; ++j) {
                workers[j].join();
            }
            long end = System.currentTimeMillis();
            times[i] = end - start;
        }
        return times;
    }

    public void deinit() throws HyracksDataException {
        this.index.deactivate();
        this.index.destroy();
    }

    public DataGenThread createDatagenThread(int numThreads, int numBatches, int batchSize) {
        return new DataGenThread(numThreads, numBatches, batchSize, this.fieldSerdes, 0, 50, 2 * numThreads, false);
    }
}

