/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.control.common.job.profiling.StatsCollector;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.test.support.CounterContext;
import org.apache.hyracks.test.support.TestJobletContext;

public class TestTaskContext
implements IHyracksTaskContext {
    private final TestJobletContext jobletContext;
    private final TaskAttemptId taskId;
    private WorkspaceFileFactory fileFactory;
    private Map<Object, IStateObject> stateObjectMap = new HashMap<Object, IStateObject>();
    private Object sharedObject;
    private final IStatsCollector statsCollector = new StatsCollector();

    public TestTaskContext(TestJobletContext jobletContext, TaskAttemptId taskId) {
        this.jobletContext = jobletContext;
        this.taskId = taskId;
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, this.getIoManager());
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.jobletContext.allocateFrame();
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        return this.jobletContext.allocateFrame(bytes);
    }

    public ByteBuffer reallocateFrame(ByteBuffer tobeDeallocate, int newSizeInBytes, boolean copyOldData) throws HyracksDataException {
        return this.jobletContext.reallocateFrame(tobeDeallocate, newSizeInBytes, copyOldData);
    }

    public void deallocateFrames(int bytes) {
        this.jobletContext.deallocateFrames(bytes);
    }

    public int getInitialFrameSize() {
        return this.jobletContext.getFrameSize();
    }

    public IIOManager getIoManager() {
        return this.jobletContext.getIOManager();
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public IHyracksJobletContext getJobletContext() {
        return this.jobletContext;
    }

    public ICounterContext getCounterContext() {
        return new CounterContext(this.jobletContext.getJobId() + "." + this.taskId);
    }

    public void registerDeallocatable(final IDeallocatable deallocatable) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                deallocatable.deallocate();
            }
        });
    }

    public TaskAttemptId getTaskAttemptId() {
        return this.taskId;
    }

    public synchronized void setStateObject(IStateObject taskState) {
        this.stateObjectMap.put(taskState.getId(), taskState);
    }

    public synchronized IStateObject getStateObject(Object id) {
        return this.stateObjectMap.get(id);
    }

    public IResultPartitionManager getResultPartitionManager() {
        return null;
    }

    public void sendApplicationMessageToCC(byte[] message, DeploymentId deploymentId) {
    }

    public void sendApplicationMessageToCC(Serializable message, DeploymentId deploymentId) {
    }

    public ExecutorService getExecutorService() {
        return null;
    }

    public void setSharedObject(Object object) {
        this.sharedObject = object;
    }

    public Object getSharedObject() {
        return this.sharedObject;
    }

    public byte[] getJobParameter(byte[] name, int start, int length) {
        return new byte[0];
    }

    public Set<JobFlag> getJobFlags() {
        return EnumSet.noneOf(JobFlag.class);
    }

    public IStatsCollector getStatsCollector() {
        return this.statsCollector;
    }
}

