/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.control.nc.io.DefaultDeviceResolver;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexLifecycleManager;
import org.apache.hyracks.storage.am.common.freepage.AppendOnlyLinkedMetadataPageManagerFactory;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.ClockPageReplacementStrategy;
import org.apache.hyracks.storage.common.buffercache.DelayPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.HeapBufferAllocator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.file.FileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.ResourceIdFactory;
import org.apache.hyracks.storage.common.file.ResourceIdFactoryProvider;
import org.apache.hyracks.storage.common.file.TransientLocalResourceRepositoryFactory;

public class TestStorageManagerComponentHolder {
    private static IBufferCache bufferCache;
    private static IFileMapProvider fileMapProvider;
    private static IOManager ioManager;
    private static ILocalResourceRepository localResourceRepository;
    private static IResourceLifecycleManager<IIndex> lcManager;
    private static ResourceIdFactory resourceIdFactory;
    private static IMetadataPageManagerFactory metadataPageManagerFactory;
    private static int pageSize;
    private static int numPages;
    private static int maxOpenFiles;
    private static final ThreadFactory threadFactory;

    public static void init(int pageSize, int numPages, int maxOpenFiles) {
        TestStorageManagerComponentHolder.pageSize = pageSize;
        TestStorageManagerComponentHolder.numPages = numPages;
        TestStorageManagerComponentHolder.maxOpenFiles = maxOpenFiles;
        bufferCache = null;
        fileMapProvider = null;
        localResourceRepository = null;
        lcManager = null;
    }

    public static synchronized IResourceLifecycleManager<IIndex> getIndexLifecycleManager() {
        if (lcManager == null) {
            lcManager = new IndexLifecycleManager();
        }
        return lcManager;
    }

    public static synchronized IBufferCache getBufferCache(INCServiceContext ctx) {
        if (bufferCache == null) {
            IIOManager ioManager = ctx.getIoManager();
            return TestStorageManagerComponentHolder.getBufferCache(ioManager);
        }
        return bufferCache;
    }

    private static synchronized IFileMapProvider getFileMapProvider() {
        if (fileMapProvider == null) {
            fileMapProvider = new FileMapManager();
        }
        return fileMapProvider;
    }

    public static synchronized IOManager getIOManager() throws HyracksDataException {
        if (ioManager == null) {
            ArrayList<IODeviceHandle> devices = new ArrayList<IODeviceHandle>();
            devices.add(new IODeviceHandle(new File(System.getProperty("user.dir") + File.separator + "target"), "iodev_test_wa"));
            ioManager = new IOManager(devices, (IFileDeviceResolver)new DefaultDeviceResolver());
        }
        return ioManager;
    }

    public static synchronized ILocalResourceRepository getLocalResourceRepository() {
        if (localResourceRepository == null) {
            try {
                TransientLocalResourceRepositoryFactory localResourceRepositoryFactory = new TransientLocalResourceRepositoryFactory();
                localResourceRepository = localResourceRepositoryFactory.createRepository();
            }
            catch (HyracksException e) {
                throw new IllegalArgumentException();
            }
        }
        return localResourceRepository;
    }

    public static IMetadataPageManagerFactory getMetadataPageManagerFactory() {
        return metadataPageManagerFactory;
    }

    public static synchronized ResourceIdFactory getResourceIdFactory() {
        if (resourceIdFactory == null) {
            try {
                ResourceIdFactoryProvider resourceIdFactoryFactory = new ResourceIdFactoryProvider(TestStorageManagerComponentHolder.getLocalResourceRepository());
                resourceIdFactory = resourceIdFactoryFactory.createResourceIdFactory();
            }
            catch (HyracksException e) {
                throw new IllegalArgumentException();
            }
        }
        return resourceIdFactory;
    }

    public static IBufferCache getBufferCache(IIOManager ioManager) {
        if (bufferCache != null) {
            return bufferCache;
        }
        HeapBufferAllocator allocator = new HeapBufferAllocator();
        ClockPageReplacementStrategy prs = new ClockPageReplacementStrategy((ICacheMemoryAllocator)allocator, pageSize, numPages);
        IFileMapProvider fileMapProvider = TestStorageManagerComponentHolder.getFileMapProvider();
        bufferCache = new BufferCache(ioManager, (IPageReplacementStrategy)prs, (IPageCleanerPolicy)new DelayPageCleanerPolicy(1000L), (IFileMapManager)fileMapProvider, maxOpenFiles, threadFactory);
        return bufferCache;
    }

    static {
        metadataPageManagerFactory = AppendOnlyLinkedMetadataPageManagerFactory.INSTANCE;
        threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        };
    }
}

