/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.control.common.job.profiling.counters.Counter;

public class CounterContext
implements ICounterContext {
    private final String contextName;
    private final Map<String, Counter> counterMap;

    public CounterContext(String name) {
        this.contextName = name;
        this.counterMap = new HashMap<String, Counter>();
    }

    public synchronized ICounter getCounter(String counterName, boolean create) {
        Counter counter = this.counterMap.get(counterName);
        if (counter == null && create) {
            counter = new Counter(this.contextName + "." + counterName);
            this.counterMap.put(counterName, counter);
        }
        return counter;
    }

    public synchronized void dump(Map<String, Long> dumpMap) {
        for (Counter c : this.counterMap.values()) {
            dumpMap.put(c.getName(), c.get());
        }
    }
}

