/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestContext;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestDriver;
import org.apache.hyracks.storage.am.rtree.RTreeTestUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;

public abstract class AbstractRTreeDeleteTest
extends AbstractRTreeTestDriver {
    private final RTreeTestUtils rTreeTestUtils = new RTreeTestUtils();
    private static final int numInsertRounds = 2;
    private static final int numDeleteRounds = 2;

    public AbstractRTreeDeleteTest(boolean testRstarPolicy) {
        super(testRstarPolicy);
    }

    @Override
    protected void runTest(ISerializerDeserializer[] fieldSerdes, IPrimitiveValueProviderFactory[] valueProviderFactories, int numKeys, ITupleReference key, RTreePolicyType rtreePolicyType) throws Exception {
        AbstractRTreeTestContext ctx = this.createTestContext(fieldSerdes, valueProviderFactories, numKeys, rtreePolicyType);
        ctx.getIndex().create();
        ctx.getIndex().activate();
        for (int i = 0; i < 2; ++i) {
            if (fieldSerdes[0] instanceof IntegerSerializerDeserializer) {
                this.rTreeTestUtils.insertIntTuples(ctx, 100, this.getRandom());
            } else if (fieldSerdes[0] instanceof DoubleSerializerDeserializer) {
                this.rTreeTestUtils.insertDoubleTuples(ctx, 100, this.getRandom());
            }
            int numTuplesPerDeleteRound = (int)Math.ceil((float)ctx.getCheckTuples().size() / 2.0f);
            for (int j = 0; j < 2; ++j) {
                this.rTreeTestUtils.deleteTuples(ctx, numTuplesPerDeleteRound, this.getRandom());
                this.rTreeTestUtils.checkScan(ctx);
                this.rTreeTestUtils.checkDiskOrderScan(ctx);
                this.rTreeTestUtils.checkRangeSearch(ctx, key);
                this.afterDeleteRound(ctx);
            }
            this.afterInsertRound(ctx);
        }
        ctx.getIndex().deactivate();
        ctx.getIndex().destroy();
    }

    protected void afterInsertRound(AbstractRTreeTestContext ctx) throws HyracksDataException {
    }

    protected void afterDeleteRound(AbstractRTreeTestContext ctx) throws HyracksDataException {
    }

    @Override
    protected String getTestOpName() {
        return "Delete";
    }
}

