/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.datagen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import org.apache.hyracks.util.MathUtil;

public class PersonNameFieldValueGenerator
implements IFieldValueGenerator<String> {
    private static final String FIRST_NAMES_FILE = "dist.all.first.cleaned";
    private static final String LAST_NAMES_FILE = "dist.all.last.cleaned";
    private static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final Random rnd;
    private final double middleInitialProb;
    private List<String> firstNames = new ArrayList<String>();
    private List<String> lastNames = new ArrayList<String>();

    public PersonNameFieldValueGenerator(Random rnd, double middleInitialProb) throws IOException {
        this.rnd = rnd;
        this.middleInitialProb = middleInitialProb;
        this.initNames();
    }

    private void initNames() throws IOException {
        String line;
        InputStream firstNamesIn = this.getClass().getClassLoader().getResourceAsStream(FIRST_NAMES_FILE);
        try (BufferedReader firstNamesReader = new BufferedReader(new InputStreamReader(firstNamesIn));){
            while ((line = firstNamesReader.readLine()) != null) {
                if (line.startsWith(";")) continue;
                this.firstNames.add(line.trim());
            }
        }
        InputStream lastNamesIn = this.getClass().getClassLoader().getResourceAsStream(LAST_NAMES_FILE);
        try (BufferedReader lastNamesReader = new BufferedReader(new InputStreamReader(lastNamesIn));){
            while ((line = lastNamesReader.readLine()) != null) {
                if (line.startsWith(";")) continue;
                this.lastNames.add(line.trim());
            }
        }
    }

    @Override
    public String next() {
        StringBuilder strBuilder = new StringBuilder();
        int fix = MathUtil.stripSignBit((int)this.rnd.nextInt()) % this.firstNames.size();
        strBuilder.append(this.firstNames.get(fix));
        strBuilder.append(" ");
        double d = Math.abs(this.rnd.nextDouble());
        if (d <= this.middleInitialProb) {
            int mix = MathUtil.stripSignBit((int)this.rnd.nextInt()) % LETTERS.length();
            strBuilder.append(LETTERS.charAt(mix));
            strBuilder.append(". ");
        }
        int lix = MathUtil.stripSignBit((int)this.rnd.nextInt()) % this.lastNames.size();
        strBuilder.append(this.lastNames.get(lix));
        return strBuilder.toString();
    }

    @Override
    public void reset() {
    }
}

