/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.util.Log4j2Monitor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractIndexLifecycleTest {
    protected IIndex index;

    protected abstract boolean persistentStateExists() throws Exception;

    protected abstract boolean isEmptyIndex() throws Exception;

    protected abstract void performInsertions() throws Exception;

    protected abstract void checkInsertions() throws Exception;

    protected abstract void clearCheckableInsertions() throws Exception;

    @BeforeClass
    public static void startLogsMonitor() {
        Configurator.setLevel((String)"org.apache.hyracks", (Level)Level.INFO);
        Log4j2Monitor.start();
    }

    @Before
    public abstract void setup() throws Exception;

    @After
    public abstract void tearDown() throws Exception;

    @Test
    public void validSequenceTest() throws Exception {
        Log4j2Monitor.reset();
        this.index.create();
        Assert.assertTrue((boolean)this.persistentStateExists());
        boolean exceptionCaught = false;
        try {
            this.index.create();
        }
        catch (Exception e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
        Assert.assertTrue((boolean)this.persistentStateExists());
        this.index.activate();
        Assert.assertTrue((boolean)this.isEmptyIndex());
        this.performInsertions();
        this.checkInsertions();
        this.clearCheckableInsertions();
        this.index.clear();
        Assert.assertTrue((boolean)this.isEmptyIndex());
        this.performInsertions();
        this.index.deactivate();
        this.index.activate();
        this.checkInsertions();
        this.index.deactivate();
        this.index.destroy();
        Assert.assertFalse((boolean)this.persistentStateExists());
        this.index.destroy();
        Assert.assertTrue((Log4j2Monitor.count((String)"Deleting non-existing file!") > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.persistentStateExists());
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest1() throws Exception {
        this.index.create();
        this.index.activate();
        try {
            this.index.create();
        }
        finally {
            this.index.deactivate();
            this.index.destroy();
        }
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest2() throws Exception {
        this.index.create();
        this.index.activate();
        try {
            this.index.destroy();
        }
        finally {
            this.index.deactivate();
            this.index.destroy();
        }
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest3() throws Exception {
        this.index.create();
        try {
            this.index.clear();
        }
        finally {
            this.index.destroy();
        }
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest4() throws Exception {
        this.index.clear();
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest5() throws Exception {
        this.index.create();
        this.index.activate();
        try {
            this.index.activate();
        }
        finally {
            this.index.deactivate();
            this.index.destroy();
        }
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest6() throws Exception {
        this.index.create();
        this.index.activate();
        this.index.deactivate();
        try {
            this.index.deactivate();
        }
        finally {
            this.index.destroy();
        }
    }
}

