/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.util.TreeSet;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestContext;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestDriver;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestUtils;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;

public abstract class OrderedIndexDeleteTest
extends OrderedIndexTestDriver {
    private final OrderedIndexTestUtils orderedIndexTestUtils = new OrderedIndexTestUtils();
    private static final int numInsertRounds = 3;
    private static final int numDeleteRounds = 3;

    public OrderedIndexDeleteTest(BTreeLeafFrameType[] leafFrameTypesToTest) {
        super(leafFrameTypesToTest);
    }

    @Override
    protected void runTest(ISerializerDeserializer[] fieldSerdes, int numKeys, BTreeLeafFrameType leafType, ITupleReference lowKey, ITupleReference highKey, ITupleReference prefixLowKey, ITupleReference prefixHighKey) throws Exception {
        OrderedIndexTestContext ctx = this.createTestContext(fieldSerdes, numKeys, leafType, false);
        ctx.getIndex().create();
        ctx.getIndex().activate();
        for (int i = 0; i < 3; ++i) {
            if (fieldSerdes[0] instanceof IntegerSerializerDeserializer) {
                this.orderedIndexTestUtils.insertIntTuples(ctx, 100, this.getRandom());
            } else if (fieldSerdes[0] instanceof UTF8StringSerializerDeserializer) {
                this.orderedIndexTestUtils.insertStringTuples(ctx, 100, false, this.getRandom());
            }
            int numTuplesPerDeleteRound = (int)Math.ceil((float)((TreeSet)ctx.getCheckTuples()).size() / 3.0f);
            for (int j = 0; j < 3; ++j) {
                this.orderedIndexTestUtils.deleteTuples(ctx, numTuplesPerDeleteRound, this.getRandom());
                this.orderedIndexTestUtils.checkPointSearches(ctx);
                this.orderedIndexTestUtils.checkScan(ctx);
                this.orderedIndexTestUtils.checkDiskOrderScan(ctx);
                this.orderedIndexTestUtils.checkRangeSearch(ctx, lowKey, highKey, true, true);
                if (prefixLowKey == null || prefixHighKey == null) continue;
                this.orderedIndexTestUtils.checkRangeSearch(ctx, prefixLowKey, prefixHighKey, true, true);
            }
        }
        ctx.getIndex().validate();
        ctx.getIndex().deactivate();
        ctx.getIndex().destroy();
    }

    @Override
    protected String getTestOpName() {
        return "Delete";
    }
}

