/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.test.support.TestJobletContext;
import org.apache.hyracks.test.support.TestNCApplicationContext;
import org.apache.hyracks.test.support.TestTaskContext;

public class TestUtils {
    public static IHyracksTaskContext create(int frameSize) {
        try {
            IOManager ioManager = TestUtils.createIoManager();
            TestNCApplicationContext appCtx = new TestNCApplicationContext((IIOManager)ioManager, null);
            TestJobletContext jobletCtx = new TestJobletContext(frameSize, appCtx, new JobId(0L));
            TaskAttemptId tid = new TaskAttemptId(new TaskId(new ActivityId(new OperatorDescriptorId(0), 0), 0), 0);
            TestTaskContext taskCtx = new TestTaskContext(jobletCtx, tid);
            return taskCtx;
        }
        catch (HyracksException e) {
            throw new RuntimeException(e);
        }
    }

    private static IOManager createIoManager() throws HyracksException {
        ArrayList<IODeviceHandle> devices = new ArrayList<IODeviceHandle>();
        devices.add(new IODeviceHandle(new File(System.getProperty("java.io.tmpdir")), "."));
        return new IOManager(devices, (Executor)Executors.newCachedThreadPool());
    }
}

