/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.TreeIndexTestUtils;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.util.HashMultiSet;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestContext;
import org.apache.hyracks.storage.am.rtree.RTreeCheckTuple;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.junit.Assert;

public class RTreeTestUtils
extends TreeIndexTestUtils {
    private static final Logger LOGGER = Logger.getLogger(RTreeTestUtils.class.getName());
    private int intPayloadValue = 0;
    private double doublePayloadValue = 0.0;

    public HashMultiSet<RTreeCheckTuple> getRangeSearchExpectedResults(Collection<RTreeCheckTuple> checkTuples, RTreeCheckTuple key) {
        HashMultiSet expectedResult = new HashMultiSet();
        for (RTreeCheckTuple t : checkTuples) {
            if (!t.intersect(key)) continue;
            expectedResult.add((Object)t);
        }
        return expectedResult;
    }

    public void checkRangeSearch(IIndexTestContext ictx, ITupleReference key) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Testing Range Search.");
        }
        AbstractRTreeTestContext ctx = (AbstractRTreeTestContext)ictx;
        MultiComparator cmp = RTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])ctx.getComparatorFactories(), (ITupleReference)key);
        ITreeIndexCursor searchCursor = (ITreeIndexCursor)ctx.getIndexAccessor().createSearchCursor(false);
        SearchPredicate searchPred = new SearchPredicate(key, cmp);
        ctx.getIndexAccessor().search((IIndexCursor)searchCursor, (ISearchPredicate)searchPred);
        RTreeCheckTuple keyCheck = (RTreeCheckTuple)this.createCheckTupleFromTuple(key, ctx.getFieldSerdes(), cmp.getKeyFieldCount());
        HashMultiSet<RTreeCheckTuple> expectedResult = null;
        expectedResult = this.getRangeSearchExpectedResults(ctx.getCheckTuples(), keyCheck);
        this.checkExpectedResults(searchCursor, (Collection)expectedResult, ctx.getFieldSerdes(), ctx.getKeyFieldCount(), null);
    }

    public void insertDoubleTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        double[] fieldValues = new double[ctx.getFieldCount()];
        double maxValue = Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        for (int i = 0; i < numTuples; ++i) {
            this.setDoubleKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setDoublePayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createDoubleTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (double[])fieldValues);
            if (LOGGER.isLoggable(Level.INFO) && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            try {
                ctx.getIndexAccessor().insert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createDoubleCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
    }

    private void setDoubleKeyFields(double[] fieldValues, int numKeyFields, double maxValue, Random rnd) {
        int maxFieldPos = numKeyFields / 2;
        for (int j = 0; j < maxFieldPos; ++j) {
            double secondValue;
            int k = maxFieldPos + j;
            double firstValue = rnd.nextDouble() % maxValue;
            while ((secondValue = rnd.nextDouble() % maxValue) < firstValue) {
            }
            fieldValues[j] = firstValue;
            fieldValues[k] = secondValue;
        }
    }

    private void setDoublePayloadFields(double[] fieldValues, int numKeyFields, int numFields) {
        for (int j = numKeyFields; j < numFields; ++j) {
            this.doublePayloadValue += 1.0;
        }
    }

    protected CheckTuple createDoubleCheckTuple(double[] fieldValues, int numKeyFields) {
        RTreeCheckTuple<Double> checkTuple = new RTreeCheckTuple<Double>(fieldValues.length, numKeyFields);
        for (double v : fieldValues) {
            checkTuple.appendField(v);
        }
        return checkTuple;
    }

    public void bulkLoadDoubleTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        double[] fieldValues = new double[ctx.getFieldCount()];
        double maxValue = Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        Collection tmpCheckTuples = this.createCheckTuplesCollection();
        for (int i = 0; i < numTuples; ++i) {
            this.setDoubleKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setDoublePayloadFields(fieldValues, numKeyFields, fieldCount);
            ctx.insertCheckTuple(this.createDoubleCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        RTreeTestUtils.bulkLoadCheckTuples(ctx, tmpCheckTuples);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkExpectedResults(ITreeIndexCursor cursor, Collection checkTuples, ISerializerDeserializer[] fieldSerdes, int keyFieldCount, Iterator<CheckTuple> checkIter) throws Exception {
        int actualCount = 0;
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference tuple = cursor.getTuple();
                RTreeCheckTuple checkTuple = (RTreeCheckTuple)this.createCheckTupleFromTuple(tuple, fieldSerdes, keyFieldCount);
                if (!checkTuples.contains(checkTuple)) {
                    Assert.fail((String)("Scan or range search returned unexpected answer: " + checkTuple.toString()));
                }
                ++actualCount;
            }
            if (actualCount < checkTuples.size()) {
                Assert.fail((String)("Scan or range search returned fewer answers than expected.\nExpected: " + checkTuples.size() + "\nActual  : " + actualCount));
            }
            if (actualCount > checkTuples.size()) {
                Assert.fail((String)("Scan or range search returned more answers than expected.\nExpected: " + checkTuples.size() + "\nActual  : " + actualCount));
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    protected CheckTuple createCheckTuple(int numFields, int numKeyFields) {
        return new RTreeCheckTuple(numFields, numKeyFields);
    }

    @Override
    protected ISearchPredicate createNullSearchPredicate() {
        return new SearchPredicate(null, null);
    }

    @Override
    protected CheckTuple createIntCheckTuple(int[] fieldValues, int numKeyFields) {
        RTreeCheckTuple<Integer> checkTuple = new RTreeCheckTuple<Integer>(fieldValues.length, numKeyFields);
        for (int v : fieldValues) {
            checkTuple.appendField(v);
        }
        return checkTuple;
    }

    @Override
    protected void setIntKeyFields(int[] fieldValues, int numKeyFields, int maxValue, Random rnd) {
        int maxFieldPos = numKeyFields / 2;
        for (int j = 0; j < maxFieldPos; ++j) {
            int secondValue;
            int k = maxFieldPos + j;
            int firstValue = rnd.nextInt() % maxValue;
            while ((secondValue = rnd.nextInt() % maxValue) < firstValue) {
            }
            fieldValues[j] = firstValue;
            fieldValues[k] = secondValue;
        }
    }

    @Override
    protected void setIntPayloadFields(int[] fieldValues, int numKeyFields, int numFields) {
        for (int j = numKeyFields; j < numFields; ++j) {
            ++this.intPayloadValue;
        }
    }

    @Override
    protected Collection createCheckTuplesCollection() {
        return new ArrayList();
    }

    @Override
    protected ArrayTupleBuilder createDeleteTupleBuilder(IIndexTestContext ctx) {
        return new ArrayTupleBuilder(ctx.getFieldCount());
    }

    @Override
    protected boolean checkDiskOrderScanResult(ITupleReference tuple, CheckTuple checkTuple, IIndexTestContext ctx) throws HyracksDataException {
        return ctx.getCheckTuples().contains(checkTuple);
    }
}

