/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.util.SerdeUtils;
import org.apache.hyracks.storage.am.common.IIndexTestWorkerFactory;
import org.apache.hyracks.storage.am.common.IndexMultiThreadTestDriver;
import org.apache.hyracks.storage.am.common.TestWorkloadConf;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeExamplesTest;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.junit.Test;

public abstract class AbstractRTreeMultiThreadTest {
    protected final boolean testRstarPolicy;
    protected final AbstractRTreeExamplesTest.RTreeType rTreeType;
    protected final Logger LOGGER = Logger.getLogger(AbstractRTreeMultiThreadTest.class.getName());
    protected final int REGULAR_NUM_THREADS = Runtime.getRuntime().availableProcessors();
    protected final int EXCESSIVE_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 4;
    protected final int NUM_OPERATIONS = 200;
    protected ArrayList<TestWorkloadConf> workloadConfs = this.getTestWorkloadConf();

    public AbstractRTreeMultiThreadTest(boolean testRstarPolicy, AbstractRTreeExamplesTest.RTreeType rTreeType) {
        this.testRstarPolicy = testRstarPolicy;
        this.rTreeType = rTreeType;
    }

    protected abstract void setUp() throws HyracksDataException;

    protected abstract void tearDown() throws HyracksDataException;

    protected abstract ITreeIndex createTreeIndex(ITypeTraits[] var1, IBinaryComparatorFactory[] var2, IBinaryComparatorFactory[] var3, IPrimitiveValueProviderFactory[] var4, RTreePolicyType var5, int[] var6) throws TreeIndexException, HyracksDataException;

    protected abstract IIndexTestWorkerFactory getWorkerFactory();

    protected abstract ArrayList<TestWorkloadConf> getTestWorkloadConf();

    protected abstract String getIndexTypeName();

    protected void runTest(ISerializerDeserializer[] fieldSerdes, IPrimitiveValueProviderFactory[] valueProviderFactories, int numKeys, RTreePolicyType rtreePolicyType, int numThreads, TestWorkloadConf conf, String dataMsg) throws HyracksDataException, InterruptedException, TreeIndexException {
        IBinaryComparatorFactory[] btreeCmpFactories;
        this.setUp();
        if (this.LOGGER.isLoggable(Level.INFO)) {
            String indexTypeName = this.getIndexTypeName();
            this.LOGGER.info(indexTypeName + " MultiThread Test:\nData: " + dataMsg + "; Threads: " + numThreads + "; Workload: " + conf.toString() + ".");
        }
        ITypeTraits[] typeTraits = SerdeUtils.serdesToTypeTraits((ISerializerDeserializer[])fieldSerdes);
        IBinaryComparatorFactory[] rtreeCmpFactories = SerdeUtils.serdesToComparatorFactories((ISerializerDeserializer[])fieldSerdes, (int)numKeys);
        int[] btreeFields = null;
        if (this.rTreeType == AbstractRTreeExamplesTest.RTreeType.LSMRTREE) {
            int numBtreeFields = fieldSerdes.length - numKeys;
            ISerializerDeserializer[] btreeFieldSerdes = new ISerializerDeserializer[numBtreeFields];
            btreeFields = new int[numBtreeFields];
            for (int i = 0; i < numBtreeFields; ++i) {
                btreeFields[i] = numKeys + i;
                btreeFieldSerdes[i] = fieldSerdes[numKeys + i];
            }
            btreeCmpFactories = SerdeUtils.serdesToComparatorFactories((ISerializerDeserializer[])btreeFieldSerdes, (int)numBtreeFields);
        } else {
            btreeCmpFactories = SerdeUtils.serdesToComparatorFactories((ISerializerDeserializer[])fieldSerdes, (int)fieldSerdes.length);
        }
        ITreeIndex index = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, rtreePolicyType, btreeFields);
        IIndexTestWorkerFactory workerFactory = this.getWorkerFactory();
        int batchSize = 200 / numThreads / 4;
        IndexMultiThreadTestDriver driver = new IndexMultiThreadTestDriver((IIndex)index, workerFactory, fieldSerdes, conf.ops, conf.opProbs);
        driver.init();
        long[] times = driver.run(numThreads, 1, 200, batchSize);
        driver.deinit();
        if (this.LOGGER.isLoggable(Level.INFO)) {
            this.LOGGER.info("RTree MultiThread Test Time: " + times[0] + "ms");
        }
        this.tearDown();
    }

    @Test
    public void rtreeTwoDimensionsInt() throws InterruptedException, HyracksDataException, TreeIndexException {
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)IntegerPointable.FACTORY);
        String dataMsg = "Two Dimensions Of Integer Values";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RTREE, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RTREE, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }

    @Test
    public void rtreeTwoDimensionsDouble() throws Exception {
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        String dataMsg = "Two Dimensions Of Double Values";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RTREE, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RTREE, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }

    @Test
    public void rtreeFourDimensionsDouble() throws InterruptedException, HyracksDataException, TreeIndexException {
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 8;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        String dataMsg = "Four Dimensions Of Double Values";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RTREE, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RTREE, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }

    @Test
    public void rstartreeTwoDimensionsInt() throws InterruptedException, HyracksDataException, TreeIndexException {
        if (!this.testRstarPolicy) {
            if (this.LOGGER.isLoggable(Level.INFO)) {
                this.LOGGER.info("Ignoring RTree Multithread Test With Two Dimensions With Integer Keys.");
            }
            return;
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)IntegerPointable.FACTORY);
        String dataMsg = "Two Dimensions Of Integer Values";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RSTARTREE, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RSTARTREE, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }

    @Test
    public void rstartreeTwoDimensionsDouble() throws Exception {
        if (!this.testRstarPolicy) {
            if (this.LOGGER.isLoggable(Level.INFO)) {
                this.LOGGER.info("Ignoring RTree Multithread Test With Two Dimensions With Double Keys.");
            }
            return;
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 4;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        String dataMsg = "Two Dimensions Of Double Values";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RSTARTREE, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RSTARTREE, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }

    @Test
    public void rstartreeFourDimensionsDouble() throws InterruptedException, HyracksDataException, TreeIndexException {
        if (!this.testRstarPolicy) {
            if (this.LOGGER.isLoggable(Level.INFO)) {
                this.LOGGER.info("Ignoring RTree Multithread Test With Four Dimensions With Double Keys.");
            }
            return;
        }
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int numKeys = 8;
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)numKeys, (IPointableFactory)DoublePointable.FACTORY);
        String dataMsg = "Four Dimensions Of Double Values";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RSTARTREE, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, valueProviderFactories, numKeys, RTreePolicyType.RSTARTREE, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }
}

