/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.common.TestOperationCallback;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.junit.Test;

public abstract class AbstractRTreeExamplesTest {
    protected static final Logger LOGGER = Logger.getLogger(AbstractRTreeExamplesTest.class.getName());
    protected final Random rnd = new Random(50L);
    protected RTreeType rTreeType;

    protected abstract ITreeIndex createTreeIndex(ITypeTraits[] var1, IBinaryComparatorFactory[] var2, IBinaryComparatorFactory[] var3, IPrimitiveValueProviderFactory[] var4, RTreePolicyType var5, int[] var6, int[] var7, ITypeTraits[] var8, IBinaryComparatorFactory[] var9, int[] var10) throws TreeIndexException, HyracksDataException;

    @Test
    public void twoDimensionsExample() throws Exception {
        IBinaryComparatorFactory[] btreeCmpFactories;
        int btreeKeyFieldCount;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Fixed-Length Key,Value Example.");
        }
        int fieldCount = 6;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        typeTraits[3] = IntegerPointable.TYPE_TRAITS;
        typeTraits[4] = IntegerPointable.TYPE_TRAITS;
        typeTraits[5] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int rtreeKeyFieldCount = 4;
        IBinaryComparatorFactory[] rtreeCmpFactories = new IBinaryComparatorFactory[rtreeKeyFieldCount];
        rtreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] btreeFields = null;
        if (this.rTreeType == RTreeType.LSMRTREE) {
            btreeKeyFieldCount = 2;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeFields = new int[btreeKeyFieldCount];
            for (int i = 0; i < btreeKeyFieldCount; ++i) {
                btreeFields[i] = rtreeKeyFieldCount + i;
            }
        } else {
            btreeKeyFieldCount = 6;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[5] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)rtreeCmpFactories.length, (IPointableFactory)IntegerPointable.FACTORY);
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, RTreePolicyType.RTREE, null, btreeFields, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        int numInserts = 10000;
        for (int i = 0; i < numInserts; ++i) {
            int p1x = this.rnd.nextInt();
            int p1y = this.rnd.nextInt();
            int p2x = this.rnd.nextInt();
            int p2y = this.rnd.nextInt();
            int pk1 = 5;
            int pk2 = 10;
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), pk1, pk2});
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.scan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder keyTb = new ArrayTupleBuilder(rtreeKeyFieldCount);
        ArrayTupleReference key = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)keyTb, (ArrayTupleReference)key, (int[])new int[]{-1000, -1000, 1000, 1000});
        this.rangeSearch(rtreeCmpFactories, indexAccessor, fieldSerdes, (ITupleReference)key, null, null);
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void rTreePageSplitTestExample() throws Exception {
        int i;
        IBinaryComparatorFactory[] btreeCmpFactories;
        int btreeKeyFieldCount;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("RTree page split test.");
        }
        int fieldCount = 5;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        typeTraits[3] = IntegerPointable.TYPE_TRAITS;
        typeTraits[4] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, new UTF8StringSerializerDeserializer()};
        int rtreeKeyFieldCount = 4;
        IBinaryComparatorFactory[] rtreeCmpFactories = new IBinaryComparatorFactory[rtreeKeyFieldCount];
        rtreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] btreeFields = null;
        if (this.rTreeType == RTreeType.LSMRTREE) {
            btreeKeyFieldCount = 1;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
            btreeFields = new int[btreeKeyFieldCount];
            for (int i2 = 0; i2 < btreeKeyFieldCount; ++i2) {
                btreeFields[i2] = rtreeKeyFieldCount + i2;
            }
        } else {
            btreeKeyFieldCount = 5;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)rtreeCmpFactories.length, (IPointableFactory)IntegerPointable.FACTORY);
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, RTreePolicyType.RTREE, null, btreeFields, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        int p1x = this.rnd.nextInt();
        int p1y = this.rnd.nextInt();
        int p2x = this.rnd.nextInt();
        int p2y = this.rnd.nextInt();
        String data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void rStarTreePageSplitTestExample() throws Exception {
        int i;
        IBinaryComparatorFactory[] btreeCmpFactories;
        int btreeKeyFieldCount;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("R*Tree page split test.");
        }
        int fieldCount = 5;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        typeTraits[3] = IntegerPointable.TYPE_TRAITS;
        typeTraits[4] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, new UTF8StringSerializerDeserializer()};
        int rtreeKeyFieldCount = 4;
        IBinaryComparatorFactory[] rtreeCmpFactories = new IBinaryComparatorFactory[rtreeKeyFieldCount];
        rtreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] btreeFields = null;
        if (this.rTreeType == RTreeType.LSMRTREE) {
            btreeKeyFieldCount = 1;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
            btreeFields = new int[btreeKeyFieldCount];
            for (int i2 = 0; i2 < btreeKeyFieldCount; ++i2) {
                btreeFields[i2] = rtreeKeyFieldCount + i2;
            }
        } else {
            btreeKeyFieldCount = 5;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)rtreeCmpFactories.length, (IPointableFactory)IntegerPointable.FACTORY);
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, RTreePolicyType.RSTARTREE, null, btreeFields, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        int p1x = this.rnd.nextInt();
        int p1y = this.rnd.nextInt();
        int p2x = this.rnd.nextInt();
        int p2y = this.rnd.nextInt();
        String data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        p1x = this.rnd.nextInt();
        p1y = this.rnd.nextInt();
        p2x = this.rnd.nextInt();
        p2y = this.rnd.nextInt();
        data = "";
        for (i = 0; i < 210; ++i) {
            data = data + "X";
        }
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), data});
        indexAccessor.insert((ITupleReference)tuple);
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void threeDimensionsExample() throws Exception {
        IBinaryComparatorFactory[] btreeCmpFactories;
        int btreeKeyFieldCount;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Fixed-Length Key,Value Example.");
        }
        int fieldCount = 7;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = DoublePointable.TYPE_TRAITS;
        typeTraits[1] = DoublePointable.TYPE_TRAITS;
        typeTraits[2] = DoublePointable.TYPE_TRAITS;
        typeTraits[3] = DoublePointable.TYPE_TRAITS;
        typeTraits[4] = DoublePointable.TYPE_TRAITS;
        typeTraits[5] = DoublePointable.TYPE_TRAITS;
        typeTraits[6] = DoublePointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE, DoubleSerializerDeserializer.INSTANCE};
        int rtreeKeyFieldCount = 6;
        IBinaryComparatorFactory[] rtreeCmpFactories = new IBinaryComparatorFactory[rtreeKeyFieldCount];
        rtreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        rtreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        rtreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        rtreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        rtreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        rtreeCmpFactories[5] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        int[] btreeFields = null;
        if (this.rTreeType == RTreeType.LSMRTREE) {
            btreeKeyFieldCount = 1;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeFields = new int[btreeKeyFieldCount];
            for (int i = 0; i < btreeKeyFieldCount; ++i) {
                btreeFields[i] = rtreeKeyFieldCount + i;
            }
        } else {
            btreeKeyFieldCount = 7;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeCmpFactories[5] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
            btreeCmpFactories[6] = PointableBinaryComparatorFactory.of((IPointableFactory)DoublePointable.FACTORY);
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)rtreeCmpFactories.length, (IPointableFactory)DoublePointable.FACTORY);
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, RTreePolicyType.RTREE, null, btreeFields, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        int numInserts = 10000;
        for (int i = 0; i < numInserts; ++i) {
            double p1x = this.rnd.nextDouble();
            double p1y = this.rnd.nextDouble();
            double p1z = this.rnd.nextDouble();
            double p2x = this.rnd.nextDouble();
            double p2y = this.rnd.nextDouble();
            double p2z = this.rnd.nextDouble();
            double pk = 5.0;
            TupleUtils.createDoubleTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (double[])new double[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.min(p1z, p2z), Math.max(p1x, p2x), Math.max(p1y, p2y), Math.max(p1z, p2z), pk});
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.scan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder keyTb = new ArrayTupleBuilder(rtreeKeyFieldCount);
        ArrayTupleReference key = new ArrayTupleReference();
        TupleUtils.createDoubleTuple((ArrayTupleBuilder)keyTb, (ArrayTupleReference)key, (double[])new double[]{-1000.0, -1000.0, -1000.0, 1000.0, 1000.0, 1000.0});
        this.rangeSearch(rtreeCmpFactories, indexAccessor, fieldSerdes, (ITupleReference)key, null, null);
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void deleteExample() throws Exception {
        IBinaryComparatorFactory[] btreeCmpFactories;
        int btreeKeyFieldCount;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Deletion Example");
        }
        int fieldCount = 5;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        typeTraits[3] = IntegerPointable.TYPE_TRAITS;
        typeTraits[4] = IntegerPointable.TYPE_TRAITS;
        int rtreeKeyFieldCount = 4;
        IBinaryComparatorFactory[] rtreeCmpFactories = new IBinaryComparatorFactory[rtreeKeyFieldCount];
        rtreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] btreeFields = null;
        if (this.rTreeType == RTreeType.LSMRTREE) {
            btreeKeyFieldCount = 1;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeFields = new int[btreeKeyFieldCount];
            for (int i = 0; i < btreeKeyFieldCount; ++i) {
                btreeFields[i] = rtreeKeyFieldCount + i;
            }
        } else {
            btreeKeyFieldCount = 5;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)rtreeCmpFactories.length, (IPointableFactory)IntegerPointable.FACTORY);
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, RTreePolicyType.RTREE, null, btreeFields, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        int runs = 3;
        for (int run = 0; run < runs; ++run) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Deletion example run: " + (run + 1) + "/" + runs);
                LOGGER.info("Inserting into tree...");
            }
            int numInserts = 10000;
            int[] p1xs = new int[numInserts];
            int[] p1ys = new int[numInserts];
            int[] p2xs = new int[numInserts];
            int[] p2ys = new int[numInserts];
            int[] pks = new int[numInserts];
            int insDone = 0;
            int[] insDoneCmp = new int[numInserts];
            for (int i = 0; i < numInserts; ++i) {
                int p1x = this.rnd.nextInt();
                int p1y = this.rnd.nextInt();
                int p2x = this.rnd.nextInt();
                int p2y = this.rnd.nextInt();
                int pk = 5;
                p1xs[i] = Math.min(p1x, p2x);
                p1ys[i] = Math.min(p1y, p2y);
                p2xs[i] = Math.max(p1x, p2x);
                p2ys[i] = Math.max(p1y, p2y);
                pks[i] = pk;
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), pk});
                try {
                    indexAccessor.insert((ITupleReference)tuple);
                }
                catch (TreeIndexException treeIndexException) {
                    // empty catch block
                }
                insDoneCmp[i] = insDone;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Deleting from tree...");
            }
            int delDone = 0;
            for (int i = 0; i < numInserts; ++i) {
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{p1xs[i], p1ys[i], p2xs[i], p2ys[i], pks[i]});
                try {
                    indexAccessor.delete((ITupleReference)tuple);
                    ++delDone;
                }
                catch (TreeIndexException treeIndexException) {
                    // empty catch block
                }
                if (insDoneCmp[i] == delDone) continue;
                if (!LOGGER.isLoggable(Level.INFO)) break;
                LOGGER.info("INCONSISTENT STATE, ERROR IN DELETION EXAMPLE.");
                LOGGER.info("INSDONECMP: " + insDoneCmp[i] + " " + delDone);
                break;
            }
            if (insDone == delDone) continue;
            if (!LOGGER.isLoggable(Level.INFO)) break;
            LOGGER.info("ERROR! INSDONE: " + insDone + " DELDONE: " + delDone);
            break;
        }
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void bulkLoadExample() throws Exception {
        IBinaryComparatorFactory[] btreeCmpFactories;
        int btreeKeyFieldCount;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Bulk load example");
        }
        int fieldCount = 5;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        typeTraits[3] = IntegerPointable.TYPE_TRAITS;
        typeTraits[4] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int rtreeKeyFieldCount = 4;
        IBinaryComparatorFactory[] rtreeCmpFactories = new IBinaryComparatorFactory[rtreeKeyFieldCount];
        rtreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        rtreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] btreeFields = null;
        if (this.rTreeType == RTreeType.LSMRTREE) {
            btreeKeyFieldCount = 1;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeFields = new int[btreeKeyFieldCount];
            for (int i = 0; i < btreeKeyFieldCount; ++i) {
                btreeFields[i] = rtreeKeyFieldCount + i;
            }
        } else {
            btreeKeyFieldCount = 5;
            btreeCmpFactories = new IBinaryComparatorFactory[btreeKeyFieldCount];
            btreeCmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[2] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[3] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
            btreeCmpFactories[4] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = RTreeUtils.createPrimitiveValueProviderFactories((int)rtreeCmpFactories.length, (IPointableFactory)IntegerPointable.FACTORY);
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, rtreeCmpFactories, btreeCmpFactories, valueProviderFactories, RTreePolicyType.RTREE, null, btreeFields, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        int numInserts = 10000;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Bulk loading " + numInserts + " tuples");
        }
        long start = System.currentTimeMillis();
        IIndexBulkLoader bulkLoader = treeIndex.createBulkLoader(0.7f, false, (long)numInserts, true);
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        for (int i = 0; i < numInserts; ++i) {
            int p1x = this.rnd.nextInt();
            int p1y = this.rnd.nextInt();
            int p2x = this.rnd.nextInt();
            int p2y = this.rnd.nextInt();
            int pk = 5;
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{Math.min(p1x, p2x), Math.min(p1y, p2y), Math.max(p1x, p2x), Math.max(p1y, p2y), pk});
            bulkLoader.add((ITupleReference)tuple);
        }
        bulkLoader.end();
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(numInserts + " tuples loaded in " + (end - start) + "ms");
        }
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        ArrayTupleBuilder keyTb = new ArrayTupleBuilder(rtreeKeyFieldCount);
        ArrayTupleReference key = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)keyTb, (ArrayTupleReference)key, (int[])new int[]{-1000, -1000, 1000, 1000});
        this.rangeSearch(rtreeCmpFactories, indexAccessor, fieldSerdes, (ITupleReference)key, null, null);
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Scan:");
        }
        ITreeIndexCursor scanCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
        SearchPredicate nullPred = new SearchPredicate(null, null);
        indexAccessor.search((IIndexCursor)scanCursor, (ISearchPredicate)nullPred);
        try {
            while (scanCursor.hasNext()) {
                scanCursor.next();
                ITupleReference frameTuple = scanCursor.getTuple();
                String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info(rec);
            }
        }
        finally {
            scanCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void diskOrderScan(IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes) throws Exception {
        block9: {
            try {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Disk-Order Scan:");
                }
                ITreeIndexAccessor treeIndexAccessor = (ITreeIndexAccessor)indexAccessor;
                treeIndexAccessor.diskOrderScan((ITreeIndexCursor)diskOrderCursor);
                try (TreeIndexDiskOrderScanCursor diskOrderCursor = (TreeIndexDiskOrderScanCursor)treeIndexAccessor.createDiskOrderScanCursor();){
                    while (diskOrderCursor.hasNext()) {
                        diskOrderCursor.next();
                        ITreeIndexTupleReference frameTuple = diskOrderCursor.getTuple();
                        String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.info(rec);
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Ignoring disk-order scan since it's not supported.");
                }
            }
            catch (ClassCastException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block9;
                LOGGER.info("Ignoring disk-order scan since it's not supported.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rangeSearch(IBinaryComparatorFactory[] cmpFactories, IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes, ITupleReference key, ITupleReference minFilterTuple, ITupleReference maxFilterTuple) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            String kString = TupleUtils.printTuple((ITupleReference)key, (ISerializerDeserializer[])fieldSerdes);
            LOGGER.info("Range-Search using key: " + kString);
        }
        ITreeIndexCursor rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
        MultiComparator cmp = RTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])cmpFactories, (ITupleReference)key);
        SearchPredicate rangePred = minFilterTuple != null && maxFilterTuple != null ? new SearchPredicate(key, cmp, minFilterTuple, maxFilterTuple) : new SearchPredicate(key, cmp);
        indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
        try {
            while (rangeCursor.hasNext()) {
                rangeCursor.next();
                ITupleReference frameTuple = rangeCursor.getTuple();
                String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info(rec);
            }
        }
        finally {
            rangeCursor.close();
        }
    }

    public static enum RTreeType {
        LSMRTREE,
        LSMRTREE_WITH_ANTIMATTER,
        RTREE;

    }
}

