/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestContext;
import org.apache.hyracks.storage.am.rtree.AbstractRTreeTestDriver;
import org.apache.hyracks.storage.am.rtree.RTreeTestUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;

public abstract class AbstractRTreeBulkLoadTest
extends AbstractRTreeTestDriver {
    private final RTreeTestUtils rTreeTestUtils = new RTreeTestUtils();

    public AbstractRTreeBulkLoadTest(boolean testRstarPolicy) {
        super(testRstarPolicy);
    }

    @Override
    protected void runTest(ISerializerDeserializer[] fieldSerdes, IPrimitiveValueProviderFactory[] valueProviderFactories, int numKeys, ITupleReference key, RTreePolicyType rtreePolicyType) throws Exception {
        AbstractRTreeTestContext ctx = this.createTestContext(fieldSerdes, valueProviderFactories, numKeys, rtreePolicyType);
        ctx.getIndex().create();
        ctx.getIndex().activate();
        if (fieldSerdes[0] instanceof IntegerSerializerDeserializer) {
            this.rTreeTestUtils.bulkLoadIntTuples(ctx, 100, this.getRandom());
        } else if (fieldSerdes[0] instanceof DoubleSerializerDeserializer) {
            this.rTreeTestUtils.bulkLoadDoubleTuples(ctx, 100, this.getRandom());
        }
        this.rTreeTestUtils.checkScan(ctx);
        this.rTreeTestUtils.checkDiskOrderScan(ctx);
        this.rTreeTestUtils.checkRangeSearch(ctx, key);
        ctx.getIndex().deactivate();
        ctx.getIndex().destroy();
    }

    @Override
    protected String getTestOpName() {
        return "BulkLoad";
    }
}

