/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.junit.Assert;

public abstract class TreeIndexTestUtils {
    private static final Logger LOGGER = Logger.getLogger(TreeIndexTestUtils.class.getName());

    protected abstract CheckTuple createCheckTuple(int var1, int var2);

    protected abstract ISearchPredicate createNullSearchPredicate();

    public abstract void checkExpectedResults(ITreeIndexCursor var1, Collection var2, ISerializerDeserializer[] var3, int var4, Iterator<CheckTuple> var5) throws Exception;

    protected abstract CheckTuple createIntCheckTuple(int[] var1, int var2);

    protected abstract void setIntKeyFields(int[] var1, int var2, int var3, Random var4);

    protected abstract void setIntPayloadFields(int[] var1, int var2, int var3);

    protected abstract Collection createCheckTuplesCollection();

    protected abstract ArrayTupleBuilder createDeleteTupleBuilder(IIndexTestContext var1);

    protected abstract boolean checkDiskOrderScanResult(ITupleReference var1, CheckTuple var2, IIndexTestContext var3) throws HyracksDataException;

    public static void createTupleFromCheckTuple(CheckTuple checkTuple, ArrayTupleBuilder tupleBuilder, ArrayTupleReference tuple, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        int fieldCount = tupleBuilder.getFieldEndOffsets().length;
        DataOutput dos = tupleBuilder.getDataOutput();
        tupleBuilder.reset();
        for (int i = 0; i < fieldCount; ++i) {
            fieldSerdes[i].serialize(checkTuple.getField(i), dos);
            tupleBuilder.addFieldEndOffset();
        }
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
    }

    public CheckTuple createCheckTupleFromTuple(ITupleReference tuple, ISerializerDeserializer[] fieldSerdes, int numKeys) throws HyracksDataException {
        CheckTuple checkTuple = this.createCheckTuple(fieldSerdes.length, numKeys);
        int fieldCount = Math.min(fieldSerdes.length, tuple.getFieldCount());
        for (int i = 0; i < fieldCount; ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            DataInputStream dataIn = new DataInputStream(inStream);
            Comparable fieldObj = (Comparable)fieldSerdes[i].deserialize((DataInput)dataIn);
            checkTuple.appendField(fieldObj);
        }
        return checkTuple;
    }

    public void checkScan(IIndexTestContext ctx) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Testing Scan.");
        }
        ITreeIndexCursor scanCursor = (ITreeIndexCursor)ctx.getIndexAccessor().createSearchCursor(false);
        ISearchPredicate nullPred = this.createNullSearchPredicate();
        ctx.getIndexAccessor().search((IIndexCursor)scanCursor, nullPred);
        Iterator<CheckTuple> checkIter = ctx.getCheckTuples().iterator();
        this.checkExpectedResults(scanCursor, ctx.getCheckTuples(), ctx.getFieldSerdes(), ctx.getKeyFieldCount(), checkIter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDiskOrderScan(IIndexTestContext ctx) throws Exception {
        block16: {
            try {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Testing Disk-Order Scan.");
                }
                ITreeIndexAccessor treeIndexAccessor = (ITreeIndexAccessor)ctx.getIndexAccessor();
                ITreeIndexCursor diskOrderCursor = treeIndexAccessor.createDiskOrderScanCursor();
                treeIndexAccessor.diskOrderScan(diskOrderCursor);
                int actualCount = 0;
                try {
                    while (diskOrderCursor.hasNext()) {
                        diskOrderCursor.next();
                        ITupleReference tuple = diskOrderCursor.getTuple();
                        CheckTuple checkTuple = this.createCheckTupleFromTuple(tuple, ctx.getFieldSerdes(), ctx.getKeyFieldCount());
                        if (!this.checkDiskOrderScanResult(tuple, checkTuple, ctx)) {
                            Assert.fail((String)("Disk-order scan returned unexpected answer: " + checkTuple.toString()));
                        }
                        ++actualCount;
                    }
                    if (actualCount < ctx.getCheckTuples().size()) {
                        Assert.fail((String)("Disk-order scan returned fewer answers than expected.\nExpected: " + ctx.getCheckTuples().size() + "\nActual  : " + actualCount));
                    }
                    if (actualCount > ctx.getCheckTuples().size()) {
                        Assert.fail((String)("Disk-order scan returned more answers than expected.\nExpected: " + ctx.getCheckTuples().size() + "\nActual  : " + actualCount));
                    }
                }
                finally {
                    try {
                        diskOrderCursor.close();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Error during scan cursor close", ex);
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Ignoring disk-order scan since it's not supported.");
                }
            }
            catch (ClassCastException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block16;
                LOGGER.info("Ignoring disk-order scan since it's not supported.");
            }
        }
    }

    public void insertIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (int[])fieldValues);
            if (LOGGER.isLoggable(Level.INFO) && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            try {
                ctx.getIndexAccessor().insert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
    }

    public void upsertIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)ctx.getTupleBuilder(), (ArrayTupleReference)ctx.getTuple(), (int[])fieldValues);
            if (LOGGER.isLoggable(Level.INFO) && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Inserting Tuple " + (i + 1) + "/" + numTuples);
            }
            try {
                ctx.getIndexAccessor().upsert((ITupleReference)ctx.getTuple());
                ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), ctx.getCheckTuples());
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
    }

    public void bulkLoadIntTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        int fieldCount = ctx.getFieldCount();
        int numKeyFields = ctx.getKeyFieldCount();
        int[] fieldValues = new int[ctx.getFieldCount()];
        int maxValue = (int)Math.ceil(Math.pow(numTuples, 1.0 / (double)numKeyFields));
        Collection tmpCheckTuples = this.createCheckTuplesCollection();
        for (int i = 0; i < numTuples; ++i) {
            this.setIntKeyFields(fieldValues, numKeyFields, maxValue, rnd);
            this.setIntPayloadFields(fieldValues, numKeyFields, fieldCount);
            ctx.insertCheckTuple(this.createIntCheckTuple(fieldValues, ctx.getKeyFieldCount()), tmpCheckTuples);
        }
        TreeIndexTestUtils.bulkLoadCheckTuples(ctx, tmpCheckTuples);
        for (CheckTuple checkTuple : tmpCheckTuples) {
            ctx.insertCheckTuple(checkTuple, ctx.getCheckTuples());
        }
    }

    public static void bulkLoadCheckTuples(IIndexTestContext ctx, Collection<CheckTuple> checkTuples) throws HyracksDataException, IndexException {
        int fieldCount = ctx.getFieldCount();
        int numTuples = checkTuples.size();
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexBulkLoader bulkLoader = ctx.getIndex().createBulkLoader(0.7f, false, (long)numTuples, false);
        int c = 1;
        for (CheckTuple checkTuple : checkTuples) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Bulk Loading Tuple " + c + "/" + numTuples);
            }
            TreeIndexTestUtils.createTupleFromCheckTuple(checkTuple, tupleBuilder, tuple, ctx.getFieldSerdes());
            bulkLoader.add((ITupleReference)tuple);
            ++c;
        }
        bulkLoader.end();
    }

    public void deleteTuples(IIndexTestContext ctx, int numTuples, Random rnd) throws Exception {
        ArrayTupleBuilder deleteTupleBuilder = this.createDeleteTupleBuilder(ctx);
        ArrayTupleReference deleteTuple = new ArrayTupleReference();
        int numCheckTuples = ctx.getCheckTuples().size();
        CheckTuple[] checkTuples = new CheckTuple[numCheckTuples];
        int idx = 0;
        for (CheckTuple checkTuple : ctx.getCheckTuples()) {
            checkTuples[idx++] = checkTuple;
        }
        for (int i = 0; i < numTuples && numCheckTuples > 0; --numCheckTuples, ++i) {
            if (LOGGER.isLoggable(Level.INFO) && (i + 1) % (numTuples / Math.min(10, numTuples)) == 0) {
                LOGGER.info("Deleting Tuple " + (i + 1) + "/" + numTuples);
            }
            int checkTupleIdx = Math.abs(rnd.nextInt() % numCheckTuples);
            CheckTuple checkTuple = checkTuples[checkTupleIdx];
            TreeIndexTestUtils.createTupleFromCheckTuple(checkTuple, deleteTupleBuilder, deleteTuple, ctx.getFieldSerdes());
            ctx.getIndexAccessor().delete((ITupleReference)deleteTuple);
            ctx.deleteCheckTuple(checkTuple, ctx.getCheckTuples());
            CheckTuple tmp = checkTuples[numCheckTuples - 1];
            checkTuples[numCheckTuples - 1] = checkTuple;
            checkTuples[checkTupleIdx] = tmp;
        }
    }
}

