/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import java.util.Collection;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.storage.am.common.CheckTuple;
import org.apache.hyracks.storage.am.common.IIndexTestContext;
import org.apache.hyracks.storage.am.common.TestOperationCallback;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;

public abstract class IndexTestContext<T extends CheckTuple>
implements IIndexTestContext<T> {
    protected final ISerializerDeserializer[] fieldSerdes;
    protected final IIndex index;
    protected final ArrayTupleBuilder tupleBuilder;
    protected final ArrayTupleReference tuple = new ArrayTupleReference();
    protected final IIndexAccessor indexAccessor;

    public IndexTestContext(ISerializerDeserializer[] fieldSerdes, IIndex index) throws HyracksDataException {
        this.fieldSerdes = fieldSerdes;
        this.index = index;
        this.indexAccessor = index.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        this.tupleBuilder = new ArrayTupleBuilder(fieldSerdes.length);
    }

    @Override
    public int getFieldCount() {
        return this.fieldSerdes.length;
    }

    @Override
    public IIndexAccessor getIndexAccessor() {
        return this.indexAccessor;
    }

    @Override
    public ArrayTupleReference getTuple() {
        return this.tuple;
    }

    @Override
    public ArrayTupleBuilder getTupleBuilder() {
        return this.tupleBuilder;
    }

    @Override
    public ISerializerDeserializer[] getFieldSerdes() {
        return this.fieldSerdes;
    }

    @Override
    public IIndex getIndex() {
        return this.index;
    }

    @Override
    public void insertCheckTuple(T checkTuple, Collection<T> checkTuples) {
        checkTuples.add(checkTuple);
    }

    @Override
    public void deleteCheckTuple(T checkTuple, Collection<T> checkTuples) {
        checkTuples.remove(checkTuple);
    }
}

