/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import java.util.Random;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ITreeIndexTestWorker;
import org.apache.hyracks.storage.am.common.TestOperationCallback;
import org.apache.hyracks.storage.am.common.TestOperationSelector;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.datagen.DataGenThread;
import org.apache.hyracks.storage.am.common.datagen.TupleBatch;

public abstract class AbstractIndexTestWorker
extends Thread
implements ITreeIndexTestWorker {
    private final Random rnd;
    private final DataGenThread dataGen;
    private final TestOperationSelector opSelector;
    private final int numBatches;
    protected final IIndexAccessor indexAccessor;

    public AbstractIndexTestWorker(DataGenThread dataGen, TestOperationSelector opSelector, IIndex index, int numBatches) throws HyracksDataException {
        this.dataGen = dataGen;
        this.opSelector = opSelector;
        this.numBatches = numBatches;
        this.rnd = new Random();
        this.indexAccessor = index.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < this.numBatches; ++i) {
                TupleBatch batch = this.dataGen.getBatch();
                for (int j = 0; j < batch.size(); ++j) {
                    TestOperationSelector.TestOperation op = this.opSelector.getOp(this.rnd.nextInt());
                    ITupleReference tuple = batch.get(j);
                    this.performOp(tuple, op);
                }
                this.dataGen.releaseBatch(batch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void consumeCursorTuples(IIndexCursor cursor) throws HyracksDataException, IndexException {
        try {
            while (cursor.hasNext()) {
                cursor.next();
            }
        }
        finally {
            cursor.close();
        }
    }
}

