/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractIndexLifecycleTest {
    protected IIndex index;

    protected abstract boolean persistentStateExists() throws Exception;

    protected abstract boolean isEmptyIndex() throws Exception;

    protected abstract void performInsertions() throws Exception;

    protected abstract void checkInsertions() throws Exception;

    protected abstract void clearCheckableInsertions() throws Exception;

    @Before
    public abstract void setup() throws Exception;

    @After
    public abstract void tearDown() throws Exception;

    @Test
    public void validSequenceTest() throws Exception {
        this.index.create();
        Assert.assertTrue((boolean)this.persistentStateExists());
        this.index.create();
        Assert.assertTrue((boolean)this.persistentStateExists());
        this.index.activate();
        Assert.assertTrue((boolean)this.isEmptyIndex());
        this.performInsertions();
        this.checkInsertions();
        this.clearCheckableInsertions();
        this.index.clear();
        Assert.assertTrue((boolean)this.isEmptyIndex());
        this.performInsertions();
        this.index.deactivate();
        this.index.activate();
        this.checkInsertions();
        this.index.deactivate();
        this.index.destroy();
        Assert.assertFalse((boolean)this.persistentStateExists());
        this.index.destroy();
        Assert.assertFalse((boolean)this.persistentStateExists());
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest1() throws Exception {
        this.index.create();
        this.index.activate();
        this.index.create();
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest2() throws Exception {
        this.index.create();
        this.index.activate();
        this.index.destroy();
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest3() throws Exception {
        this.index.create();
        this.index.clear();
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest4() throws Exception {
        this.index.clear();
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest5() throws Exception {
        this.index.create();
        this.index.activate();
        this.index.activate();
    }

    @Test(expected=HyracksDataException.class)
    public void invalidSequenceTest6() throws Exception {
        this.index.create();
        this.index.activate();
        this.index.deactivate();
        this.index.deactivate();
    }
}

