/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.util.SerdeUtils;
import org.apache.hyracks.storage.am.common.IIndexTestWorkerFactory;
import org.apache.hyracks.storage.am.common.IndexMultiThreadTestDriver;
import org.apache.hyracks.storage.am.common.TestWorkloadConf;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.junit.Test;

public abstract class OrderedIndexMultiThreadTest {
    protected final Logger LOGGER = Logger.getLogger(OrderedIndexMultiThreadTest.class.getName());
    protected final int REGULAR_NUM_THREADS = Runtime.getRuntime().availableProcessors();
    protected final int EXCESSIVE_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 4;
    protected final int NUM_OPERATIONS = 200;
    protected ArrayList<TestWorkloadConf> workloadConfs = this.getTestWorkloadConf();

    protected abstract void setUp() throws HyracksDataException;

    protected abstract void tearDown() throws HyracksDataException;

    protected abstract IIndex createIndex(ITypeTraits[] var1, IBinaryComparatorFactory[] var2, int[] var3) throws TreeIndexException, HyracksDataException;

    protected abstract IIndexTestWorkerFactory getWorkerFactory();

    protected abstract ArrayList<TestWorkloadConf> getTestWorkloadConf();

    protected abstract String getIndexTypeName();

    protected void runTest(ISerializerDeserializer[] fieldSerdes, int numKeys, int numThreads, TestWorkloadConf conf, String dataMsg) throws InterruptedException, TreeIndexException, HyracksDataException {
        this.setUp();
        if (this.LOGGER.isLoggable(Level.INFO)) {
            String indexTypeName = this.getIndexTypeName();
            this.LOGGER.info(indexTypeName + " MultiThread Test:\nData: " + dataMsg + "; Threads: " + numThreads + "; Workload: " + conf.toString() + ".");
        }
        ITypeTraits[] typeTraits = SerdeUtils.serdesToTypeTraits((ISerializerDeserializer[])fieldSerdes);
        IBinaryComparatorFactory[] cmpFactories = SerdeUtils.serdesToComparatorFactories((ISerializerDeserializer[])fieldSerdes, (int)numKeys);
        int[] bloomFilterKeyFields = new int[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            bloomFilterKeyFields[i] = i;
        }
        IIndex index = this.createIndex(typeTraits, cmpFactories, bloomFilterKeyFields);
        IIndexTestWorkerFactory workerFactory = this.getWorkerFactory();
        int batchSize = 200 / numThreads / 4;
        IndexMultiThreadTestDriver driver = new IndexMultiThreadTestDriver(index, workerFactory, fieldSerdes, conf.ops, conf.opProbs);
        driver.init();
        long[] times = driver.run(numThreads, 1, 200, batchSize);
        index.validate();
        driver.deinit();
        if (this.LOGGER.isLoggable(Level.INFO)) {
            this.LOGGER.info("BTree MultiThread Test Time: " + times[0] + "ms");
        }
        this.tearDown();
    }

    @Test
    public void oneIntKeyAndValue() throws InterruptedException, TreeIndexException, HyracksDataException {
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int numKeys = 1;
        String dataMsg = "One Int Key And Value";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, numKeys, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, numKeys, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }

    @Test
    public void oneStringKeyAndValue() throws InterruptedException, TreeIndexException, HyracksDataException {
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer(), new UTF8StringSerializerDeserializer()};
        int numKeys = 1;
        String dataMsg = "One String Key And Value";
        for (TestWorkloadConf conf : this.workloadConfs) {
            this.runTest(fieldSerdes, numKeys, this.REGULAR_NUM_THREADS, conf, dataMsg);
            this.runTest(fieldSerdes, numKeys, this.EXCESSIVE_NUM_THREADS, conf, dataMsg);
        }
    }
}

