/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.btree.AbstractOperationCallbackTest;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractSearchOperationCallbackTest
extends AbstractOperationCallbackTest {
    private static final int NUM_TASKS = 2;
    protected final Lock lock = new ReentrantLock(true);
    protected final Condition condition = this.lock.newCondition();
    protected ExecutorService executor;
    protected boolean insertTaskStarted = false;

    @Override
    @Before
    public void setup() throws Exception {
        this.executor = Executors.newFixedThreadPool(2);
        super.setup();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        super.tearDown();
    }

    @Test
    public void searchCallbackTest() throws Exception {
        Future<Boolean> insertFuture = this.executor.submit(new InsertionTask());
        Future<Boolean> searchFuture = this.executor.submit(new SearchTask());
        Assert.assertTrue((boolean)searchFuture.get());
        Assert.assertTrue((boolean)insertFuture.get());
    }

    private class InsertionTask
    implements Callable<Boolean> {
        private final IIndexAccessor accessor;
        private final ArrayTupleBuilder builder;
        private final ArrayTupleReference tuple;

        public InsertionTask() throws HyracksDataException {
            this.accessor = AbstractSearchOperationCallbackTest.this.index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.builder = new ArrayTupleBuilder(1);
            this.tuple = new ArrayTupleReference();
        }

        @Override
        public Boolean call() throws Exception {
            AbstractSearchOperationCallbackTest.this.lock.lock();
            try {
                AbstractSearchOperationCallbackTest.this.insertTaskStarted = true;
                this.insertIntTupleRange(101, 200);
                AbstractSearchOperationCallbackTest.this.condition.signal();
                AbstractSearchOperationCallbackTest.this.condition.await();
                this.insertIntTupleRange(1, 100);
                AbstractSearchOperationCallbackTest.this.condition.signal();
                AbstractSearchOperationCallbackTest.this.condition.await();
                this.insertIntTupleRange(201, 300);
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{151});
                this.accessor.delete((ITupleReference)this.tuple);
                AbstractSearchOperationCallbackTest.this.condition.signal();
            }
            finally {
                AbstractSearchOperationCallbackTest.this.lock.unlock();
            }
            return true;
        }

        private void insertIntTupleRange(int begin, int end) throws Exception {
            if (end < begin) {
                throw new IllegalArgumentException("Invalid range: [" + begin + ", " + end + "]");
            }
            int i = begin;
            while (i <= end) {
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{i++});
                this.accessor.insert((ITupleReference)this.tuple);
            }
        }
    }

    private class SearchTask
    implements Callable<Boolean> {
        private final ISearchOperationCallback cb = new SynchronizingSearchOperationCallback();
        private final IIndexAccessor accessor;
        private final IIndexCursor cursor;
        private final RangePredicate predicate;
        private final ArrayTupleBuilder builder;
        private final ArrayTupleReference tuple;
        private boolean blockOnHigh;
        private int blockingValue;
        private int expectedAfterBlock;

        public SearchTask() throws HyracksDataException {
            this.accessor = AbstractSearchOperationCallbackTest.this.index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, this.cb);
            this.cursor = this.accessor.createSearchCursor(false);
            this.predicate = new RangePredicate();
            this.builder = new ArrayTupleBuilder(1);
            this.tuple = new ArrayTupleReference();
            this.blockOnHigh = false;
            this.blockingValue = -1;
            this.expectedAfterBlock = -1;
        }

        @Override
        public Boolean call() throws Exception {
            AbstractSearchOperationCallbackTest.this.lock.lock();
            try {
                if (!AbstractSearchOperationCallbackTest.this.insertTaskStarted) {
                    AbstractSearchOperationCallbackTest.this.condition.await();
                }
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{101});
                this.predicate.setLowKey((ITupleReference)this.tuple, true);
                this.predicate.setHighKey(null, true);
                this.accessor.search(this.cursor, (ISearchPredicate)this.predicate);
                this.consumeIntTupleRange(101, 101, true, 101);
                this.consumeIntTupleRange(102, 151, true, 152);
                this.consumeIntTupleRange(153, 300, false, -1);
                this.cursor.close();
            }
            finally {
                AbstractSearchOperationCallbackTest.this.lock.unlock();
            }
            return true;
        }

        private void consumeIntTupleRange(int begin, int end, boolean blockOnHigh, int expectedAfterBlock) throws Exception {
            if (end < begin) {
                throw new IllegalArgumentException("Invalid range: [" + begin + ", " + end + "]");
            }
            for (int i = begin; i <= end; ++i) {
                if (blockOnHigh && i == end) {
                    this.blockOnHigh = true;
                    this.blockingValue = end;
                    this.expectedAfterBlock = expectedAfterBlock;
                }
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{i});
                if (!this.cursor.hasNext()) {
                    Assert.fail((String)"Failed to consume entire tuple range since cursor is exhausted.");
                }
                this.cursor.next();
                if (this.blockOnHigh) {
                    TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{expectedAfterBlock});
                }
                Assert.assertEquals((long)0L, (long)AbstractSearchOperationCallbackTest.this.cmp.compare((ITupleReference)this.tuple, this.cursor.getTuple()));
            }
        }

        private class SynchronizingSearchOperationCallback
        implements ISearchOperationCallback {
            private SynchronizingSearchOperationCallback() {
            }

            public boolean proceed(ITupleReference tuple) throws HyracksDataException {
                Assert.assertEquals((long)0L, (long)AbstractSearchOperationCallbackTest.this.cmp.compare((ITupleReference)SearchTask.this.tuple, tuple));
                return false;
            }

            public void reconcile(ITupleReference tuple) throws HyracksDataException {
                Assert.assertEquals((long)0L, (long)AbstractSearchOperationCallbackTest.this.cmp.compare((ITupleReference)SearchTask.this.tuple, tuple));
                if (SearchTask.this.blockOnHigh) {
                    try {
                        TupleUtils.createIntegerTuple((ArrayTupleBuilder)SearchTask.this.builder, (ArrayTupleReference)SearchTask.this.tuple, (int[])new int[]{SearchTask.this.expectedAfterBlock});
                    }
                    catch (HyracksDataException e) {
                        e.printStackTrace();
                    }
                    AbstractSearchOperationCallbackTest.this.condition.signal();
                    AbstractSearchOperationCallbackTest.this.condition.awaitUninterruptibly();
                    SearchTask.this.blockOnHigh = false;
                }
            }

            public void cancel(ITupleReference tuple) {
                try {
                    TupleUtils.createIntegerTuple((ArrayTupleBuilder)SearchTask.this.builder, (ArrayTupleReference)SearchTask.this.tuple, (int[])new int[]{SearchTask.this.blockingValue});
                    Assert.assertEquals((long)0L, (long)AbstractSearchOperationCallbackTest.this.cmp.compare(tuple, (ITupleReference)SearchTask.this.tuple));
                    TupleUtils.createIntegerTuple((ArrayTupleBuilder)SearchTask.this.builder, (ArrayTupleReference)SearchTask.this.tuple, (int[])new int[]{SearchTask.this.expectedAfterBlock});
                }
                catch (HyracksDataException e) {
                    e.printStackTrace();
                }
            }

            public void complete(ITupleReference tuple) throws HyracksDataException {
            }

            public void before(ITupleReference tuple) throws HyracksDataException {
            }
        }
    }
}

